/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller;

import com.turborilla.mule.Properties;
import com.turborilla.mule.controller.PlayerController;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Wampus;
import com.turborilla.mule.network.Client;
import com.turborilla.mule.sound.SoundPlayer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WampusMenu {
    private ArrayList<MenuItem> items = new ArrayList();
    private int selection;
    private boolean visible;
    private String rewardText;
    private float introTimer;
    private boolean pressContinue;
    private Player player;

    public WampusMenu() {
        this.items.add(new MenuItem("Accept the treasure worth $200"));
        this.items.add(new MenuItem("Search the cave for smithore"));
        this.visible = false;
        this.introTimer = 0.0f;
    }

    public void show(Player player, Wampus wampus) {
        this.selection = 0;
        this.visible = true;
        this.introTimer = 0.5f;
        this.rewardText = null;
        this.pressContinue = true;
        this.rewardText = "IT GIVES YOU $" + wampus.getMoneyReward() + " TO LET IT GO";
        this.player = player;
    }

    public void hide() {
        this.visible = false;
        this.player = null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void update(PlayerController playerController, Wampus wampus, Client client, SoundPlayer soundPlayer) {
        if (!this.visible) {
            return;
        }
        if (this.introTimer > 0.0f) {
            this.introTimer -= Properties.mule.delta;
            if (this.introTimer <= 0.0f) {
                this.introTimer = 0.0f;
            } else {
                return;
            }
        }
        if (this.pressContinue) {
            if (playerController.isActionButtonPressed()) {
                this.hide();
            }
        } else {
            if (playerController.isDownPressed()) {
                this.selection = (this.selection + 1) % this.items.size();
            } else if (playerController.isUpPressed()) {
                this.selection = (this.selection + this.items.size() - 1) % this.items.size();
            }
            if (playerController.isActionButtonPressed()) {
                this.rewardText = this.selection == 0 ? "It gives you $200 to let it free again" : "You found " + wampus.getSmithoreReward() + " smithore";
                this.pressContinue = true;
            }
        }
    }

    public boolean isIntroComplete() {
        return this.introTimer == 0.0f;
    }

    public Player getPlayer() {
        return this.player;
    }

    public String getRewardText() {
        return this.rewardText;
    }

    public ArrayList<MenuItem> getItems() {
        return this.items;
    }

    public int getSelection() {
        return this.selection;
    }

    public MenuItem getSelectedItem() {
        return this.items.get(this.selection);
    }

    public class MenuItem {
        private String text;

        public MenuItem(String string) {
            this.text = string;
        }

        public String getText() {
            return this.text;
        }
    }
}

