/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller;

import com.turborilla.mule.Properties;
import com.turborilla.mule.ai.AIPlayerController;
import com.turborilla.mule.ai.AbstractAI;
import com.turborilla.mule.ai.adam.AdamAI;
import com.turborilla.mule.ai.search.SearchAI;
import com.turborilla.mule.controller.GameController;
import com.turborilla.mule.controller.GameModelSerializer;
import com.turborilla.mule.controller.InputPlayerController;
import com.turborilla.mule.controller.RemotePlayerController;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Race;
import com.turborilla.mule.model.Spectator;
import com.turborilla.mule.model.User;
import com.turborilla.mule.network.Client;
import com.turborilla.mule.network.MessageReceiver;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.view.GameInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Logger;

public class UserController
extends MessageReceiver {
    private Logger logger = Logger.getLogger("mule");
    private GameController controller;
    private GameModel model;
    private GameInput input;
    private int myUserNumber;
    private ArrayList<String> aiPlayerNames;

    public UserController(GameController gameController, GameInput gameInput) {
        this.controller = gameController;
        this.input = gameInput;
        this.aiPlayerNames = new ArrayList();
        this.aiPlayerNames.add("<D.A.N.>");
        this.aiPlayerNames.add("<B.I.L.L.>");
        this.aiPlayerNames.add("<J.I.M.>");
        this.aiPlayerNames.add("<A.L.A.N.>");
        this.aiPlayerNames.add("<A.D.A.M.>");
    }

    public void setModel(GameModel gameModel) {
        this.model = gameModel;
        for (User user : gameModel.getUsers()) {
            this.classifyUser(user);
        }
    }

    public void addAiPlayer() {
        if (this.model.getMyUser() != null && !this.model.isGameStarted()) {
            String string = "Computer";
            if (!this.aiPlayerNames.isEmpty()) {
                Random random = new Random();
                int n = random.nextInt(this.aiPlayerNames.size());
                string = this.aiPlayerNames.get(n);
                this.aiPlayerNames.remove(n);
            }
            this.controller.getClient().sendTCP(new TCPMessage.AIJoinMessage(string));
        }
    }

    public void apply(TCPMessage.ServerInfoMessage serverInfoMessage) {
        if (!serverInfoMessage.version.equals("1.3.6")) {
            this.controller.requestClose("Server has different game version.\n Your version: 1.3.6\nServer version: " + serverInfoMessage.version, false);
            return;
        }
        this.controller.getClient().setClientId(serverInfoMessage.clientId);
        this.logger.info("My client id is " + serverInfoMessage.clientId);
        if (this.controller.isServer()) {
            this.controller.getServer().setServerClient(serverInfoMessage.clientId);
        }
    }

    public void apply(TCPMessage.JoinMessage joinMessage) {
        User user = this.model.getUser(joinMessage.getUserNumber());
        if (user == null) {
            user = this.model.createSpectator(new User(joinMessage.userName, joinMessage.userID, joinMessage.getUserNumber(), joinMessage.race));
            if (joinMessage.serverUser) {
                this.model.setServerUser(user);
            }
            if (this.controller.isServer() && this.model.getGameInfo().getGameID() != 0L) {
                this.controller.getMasterClient().sendUserJoin(joinMessage.userID, joinMessage.getUserNumber(), joinMessage.userName);
            }
            if (!joinMessage.myJoin) {
                this.controller.sendSystemChatMessage("%s visits", user);
            }
        }
        if (joinMessage.myJoin) {
            this.myUserNumber = joinMessage.getUserNumber();
        }
        this.classifyUser(user);
    }

    public void apply(TCPMessage.PlayerJoinMessage playerJoinMessage) {
        User user = this.model.getUser(playerJoinMessage.getUserNumber());
        if (user == null) {
            this.logger.severe("Player join from unknown user number " + playerJoinMessage.getUserNumber());
            return;
        }
        this.logger.info(user.toString() + " joins the players");
        boolean bl = this.model.getServerUser() == user;
        this.model.removeUser(playerJoinMessage.getUserNumber());
        Player player = this.model.createPlayer(user);
        int n = player.getPlayerIndex() + 1;
        this.controller.sendSystemChatMessage("%s joined the game in slot " + n, player);
        if (bl) {
            this.model.setServerUser(player);
        }
        this.classifyUser(player);
    }

    public void apply(TCPMessage.PlayerUnjoinMessage playerUnjoinMessage) {
        User user = this.model.getUser(playerUnjoinMessage.getUserNumber());
        if (user == null) {
            this.logger.severe("Player unjoin from unknown user number " + playerUnjoinMessage.getUserNumber());
            return;
        }
        if (user.isSpectator()) {
            this.logger.severe("Player unjoin from spectator " + user);
            return;
        }
        this.logger.info(user.toString() + " unjoins and becomes a spectator");
        boolean bl = this.model.getServerUser() == user;
        this.model.removeUser(playerUnjoinMessage.getUserNumber());
        Spectator spectator = this.model.createSpectator(user);
        this.controller.sendSystemChatMessage("%s unjoined the game", spectator);
        if (bl) {
            this.model.setServerUser(spectator);
        }
        this.classifyUser(spectator);
    }

    public void apply(TCPMessage.AIJoinMessage aIJoinMessage) {
        if (this.model.getUser(aIJoinMessage.getUserNumber()) == null) {
            User user = new User(aIJoinMessage.name, 0L, aIJoinMessage.getUserNumber(), Race.raceMechanical.getIdentifier());
            Player player = this.model.createPlayer(user);
            this.controller.sendSystemChatMessage("Added computer player %s", player);
            this.setAiPlayer(player);
            if (this.controller.isServer()) {
                if (this.model.getGameInfo().getGameID() != 0L) {
                    this.controller.getMasterClient().sendUserJoin(player.getUserId(), player.getUserNumber(), player.getName());
                }
            } else {
                this.classifyUser(player);
            }
        } else {
            this.logger.info("Can't create AI player, user " + aIJoinMessage.getUserNumber() + " already exists.");
        }
    }

    public void apply(TCPMessage.ReconnectJoinMessage reconnectJoinMessage) {
        User user = this.model.getUser(reconnectJoinMessage.getUserNumber());
        if (user == null) {
            return;
        }
        this.logger.info(user.toString() + " reconnects.");
        this.controller.sendSystemChatMessage("%s reconnects", user);
    }

    public void apply(TCPMessage.GameModelMessage gameModelMessage) {
        try {
            GameModelSerializer gameModelSerializer = new GameModelSerializer();
            this.model = gameModelSerializer.loadModel(gameModelMessage.serializedModel);
            this.controller.setModel(this.model);
        }
        catch (IOException iOException) {
            this.logger.severe("Couldn't read game model message: " + iOException.getMessage());
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.severe("Couldn't read game model message: " + classNotFoundException.getMessage());
            classNotFoundException.printStackTrace();
        }
    }

    public void apply(TCPMessage.UserLeftMessage userLeftMessage) {
        User user = this.model.getUser(userLeftMessage.getUserNumber());
        if (user == null) {
            return;
        }
        this.controller.sendSystemChatMessage("%s left the game", user);
        this.removeUser(user, true);
    }

    public void apply(TCPMessage.UserDisconnectedMessage userDisconnectedMessage) {
        User user = this.model.getUser(userDisconnectedMessage.disconnectedUserNumber);
        if (user == null) {
            return;
        }
        this.controller.sendSystemChatMessage("%s was disconnected", user);
        this.removeUser(user, false);
    }

    public void apply(TCPMessage.KickUserMessage kickUserMessage) {
        User user = this.model.getUser(kickUserMessage.kickUserNumber);
        if (user == null) {
            return;
        }
        if (user == this.model.getMyUser()) {
            this.controller.requestClose("You were kicked from the game", true);
            return;
        }
        if (this.removeUser(user, true)) {
            this.controller.sendSystemChatMessage("%s was kicked", user);
        }
    }

    private boolean removeUser(User user, boolean bl) {
        if (this.model.isGameOver()) {
            this.controller.userRemoved(user);
            return false;
        }
        if (this.controller.isServer()) {
            if (this.model.getGameInfo().getGameID() != 0L) {
                this.controller.getMasterClient().sendUserLeft(user.getUserId(), user.getUserNumber());
            }
            if (bl) {
                this.controller.getServer().removeUser(user.getUserNumber());
            }
        } else if (user == this.model.getServerUser()) {
            this.controller.requestClose("The host (" + user.getName() + ") closed the game", true);
            return true;
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            if (this.model.isGameStarted()) {
                if (!this.setAiPlayer(player)) {
                    return false;
                }
            } else {
                if (player.getController() instanceof AIPlayerController) {
                    this.aiPlayerNames.add(player.getName());
                }
                this.model.removeUser(user.getUserNumber());
            }
        } else {
            this.model.removeUser(user.getUserNumber());
        }
        this.controller.userRemoved(user);
        this.controller.beginNextPhase();
        return true;
    }

    private void classifyUser(User user) {
        if (this.myUserNumber == user.getUserNumber()) {
            if (user instanceof Player) {
                Player player = (Player)user;
                player.setController(new InputPlayerController(this.input));
            }
            this.model.setMyUser(user);
        } else {
            if (user instanceof Player) {
                Player player = (Player)user;
                player.setController(new RemotePlayerController());
            }
            this.model.setRemoteUser(user);
        }
    }

    public void setMyUserNumber(int n) {
        this.myUserNumber = n;
    }

    public boolean setAiPlayer(Player player) {
        boolean bl;
        if (player.getController() instanceof AIPlayerController) {
            return false;
        }
        boolean bl2 = bl = player.getController() != null;
        if (bl) {
            this.logger.info(player.toString() + " is taken over by an AI player");
            this.controller.sendSystemChatMessage("Computer takes over %s", player);
        } else {
            this.logger.info(player.toString() + " is an AI player");
        }
        if (this.controller.isServer()) {
            Client client = this.controller.getClient();
            AbstractAI abstractAI = null;
            if (Properties.mule.useAdamAI) {
                this.logger.info(player.getName() + " is using the Adam's AI");
                abstractAI = new AdamAI(this.model.getAiSystem(), player, this.model);
            } else {
                this.logger.info(player.getName() + " is using the Search AI");
                abstractAI = new SearchAI(this.model.getAiSystem(), player, this.model);
            }
            AIPlayerController aIPlayerController = new AIPlayerController(abstractAI);
            player.setController(aIPlayerController);
            this.controller.getServer().addUserToClient(player.getUserNumber(), true, client.getClientId());
            if (bl) {
                aIPlayerController.getAi().beginPhase(this.model.getPhase(), this.model);
                if (this.model.getMyPlayer().isReady() && !player.isReady()) {
                    player.send(client, new TCPMessage.ReadyMessage(this.controller.getFrame()));
                }
            }
        }
        this.model.setAiPlayer(player, this.controller.isServer());
        return true;
    }
}

