/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller;

import com.turborilla.mule.controller.PlayerController;
import com.turborilla.mule.controller.PlayerControllerState;
import com.turborilla.mule.model.Avatar;
import com.turborilla.mule.model.util.Vec2;
import java.io.Serializable;
import java.util.ArrayList;

public class TargetPlayerController
extends PlayerController {
    private static final long serialVersionUID = 1L;
    private Avatar avatar;
    private PlayerControllerState state;
    private Target target;
    private ArrayList<Target> targets;
    private float targetSignX;
    private float targetSignY;
    private float targetRadius;
    private boolean enabled;

    public TargetPlayerController(Avatar avatar) {
        this(avatar, new PlayerControllerState());
    }

    public TargetPlayerController(Avatar avatar, PlayerControllerState playerControllerState) {
        this.avatar = avatar;
        this.targets = new ArrayList();
        this.state = playerControllerState;
        this.enabled = true;
        this.targetRadius = 0.0f;
    }

    public Vec2 addTarget(float f, float f2) {
        Target target = new Target(f, f2);
        this.targets.add(target);
        return target.pos;
    }

    public Vec2 addTarget(Vec2 vec2) {
        return this.addTarget(vec2.x, vec2.y);
    }

    public void clearTargets() {
        this.target = null;
        this.targets.clear();
    }

    public int numTargets() {
        return this.targets.size();
    }

    public void setTargetRadius(float f) {
        this.targetRadius = f;
    }

    public void update() {
        if (this.targets.isEmpty() || !this.enabled) {
            this.state.setUp(false);
            this.state.setDown(false);
            this.state.setLeft(false);
            this.state.setRight(false);
        } else {
            if (this.target == null) {
                this.target = this.targets.get(0);
                this.targetSignX = this.target.pos.x > this.avatar.getPosition().x ? 1.0f : -1.0f;
                this.targetSignY = this.target.pos.y > this.avatar.getPosition().y ? 1.0f : -1.0f;
            }
            float f = this.target.pos.x - this.targetSignX * this.targetRadius - this.avatar.getPosition().x;
            float f2 = this.target.pos.y - this.targetSignY * this.targetRadius - this.avatar.getPosition().y;
            this.state.setUp(this.targetSignY < 0.0f && f2 < 0.0f);
            this.state.setDown(this.targetSignY > 0.0f && f2 > 0.0f);
            this.state.setRight(this.targetSignX > 0.0f && f > 0.0f);
            this.state.setLeft(this.targetSignX < 0.0f && f < 0.0f);
            if (!(this.state.isUp() || this.state.isDown() || this.state.isLeft() || this.state.isRight())) {
                this.target = null;
                this.targets.remove(0);
                this.update();
            }
        }
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public boolean isActionButtonPressed() {
        return false;
    }

    public boolean isActionButtonDown() {
        return false;
    }

    public boolean isDown() {
        return this.state.isDown();
    }

    public boolean isDownPressed() {
        return this.state.isDownPressed();
    }

    public boolean isLeft() {
        return this.state.isLeft();
    }

    public boolean isLeftPressed() {
        return this.state.isLeftPressed();
    }

    public boolean isRemote() {
        return false;
    }

    public boolean isRight() {
        return this.state.isRight();
    }

    public boolean isRightPressed() {
        return false;
    }

    public boolean isUp() {
        return this.state.isUp();
    }

    public boolean isUpPressed() {
        return false;
    }

    private static final class Target
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Vec2 pos;

        public Target(float f, float f2) {
            this.pos = new Vec2(f, f2);
        }
    }
}

