/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller;

import com.turborilla.mule.Properties;
import com.turborilla.mule.model.GameModel;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GameModelSerializer {
    private static Logger logger = Logger.getLogger("mule");
    private static Thread writerThread;

    public byte[] serializeModel(GameModel gameModel) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
        objectOutputStream.writeObject(gameModel);
        gZIPOutputStream.finish();
        objectOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        logger.info("Packed game model to " + byArray.length + " bytes");
        return byteArrayOutputStream.toByteArray();
    }

    public void saveModelToFile(final byte[] byArray) {
        logger.info("Saving game model to file");
        if (writerThread != null && writerThread.isAlive()) {
            writerThread.interrupt();
        }
        writerThread = new Thread(){

            public void run() {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(Properties.mule.modelFile);
                    fileOutputStream.write(byArray);
                }
                catch (Exception exception) {
                    logger.warning(exception.getMessage());
                }
            }
        };
        writerThread.start();
    }

    public GameModel loadModel(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return this.deserializeModel(byteArrayInputStream);
    }

    public GameModel loadModel(String string) throws IOException, ClassNotFoundException {
        logger.info("Loading game model from file");
        if (writerThread != null && writerThread.isAlive()) {
            logger.info("Waiting for game model save to file");
            try {
                writerThread.join();
            }
            catch (InterruptedException interruptedException) {
                logger.severe("Interrupted wait for game model save to file. " + interruptedException.getStackTrace());
            }
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        return this.deserializeModel(bufferedInputStream);
    }

    private GameModel deserializeModel(InputStream inputStream) throws IOException, ClassNotFoundException {
        GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
        ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
        GameModel gameModel = (GameModel)objectInputStream.readObject();
        objectInputStream.close();
        return gameModel;
    }
}

