/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.simulator;

import com.turborilla.mule.ai.simulator.SimulatedMap;
import com.turborilla.mule.ai.simulator.SimulatedPlayer;
import com.turborilla.mule.ai.simulator.SimulatedShop;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SimulatedState {
    SimulatedMap map = new SimulatedMap();
    SimulatedShop shop = new SimulatedShop();
    ArrayList<SimulatedPlayer> players = new ArrayList();
    int myPlayer;
    int round;
    int lastRound;

    public void initialize(GameModel gameModel, Player player) {
        this.map.initialize(gameModel.getMap());
        this.shop.initialize(gameModel.getShop());
        this.resize(gameModel.getPlayers().size());
        ArrayList<Player> arrayList = gameModel.getPlayersInRankOrder();
        for (int i = 0; i < arrayList.size(); ++i) {
            Player player2 = arrayList.get(i);
            SimulatedPlayer simulatedPlayer = this.players.get(i);
            simulatedPlayer.initialize(player2, i, this.map);
            if (player2 != player) continue;
            this.myPlayer = i;
        }
        this.round = gameModel.getRound();
        this.lastRound = gameModel.getGameInfo().getLastRound();
    }

    public void copy(SimulatedState simulatedState) {
        this.map.copy(simulatedState.map);
        this.shop.copy(simulatedState.shop);
        this.resize(simulatedState.players.size());
        for (int i = 0; i < this.players.size(); ++i) {
            this.players.get(i).copy(simulatedState.players.get(i));
        }
        this.myPlayer = simulatedState.myPlayer;
        this.round = simulatedState.round;
        this.lastRound = simulatedState.lastRound;
    }

    private void resize(int n) {
        if (this.players.size() != n) {
            this.players.clear();
            for (int i = 0; i < n; ++i) {
                this.players.add(new SimulatedPlayer());
            }
        }
    }

    public SimulatedMap getMap() {
        return this.map;
    }

    public ArrayList<SimulatedPlayer> getPlayers() {
        return this.players;
    }

    public int getRound() {
        return this.round;
    }

    public SimulatedShop getShop() {
        return this.shop;
    }

    public SimulatedPlayer getMyPlayer() {
        return this.players.get(this.myPlayer);
    }

    public SimulatedPlayer getPlayer(Player player) {
        for (SimulatedPlayer simulatedPlayer : this.players) {
            if (simulatedPlayer.player != player) continue;
            return simulatedPlayer;
        }
        return null;
    }

    public void simulate(boolean bl) {
        for (SimulatedPlayer simulatedPlayer2 : this.players) {
            if (bl) {
                simulatedPlayer2.useFood(this.round);
            }
            simulatedPlayer2.useEnergy();
            simulatedPlayer2.spoil();
        }
        this.map.produce(this.players);
        this.shop.estimateCrystitePrice();
        for (SimulatedPlayer simulatedPlayer2 : this.players) {
            simulatedPlayer2.sellSmithore(this.shop);
            simulatedPlayer2.sellCrystite(this.shop);
        }
        SimulatedPlayer simulatedPlayer = this.players.get(this.myPlayer);
        simulatedPlayer.sellFood(this.shop, this.round);
        simulatedPlayer.sellEnergy(this.shop, this.round == this.lastRound);
        for (int i = this.players.size() - 1; i >= 0; --i) {
            SimulatedPlayer simulatedPlayer2;
            simulatedPlayer2 = this.players.get(i);
            simulatedPlayer2.buyFood(this.shop, this.round);
            simulatedPlayer2.buyEnergy(this.shop, this.round == this.lastRound);
        }
        this.getMyPlayer().calcPoints(this.shop);
        this.shop.buildMules();
        ++this.round;
    }

    public void print() {
        System.out.print("Shop ");
        System.out.print("Metal: " + this.shop.smithore + " $" + this.shop.smithorePrices.price + ", ");
        System.out.print("Crys: " + this.shop.crystite + " $" + this.shop.crystitePrices.price + ", ");
        System.out.print("Ergy: " + this.shop.energy + " $" + this.shop.energyPrices.price + ", ");
        System.out.print("Food: " + this.shop.food + " $" + this.shop.foodPrices.price + ", ");
        System.out.print("Mules: " + this.shop.numMules + " $" + this.shop.mulePrice);
        System.out.println();
        for (SimulatedPlayer simulatedPlayer : this.getPlayers()) {
            System.out.print(simulatedPlayer.player.getName());
            if (simulatedPlayer == this.getMyPlayer()) {
                System.out.print(" <me>");
            }
            System.out.print(" - ");
            System.out.print("Smith: " + simulatedPlayer.smithore + ", ");
            System.out.print("Crys: " + simulatedPlayer.crystite + ", ");
            System.out.print("Ener: " + simulatedPlayer.energy + " (buy " + simulatedPlayer.energyBoughtTotal + "), ");
            System.out.print("Food: " + simulatedPlayer.food + " (buy " + simulatedPlayer.foodBoughtTotal + "), ");
            System.out.print("Fact: ");
            for (Resource resource : Resource.values()) {
                System.out.print(resource.name.charAt(0) + "=" + simulatedPlayer.numFactories(resource) + ",");
            }
            System.out.print(" ");
            System.out.print("Money: $" + simulatedPlayer.money + ", ");
            System.out.print("Points: " + simulatedPlayer.points);
            System.out.println();
        }
    }
}

