/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.simulator;

import com.turborilla.mule.Properties;
import com.turborilla.mule.ai.simulator.SimulatedMap;
import com.turborilla.mule.ai.simulator.SimulatedShop;
import com.turborilla.mule.ai.simulator.SimulatedTile;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.Factory;
import com.turborilla.mule.model.map.PlanetTile;
import java.util.Arrays;

final class SimulatedPlayer {
    public Player player;
    public int arrayIndex;
    public int food;
    public int energy;
    public int smithore;
    public int crystite;
    public int energyRequirement;
    public int money;
    public int landPoints;
    public int factoryPoints;
    public int points;
    public int foodUsage;
    public int foodBoughtTotal;
    public int energyBoughtTotal;
    public int[] numFactories = new int[Resource.values().length];

    SimulatedPlayer() {
    }

    public void initialize(Player player, int n, SimulatedMap simulatedMap) {
        this.player = player;
        this.arrayIndex = n;
        this.food = player.getFood();
        this.energy = player.getEnergy();
        this.smithore = player.getSmithore();
        this.crystite = player.getCrystite();
        this.foodUsage = player.getUsage(Resource.Food);
        this.energyRequirement = player.getEnergyRequirement();
        this.money = player.getMoney();
        this.landPoints = 0;
        this.factoryPoints = 0;
        this.points = 0;
        this.foodBoughtTotal = 0;
        this.energyBoughtTotal = 0;
        Arrays.fill(this.numFactories, 0);
        for (PlanetTile planetTile : player.getOwnedTiles()) {
            SimulatedTile simulatedTile = simulatedMap.getTile(planetTile.getPosX(), planetTile.getPosY());
            Factory factory = planetTile.getFactory();
            Resource resource = factory == null ? null : factory.getResource();
            this.addTile(null, simulatedMap, simulatedTile, resource, 0, true);
        }
    }

    public void copy(SimulatedPlayer simulatedPlayer) {
        this.player = simulatedPlayer.player;
        this.arrayIndex = simulatedPlayer.arrayIndex;
        this.food = simulatedPlayer.food;
        this.energy = simulatedPlayer.energy;
        this.smithore = simulatedPlayer.smithore;
        this.crystite = simulatedPlayer.crystite;
        this.energyRequirement = simulatedPlayer.energyRequirement;
        this.money = simulatedPlayer.money;
        this.landPoints = simulatedPlayer.landPoints;
        this.factoryPoints = simulatedPlayer.factoryPoints;
        this.points = simulatedPlayer.points;
        this.foodBoughtTotal = simulatedPlayer.foodBoughtTotal;
        this.energyBoughtTotal = simulatedPlayer.energyBoughtTotal;
        for (int i = 0; i < this.numFactories.length; ++i) {
            this.numFactories[i] = simulatedPlayer.numFactories[i];
        }
    }

    public void addTile(SimulatedShop simulatedShop, SimulatedMap simulatedMap, SimulatedTile simulatedTile, Resource resource, int n, boolean bl) {
        if (simulatedTile.owner != this.arrayIndex) {
            simulatedTile.owner = this.arrayIndex;
            this.landPoints += Properties.mule.pointsPerLand;
        }
        simulatedTile.factoryResource = resource;
        if (resource != null) {
            if (!bl) {
                --simulatedShop.numMules;
                this.money -= n + resource.equipmentCost;
            }
            int n2 = resource.ordinal();
            this.numFactories[n2] = this.numFactories[n2] + 1;
            simulatedMap.updateAdjacencyBonus(simulatedTile);
            this.energyRequirement += resource.energyCost;
            this.factoryPoints += Properties.mule.pointsPerMule + resource.equipmentCost;
        }
    }

    public void useFood(int n) {
        this.food -= Properties.mule.foodRequirements[n];
    }

    public void useEnergy() {
        this.energy -= this.energyRequirement;
    }

    public void spoil() {
        if (this.food > 0) {
            this.food -= this.food / 2;
        }
        if (this.energy > 0) {
            this.energy -= this.energy / 4;
        }
        if (this.smithore > 50) {
            this.smithore = 50;
        }
        if (this.crystite > 50) {
            this.crystite = 50;
        }
    }

    public int numFactories(Resource resource) {
        return this.numFactories[resource.ordinal()];
    }

    public void sellFood(SimulatedShop simulatedShop, int n) {
        int n2 = Properties.mule.foodRequirements[n + 1];
        if (this.food > n2) {
            int n3 = this.food - n2;
            this.money += n3 * simulatedShop.foodPrices.price;
            simulatedShop.food += n3;
            this.food = n2;
        }
    }

    public void buyFood(SimulatedShop simulatedShop, int n) {
        int n2 = Properties.mule.foodRequirements[n + 1];
        if (this.food < n2) {
            int n3 = n2 - this.food;
            this.money -= n3 * simulatedShop.foodPrices.sellPrice;
            if (n3 > simulatedShop.food) {
                n3 = simulatedShop.food;
            }
            this.foodBoughtTotal += n3;
            simulatedShop.food -= n3;
            this.food += n3;
        }
    }

    private int getEnergyNeeded(boolean bl) {
        if (bl) {
            return 0;
        }
        return this.energyRequirement + 1;
    }

    public void sellEnergy(SimulatedShop simulatedShop, boolean bl) {
        int n = this.getEnergyNeeded(bl);
        if (this.energy > n) {
            int n2 = this.energy - n;
            this.money += n2 * simulatedShop.energyPrices.price;
            simulatedShop.energy += n2;
            this.energy = n;
        }
    }

    public void buyEnergy(SimulatedShop simulatedShop, boolean bl) {
        int n = this.getEnergyNeeded(bl);
        if (this.energy < n) {
            int n2 = n - this.energy;
            this.money -= n2 * simulatedShop.energyPrices.sellPrice;
            if (n2 > simulatedShop.energy) {
                n2 = simulatedShop.energy;
            }
            this.energyBoughtTotal += n2;
            simulatedShop.energy -= n2;
            this.energy += n2;
        }
    }

    public void sellSmithore(SimulatedShop simulatedShop) {
        this.money += simulatedShop.smithorePrices.buyPrice * this.smithore;
        simulatedShop.smithore += this.smithore;
        this.smithore = 0;
    }

    public void sellCrystite(SimulatedShop simulatedShop) {
        this.money += simulatedShop.crystitePrices.buyPrice * this.crystite;
        this.crystite = 0;
    }

    public void calcPoints(SimulatedShop simulatedShop) {
        this.points = this.money + this.landPoints + this.factoryPoints;
    }

    public String toString() {
        return this.player.toString();
    }
}

