/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.simulator;

import com.turborilla.mule.ai.simulator.SimulatedPlayer;
import com.turborilla.mule.ai.simulator.SimulatedTile;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SimulatedMap {
    public PlanetMap map;
    public int sizeX = 0;
    public int sizeY = 0;
    public SimulatedTile[][] tiles;
    static final int[][] adjacentDirs = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}};

    public void initialize(PlanetMap planetMap) {
        this.map = planetMap;
        this.resize(planetMap.getXSize(), planetMap.getYSize());
        for (int i = 0; i < this.sizeX; ++i) {
            for (int j = 0; j < this.sizeY; ++j) {
                PlanetTile planetTile = (PlanetTile)planetMap.getTile(i, j);
                this.tiles[i][j].initialize(planetTile);
            }
        }
    }

    public void copy(SimulatedMap simulatedMap) {
        this.map = simulatedMap.map;
        this.resize(simulatedMap.sizeX, simulatedMap.sizeY);
        for (int i = 0; i < this.sizeX; ++i) {
            for (int j = 0; j < this.sizeY; ++j) {
                this.tiles[i][j].copy(simulatedMap.tiles[i][j]);
            }
        }
    }

    private void resize(int n, int n2) {
        if (this.sizeX != n || this.sizeY != n2) {
            this.sizeX = n;
            this.sizeY = n2;
            this.tiles = new SimulatedTile[this.sizeX][this.sizeY];
            for (int i = 0; i < this.sizeX; ++i) {
                for (int j = 0; j < this.sizeY; ++j) {
                    this.tiles[i][j] = new SimulatedTile();
                }
            }
        }
    }

    public SimulatedTile getAdjacent(SimulatedTile simulatedTile, int n) {
        SimulatedTile simulatedTile2 = this.getTile(simulatedTile.tile.getPosX() + adjacentDirs[n][0], simulatedTile.tile.getPosY() + adjacentDirs[n][1]);
        if (simulatedTile2 != null && simulatedTile2.owner == simulatedTile.owner && simulatedTile2.factoryResource == simulatedTile.factoryResource) {
            return simulatedTile2;
        }
        return null;
    }

    public void updateAdjacencyBonus(SimulatedTile simulatedTile) {
        for (int i = 0; i < adjacentDirs.length; ++i) {
            SimulatedTile simulatedTile2 = this.getAdjacent(simulatedTile, i);
            if (simulatedTile2 == null) continue;
            simulatedTile.adjacencyBonus = 1;
            simulatedTile2.adjacencyBonus = 1;
        }
    }

    public void produce(ArrayList<SimulatedPlayer> arrayList) {
        for (int i = 0; i < this.sizeX; ++i) {
            for (int j = 0; j < this.sizeY; ++j) {
                SimulatedTile simulatedTile = this.tiles[i][j];
                simulatedTile.produce(arrayList);
            }
        }
    }

    public SimulatedTile getTile(int n, int n2) {
        if (n < 0 || n >= this.sizeX) {
            return null;
        }
        if (n2 < 0 || n2 >= this.sizeY) {
            return null;
        }
        return this.tiles[n][n2];
    }
}

