/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.simulator;

import com.turborilla.mule.MuleMath;
import com.turborilla.mule.ai.CrystiteDeduction;
import com.turborilla.mule.ai.simulator.DevelopmentPlan;
import com.turborilla.mule.ai.simulator.DevelopmentPlanList;
import com.turborilla.mule.ai.simulator.SimulatedMap;
import com.turborilla.mule.ai.simulator.SimulatedPlayer;
import com.turborilla.mule.ai.simulator.SimulatedState;
import com.turborilla.mule.ai.simulator.SimulatedTile;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DevelopmentPlanFinder {
    private static Logger logger = Logger.getLogger("mule");
    private static final long MAX_SEARCH_TIME = 20000000000L;
    private DevelopmentPlanList searchPlans;
    private Thread searchThread;
    private boolean stopSearch;
    private Throwable threadException;
    private ArrayList<SimulatedState> stateStack;
    private int depthLimit;
    private int minNumPlans = 0;
    private int numFuturePlans = 1;
    private DevelopmentPlanList.PointComparator pointComparator = new DevelopmentPlanList.PointComparator();
    private Resource[] allResources = Resource.values();
    private Resource[] allResourcesAndNull = new Resource[this.allResources.length + 1];
    private int numTilesTested;
    int[][][] freeTilesStack;
    int[][][] myEmptyTilesStack;
    int[][][] myFactoryTilesStack;
    private long startSearchTime;
    private boolean exceededSearchTime;

    public DevelopmentPlanFinder(PlanetMap planetMap, int n) {
        for (int i = 0; i < this.allResources.length; ++i) {
            this.allResourcesAndNull[i] = this.allResources[i];
        }
        this.allResourcesAndNull[this.allResourcesAndNull.length - 1] = null;
        this.setDepthLimit(planetMap, n);
        this.threadException = null;
    }

    public void setNumPlans(int n) {
        this.minNumPlans = n;
    }

    public void setNumFuturePlans(int n) {
        this.numFuturePlans = n;
    }

    public void setDepthLimit(PlanetMap planetMap, int n) {
        int n2;
        this.depthLimit = n;
        this.stateStack = new ArrayList(this.depthLimit + 1);
        for (n2 = 0; n2 < this.depthLimit + 1; ++n2) {
            this.stateStack.add(new SimulatedState());
        }
        n2 = planetMap.getXSize();
        int n3 = planetMap.getYSize();
        int n4 = n2 * n3;
        this.freeTilesStack = new int[n][n4][2];
        this.myEmptyTilesStack = new int[n][n4][2];
        this.myFactoryTilesStack = new int[n][n4][2];
    }

    public void setResourceWeight(Resource resource, int n) {
        this.pointComparator.setResourceWeight(resource, n);
    }

    public void clearResourceWeights() {
        this.pointComparator.clearResourceWeights();
    }

    public void clearPlans() {
        this.searchPlans = null;
    }

    public void startSearch(GameModel gameModel, final Player player, final CrystiteDeduction crystiteDeduction) {
        if (this.searchThread != null && this.searchThread.isAlive()) {
            logger.info("AI: " + player.getName() + " interrupting plan search");
            try {
                this.stopSearch = true;
                this.searchThread.join();
            }
            catch (InterruptedException interruptedException) {
                logger.severe(interruptedException.toString());
            }
        }
        this.searchPlans = null;
        this.stopSearch = false;
        if (this.minNumPlans == 0) {
            logger.severe("AI: Searching for 0 plans");
        }
        this.startSearchTime = System.nanoTime();
        this.exceededSearchTime = false;
        PlanetMap planetMap = gameModel.getMap();
        SimulatedState simulatedState = this.stateStack.get(0);
        simulatedState.initialize(gameModel, player);
        int n = planetMap.getShopTile().getPosX();
        int n2 = planetMap.getShopTile().getPosY();
        this.pointComparator.setStart(n, n2);
        this.numTilesTested = 0;
        final boolean bl = !player.hasClaimedLand;
        final boolean bl2 = gameModel.getPhase() == Phase.LAND_GRANT;
        this.searchThread = new Thread(new Runnable(){

            public void run() {
                try {
                    DevelopmentPlanFinder.this.searchPlans = null;
                    DevelopmentPlanFinder.this.searchPlans = DevelopmentPlanFinder.this.findPlans(0, DevelopmentPlanFinder.this.minNumPlans, crystiteDeduction, bl, bl2);
                    if (!DevelopmentPlanFinder.this.stopSearch) {
                        long l = System.nanoTime() - DevelopmentPlanFinder.this.startSearchTime;
                        logger.info("AI: " + player.getName() + " found " + DevelopmentPlanFinder.this.searchPlans.numPlans() + " plans testing " + DevelopmentPlanFinder.this.numTilesTested + " tiles in " + l + "ns");
                    }
                }
                catch (Throwable throwable) {
                    DevelopmentPlanFinder.this.threadException = throwable;
                    logger.log(Level.SEVERE, throwable.toString(), throwable);
                }
            }
        });
        this.searchThread.start();
    }

    public boolean isSearchFinished() {
        if (this.threadException != null) {
            throw new RuntimeException(this.threadException);
        }
        return this.searchThread != null && !this.searchThread.isAlive();
    }

    public DevelopmentPlanList getPlans() {
        return this.searchPlans;
    }

    private DevelopmentPlanList findPlans(int n, int n2, CrystiteDeduction crystiteDeduction, boolean bl, boolean bl2) {
        int n3;
        if (System.nanoTime() - this.startSearchTime > 20000000000L) {
            if (!this.exceededSearchTime) {
                logger.info("AI: Exceeded search time");
                this.exceededSearchTime = true;
                this.stopSearch = true;
            }
            return null;
        }
        if (this.stopSearch) {
            return null;
        }
        DevelopmentPlanList developmentPlanList = new DevelopmentPlanList(n2, this.pointComparator);
        DevelopmentPlanList developmentPlanList2 = new DevelopmentPlanList(1, this.pointComparator);
        DevelopmentPlan developmentPlan = new DevelopmentPlan();
        SimulatedState simulatedState = this.stateStack.get(n);
        SimulatedMap simulatedMap = simulatedState.getMap();
        int[][] nArray = this.freeTilesStack[n];
        int[][] nArray2 = this.myEmptyTilesStack[n];
        int[][] nArray3 = this.myFactoryTilesStack[n];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n3 = 0; n3 < simulatedMap.sizeX; ++n3) {
            for (int i = 0; i < simulatedMap.sizeY; ++i) {
                SimulatedTile simulatedTile = simulatedMap.getTile(n3, i);
                if (simulatedTile.owner == -1) {
                    if (simulatedTile.tile.getType() == PlanetTile.PlanetTileType.Shop) continue;
                    nArray[n4][0] = n3;
                    nArray[n4][1] = i;
                    ++n4;
                    continue;
                }
                if (simulatedTile.owner != simulatedState.myPlayer) continue;
                if (simulatedTile.factoryResource == null) {
                    if (n != 0) continue;
                    nArray2[n5][0] = n3;
                    nArray2[n5][1] = i;
                    ++n5;
                    continue;
                }
                nArray3[n5][0] = n3;
                nArray3[n5][1] = i;
                ++n6;
            }
        }
        if (bl) {
            for (n3 = 0; n3 < n4; ++n3) {
                if (this.stopSearch) {
                    return developmentPlanList;
                }
                nArray2[n5][0] = nArray[n3][0];
                nArray2[n5][1] = nArray[n3][1];
                this.testTiles(nArray2, n5 + 1, simulatedState, n, developmentPlanList2, developmentPlan, crystiteDeduction, bl2);
                DevelopmentPlan developmentPlan2 = developmentPlanList2.getPlan(0);
                developmentPlanList.insert(developmentPlan2);
                developmentPlanList2.clear();
            }
        }
        if (developmentPlanList.numPlans() < n2) {
            if (this.stopSearch) {
                return developmentPlanList;
            }
            this.testTiles(nArray2, n5, simulatedState, n, developmentPlanList, developmentPlan, crystiteDeduction, bl2);
        }
        return developmentPlanList;
    }

    private void testTiles(int[][] nArray, int n, SimulatedState simulatedState, int n2, DevelopmentPlanList developmentPlanList, DevelopmentPlan developmentPlan, CrystiteDeduction crystiteDeduction, boolean bl) {
        if (this.stopSearch) {
            return;
        }
        Resource[] resourceArray = this.allResourcesAndNull;
        int n3 = resourceArray.length;
        int n4 = MuleMath.pow(n3, n);
        Resource[] resourceArray2 = new Resource[n];
        this.numTilesTested += n;
        for (int i = 0; i < n4; ++i) {
            int n5;
            int n6;
            int n7 = 1;
            for (n6 = 0; n6 < n; ++n6) {
                n5 = i / n7 % n3;
                resourceArray2[n6] = resourceArray[n5];
                n7 *= n3;
            }
            n6 = 0;
            for (n5 = 0; n5 < n; ++n5) {
                if (resourceArray2[n5] != Resource.Crystite || crystiteDeduction.isKnown(nArray[n5][0], nArray[n5][1])) continue;
                n6 = 1;
                break;
            }
            if (n6 != 0) continue;
            SimulatedPlayer simulatedPlayer = simulatedState.getMyPlayer();
            int n8 = 0;
            int n9 = 0;
            for (Resource resource : resourceArray2) {
                if (resource == null) continue;
                n8 += simulatedState.getShop().mulePrice + resource.equipmentCost;
                ++n9;
            }
            if (simulatedPlayer.money < n8 || simulatedState.getShop().numMules < n9) continue;
            developmentPlan.initialize();
            for (int j = 0; j < n; ++j) {
                PlanetTile planetTile = (PlanetTile)simulatedState.getMap().map.getTile(nArray[j][0], nArray[j][1]);
                if (planetTile.getType() == PlanetTile.PlanetTileType.River && (resourceArray2[j] == Resource.Smithore || resourceArray2[j] == Resource.Crystite)) continue;
                if (planetTile.getOwner() != simulatedPlayer.player) {
                    developmentPlan.claimAndDevelopTile(planetTile, resourceArray2[j]);
                    continue;
                }
                developmentPlan.developMyTile(planetTile, resourceArray2[j]);
            }
            SimulatedState simulatedState2 = this.stateStack.get(n2 + 1);
            simulatedState2.copy(simulatedState);
            this.simulate(simulatedState2, developmentPlan, bl);
            DevelopmentPlanList developmentPlanList2 = null;
            if (n2 + 1 < this.depthLimit && simulatedState2.round <= simulatedState2.lastRound) {
                if (this.stopSearch) {
                    return;
                }
                developmentPlanList2 = this.findPlans(n2 + 1, this.numFuturePlans, crystiteDeduction, true, true);
            }
            if (this.stopSearch) {
                return;
            }
            developmentPlan.setNextPlans(developmentPlanList2);
            developmentPlanList.insert(developmentPlan);
        }
    }

    private void simulate(SimulatedState simulatedState, DevelopmentPlan developmentPlan, boolean bl) {
        for (int i = 0; i < developmentPlan.numTiles; ++i) {
            PlanetTile planetTile = developmentPlan.getTile(i);
            SimulatedTile simulatedTile = simulatedState.getMap().getTile(planetTile.getPosX(), planetTile.getPosY());
            simulatedState.getMyPlayer().addTile(simulatedState.getShop(), simulatedState.getMap(), simulatedTile, developmentPlan.getResource(i), simulatedState.getShop().mulePrice, false);
        }
        simulatedState.simulate(bl);
        developmentPlan.points = simulatedState.getMyPlayer().points;
    }

    public void printBaseState() {
        this.stateStack.get(0).print();
    }

    public void logPlans(GameModel gameModel, Player player, DevelopmentPlanList developmentPlanList, int n) {
        if (developmentPlanList == null || developmentPlanList.isEmpty()) {
            logger.info("AI: " + player + " has no plan.");
        }
        n = Math.min(n, developmentPlanList.numPlans());
        for (int i = 0; i < n; ++i) {
            DevelopmentPlan developmentPlan = developmentPlanList.getPlan(i);
            logger.info("AI: " + player.getName() + " Plan: " + developmentPlan);
            DevelopmentPlanList developmentPlanList2 = developmentPlan.getNextPlans();
            while (developmentPlanList2 != null && !developmentPlanList2.isEmpty()) {
                DevelopmentPlan developmentPlan2 = developmentPlanList2.getPlan(0);
                logger.info("AI:\tNext: " + developmentPlan2.toString());
                developmentPlanList2 = developmentPlan2.getNextPlans();
            }
        }
    }

    public void printPlans(DevelopmentPlanList developmentPlanList, boolean bl) {
        SimulatedState simulatedState = this.stateStack.get(0);
        SimulatedState simulatedState2 = new SimulatedState();
        for (int i = 0; i < developmentPlanList.numPlans(); ++i) {
            DevelopmentPlan developmentPlan = developmentPlanList.getPlan(i);
            simulatedState2.copy(simulatedState);
            this.simulate(simulatedState2, developmentPlan, bl);
            developmentPlan.print();
            simulatedState2.print();
            System.out.println();
        }
    }

    public void printPlan(DevelopmentPlan developmentPlan, boolean bl) {
        SimulatedState simulatedState = this.stateStack.get(0);
        SimulatedState simulatedState2 = new SimulatedState();
        developmentPlan.print();
        simulatedState2.copy(simulatedState);
        while (developmentPlan != null) {
            System.out.println("Round " + simulatedState2.round);
            this.simulate(simulatedState2, developmentPlan, bl);
            DevelopmentPlanList developmentPlanList = developmentPlan.getNextPlans();
            developmentPlan = developmentPlanList == null ? null : developmentPlanList.getPlan(0);
            simulatedState2.print();
        }
        System.out.println();
    }
}

