/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.simulator;

import com.turborilla.mule.ai.simulator.DevelopmentPlanList;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.PlanetTile;

public final class DevelopmentPlan {
    static final int MAX_NUM_TILES = 16;
    private int claimedTile;
    int numTiles;
    private PlanetTile[] tiles = new PlanetTile[16];
    private Resource[] resources = new Resource[16];
    int points;
    private DevelopmentPlanList nextPlans;

    public PlanetTile getClaimedTile() {
        if (this.claimedTile < 0) {
            return null;
        }
        return this.tiles[this.claimedTile];
    }

    void initialize() {
        this.claimedTile = -1;
        this.numTiles = 0;
        this.points = 0;
    }

    void copy(DevelopmentPlan developmentPlan) {
        this.claimedTile = developmentPlan.claimedTile;
        this.numTiles = developmentPlan.numTiles;
        for (int i = 0; i < this.numTiles; ++i) {
            this.tiles[i] = developmentPlan.tiles[i];
            this.resources[i] = developmentPlan.resources[i];
        }
        this.points = developmentPlan.points;
        this.nextPlans = developmentPlan.nextPlans;
    }

    public void claimAndDevelopTile(PlanetTile planetTile, Resource resource) {
        this.claimedTile = this.numTiles;
        this.developMyTile(planetTile, resource);
    }

    public void developMyTile(PlanetTile planetTile, Resource resource) {
        this.tiles[this.numTiles] = planetTile;
        this.resources[this.numTiles] = resource;
        ++this.numTiles;
    }

    void setNextPlans(DevelopmentPlanList developmentPlanList) {
        this.nextPlans = developmentPlanList;
    }

    int getResultingPoints() {
        if (this.nextPlans == null || this.nextPlans.isEmpty()) {
            return this.points;
        }
        return this.nextPlans.getPlan(0).getResultingPoints();
    }

    public void print() {
        this.print(0);
    }

    private void print(int n) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            System.out.print("\t");
        }
        System.out.println(this.toString());
        if (this.nextPlans != null) {
            for (n2 = 0; n2 < this.nextPlans.numPlans(); ++n2) {
                this.nextPlans.getPlan(n2).print(n + 1);
            }
        }
    }

    public boolean hasNextPlans() {
        return this.nextPlans != null;
    }

    public DevelopmentPlanList getNextPlans() {
        return this.nextPlans;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.numTiles == 0) {
            stringBuilder.append("No tile ");
        }
        for (int i = 0; i < this.numTiles; ++i) {
            PlanetTile planetTile = this.tiles[i];
            Resource resource = this.resources[i];
            stringBuilder.append((Object)((Object)planetTile.getType()) + " ");
            if (resource == null) {
                stringBuilder.append("Empty ");
            } else {
                stringBuilder.append((Object)((Object)resource) + " ");
            }
            if (i == this.claimedTile) {
                stringBuilder.append("<claim> ");
            }
            if (resource == null) continue;
            stringBuilder.append("(+" + planetTile.getYieldPotential(resource) + ") ");
        }
        stringBuilder.append(this.points + " points");
        return stringBuilder.toString();
    }

    public int numTiles() {
        return this.numTiles;
    }

    public PlanetTile getTile(int n) {
        return this.tiles[n];
    }

    public Resource getResource(int n) {
        return this.resources[n];
    }

    public Resource getClaimResource() {
        if (this.claimedTile < 0) {
            return null;
        }
        return this.resources[this.claimedTile];
    }
}

