/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.search;

import com.turborilla.mule.Properties;
import com.turborilla.mule.ai.AISystem;
import com.turborilla.mule.ai.AbstractAI;
import com.turborilla.mule.ai.CrystiteDeduction;
import com.turborilla.mule.ai.DevelopmentAction;
import com.turborilla.mule.ai.DevelopmentActionControl;
import com.turborilla.mule.ai.PathWalker;
import com.turborilla.mule.ai.search.AuctionActuator;
import com.turborilla.mule.ai.search.DevelopmentActuator;
import com.turborilla.mule.ai.search.FastDevelopmentActuator;
import com.turborilla.mule.ai.search.LandAuctionActuator;
import com.turborilla.mule.ai.search.LandGrantActuator;
import com.turborilla.mule.ai.search.LandRushActuator;
import com.turborilla.mule.ai.search.PlanManager;
import com.turborilla.mule.controller.WampusMenu;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchAI
extends AbstractAI {
    private static final long serialVersionUID = 1L;
    private Player myPlayer;
    private Random random;
    private PlanManager planManager;
    private DevelopmentActionControl developmentControl;
    LandGrantActuator landGrantActuator;
    private LandRushActuator landRushActuator;
    private DevelopmentActuator developmentActuator;
    private FastDevelopmentActuator fastDevelopmentActuator;
    private AuctionActuator auctionActuator;
    private LandAuctionActuator landAuctionActuator;
    private CrystiteDeduction crystiteDeduction;
    private float summaryContinueTimer;
    private boolean pressedContinue = false;

    public SearchAI(AISystem aISystem, Player player, GameModel gameModel) {
        super(aISystem);
        this.myPlayer = player;
        PlanetMap planetMap = gameModel.getMap();
        this.random = Properties.mule.debugRandomSeed ? new Random(Properties.mule.debugRandomSeedValue * player.getUserNumber()) : new Random();
        int n = 2;
        CrystiteDeduction crystiteDeduction = new CrystiteDeduction(planetMap.getXSize(), planetMap.getYSize());
        this.planManager = new PlanManager(player, planetMap, crystiteDeduction, n, this.random);
        this.developmentControl = new DevelopmentActionControl(player, this.buttonState, aISystem.getPathFindingGraph());
        this.landGrantActuator = new LandGrantActuator(this.planManager, this.buttonState, player, aISystem, this.random);
        this.landRushActuator = new LandRushActuator(this.developmentControl, this.planManager);
        this.developmentActuator = new DevelopmentActuator(this.developmentControl, this.planManager, crystiteDeduction, this.random);
        this.fastDevelopmentActuator = new FastDevelopmentActuator(this.developmentActuator);
        this.auctionActuator = new AuctionActuator(player, this.buttonState, this.random);
        this.landAuctionActuator = new LandAuctionActuator(player, this.buttonState, crystiteDeduction, this.random);
    }

    @Override
    public void beginPhase(Phase phase, GameModel gameModel) {
        switch (gameModel.getPhase()) {
            case LAND_GRANT: {
                this.landGrantActuator.begin(gameModel);
                break;
            }
            case LAND_RUSH: {
                if (!this.isMyTurnInLandRush(gameModel)) break;
                this.landRushActuator.begin(gameModel);
                break;
            }
            case DEVELOPMENT: {
                if (!this.isMyTurnInDevelopment(gameModel)) break;
                this.developmentActuator.begin(gameModel);
                break;
            }
            case FAST_DEVELOPMENT: {
                if (!this.isMyTurnInDevelopment(gameModel)) break;
                this.fastDevelopmentActuator.begin(gameModel);
                break;
            }
            case AUCTION_CRYSTITE: 
            case AUCTION_SMITHORE: 
            case AUCTION_ENERGY: 
            case AUCTION_FOOD: {
                this.auctionActuator.begin(gameModel);
                break;
            }
            case SUMMARY: {
                this.summaryContinueTimer = 8.5f + this.random.nextFloat() * 4.0f;
            }
        }
    }

    @Override
    public void update(GameModel gameModel, long l) {
        block0 : switch (gameModel.getPhase()) {
            case GAME_LOBBY: {
                if (this.pressedContinue) break;
                this.buttonState.setActionButtonPressed(true);
                this.pressedContinue = true;
                break;
            }
            case LAND_GRANT: {
                this.landGrantActuator.update(gameModel, l);
                break;
            }
            case LAND_RUSH: {
                this.landRushActuator.update(gameModel, l);
                break;
            }
            case DEVELOPMENT: {
                this.developmentActuator.update(gameModel, l);
                break;
            }
            case FAST_DEVELOPMENT: {
                this.fastDevelopmentActuator.update(gameModel);
                break;
            }
            case AUCTION_CRYSTITE: 
            case AUCTION_SMITHORE: 
            case AUCTION_ENERGY: 
            case AUCTION_FOOD: {
                this.auctionActuator.update(gameModel, l);
                break;
            }
            case LAND_AUCTION: {
                this.landAuctionActuator.update(gameModel, l);
                break;
            }
            case SUMMARY: {
                if (this.summaryContinueTimer > 0.0f) {
                    this.summaryContinueTimer -= Properties.mule.delta;
                    break;
                }
                if (this.myPlayer.isContinue() || gameModel.isLastRound()) break;
                this.buttonState.setActionButtonPressed(true);
                break;
            }
            default: {
                if (!this.myPlayer.isContinue()) {
                    this.buttonState.setActionButtonPressed(true);
                }
                switch ((int)(l % 4L)) {
                    case 0: {
                        this.buttonState.setUpPressed(true);
                        break block0;
                    }
                    case 1: {
                        this.buttonState.setDownPressed(true);
                        break block0;
                    }
                    case 2: {
                        this.buttonState.setLeftPressed(true);
                        break block0;
                    }
                    case 3: {
                        this.buttonState.setRightPressed(true);
                    }
                }
            }
        }
    }

    private boolean isMyTurnInLandRush(GameModel gameModel) {
        Player player = gameModel.getDevelopment().getCurrentPlayer();
        return this.myPlayer == player;
    }

    private boolean isMyTurnInDevelopment(GameModel gameModel) {
        Player player;
        return !gameModel.getGameInfo().isSingleDevelopment() || this.myPlayer == (player = gameModel.getDevelopment().getCurrentPlayer());
    }

    public PathWalker getPathWalker() {
        return this.developmentControl.getPathWalker();
    }

    @Override
    public void landClaimed(PlanetTile planetTile, GameModel gameModel) {
        if (gameModel.getPhase() == Phase.LAND_GRANT) {
            this.landGrantActuator.landClaimed(planetTile, gameModel);
        } else if (gameModel.getPhase() == Phase.DEVELOPMENT) {
            this.developmentActuator.landClaimed(planetTile, gameModel);
        }
    }

    @Override
    public void mulesChanged(Player player, GameModel gameModel) {
        this.developmentActuator.mulesChanged(player, gameModel);
    }

    @Override
    public void wampusCaught(Player player, GameModel gameModel, WampusMenu wampusMenu) {
        this.developmentActuator.wampusCaught(player, gameModel, wampusMenu);
    }

    @Override
    public void assay(Player player, PlanetTile planetTile, GameModel gameModel) {
        this.developmentActuator.assay(player, planetTile, gameModel);
    }

    @Override
    public void meteoriteStrike(PlanetTile planetTile) {
        this.developmentActuator.meteoriteStrike(planetTile);
    }

    @Override
    public void beginLandAuction(GameModel gameModel) {
        this.landAuctionActuator.beginLandAuction(gameModel);
    }

    @Override
    public void beginAuction(GameModel gameModel) {
        this.auctionActuator.beginAuction(gameModel);
    }

    @Override
    public void transaction(GameModel gameModel, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2) {
        this.auctionActuator.transaction(gameModel, arrayList, arrayList2);
    }

    @Override
    public boolean isThinking() {
        return this.planManager.isSearching();
    }

    @Override
    public DevelopmentAction nextDevelopmentAction(GameModel gameModel) {
        return this.fastDevelopmentActuator.nextDevelopmentAction(gameModel);
    }

    @Override
    public void developmentActionCompleted(GameModel gameModel, DevelopmentAction developmentAction) {
        this.fastDevelopmentActuator.developmentActionCompleted(gameModel, developmentAction);
    }
}

