/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.search;

import com.turborilla.mule.ai.DevelopmentAction;
import com.turborilla.mule.ai.DevelopmentActionControl;
import com.turborilla.mule.ai.DevelopmentActionQueue2;
import com.turborilla.mule.ai.search.PlanManager;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.map.PlanetTile;

public class LandRushActuator {
    private DevelopmentActionQueue2 actionQueue;
    private DevelopmentActionControl actionControl;
    private PlanManager planManager;

    public LandRushActuator(DevelopmentActionControl developmentActionControl, PlanManager planManager) {
        this.actionQueue = new DevelopmentActionQueue2(developmentActionControl.getMyPlayer());
        this.actionControl = developmentActionControl;
        this.planManager = planManager;
    }

    public void begin(GameModel gameModel) {
        this.planManager.setNumPlans(1);
        this.actionQueue.clearActions();
        this.planManager.startPlanSearch(gameModel, true);
    }

    public void update(GameModel gameModel, long l) {
        if (this.planManager.isSearching()) {
            if (this.planManager.finishSearch(gameModel) && this.planManager.hasCurrentPlan()) {
                PlanetTile planetTile = this.planManager.getCurrentPlan().getClaimedTile();
                this.actionQueue.addAction(new DevelopmentAction.ClaimTile(this.actionControl, planetTile));
            }
        } else {
            this.actionQueue.update(gameModel, l);
        }
    }
}

