/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.search;

import com.turborilla.mule.MuleMath;
import com.turborilla.mule.ai.CrystiteDeduction;
import com.turborilla.mule.controller.PlayerControllerState;
import com.turborilla.mule.model.AuctionLimits;
import com.turborilla.mule.model.AuctionState;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.Building;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import java.util.Random;
import java.util.logging.Logger;

public class LandAuctionActuator {
    private static Logger logger = Logger.getLogger("mule");
    private Player myPlayer;
    private PlayerControllerState buttonState;
    private Random random;
    private CrystiteDeduction crystiteDeduction;
    private int targetPrice;
    private int topPrice;
    private int safeDistance;
    private int changePriceCounter;

    public LandAuctionActuator(Player player, PlayerControllerState playerControllerState, CrystiteDeduction crystiteDeduction, Random random) {
        this.myPlayer = player;
        this.buttonState = playerControllerState;
        this.random = random;
        this.crystiteDeduction = crystiteDeduction;
    }

    public void beginLandAuction(GameModel gameModel) {
        int n;
        PlanetTile planetTile = gameModel.getPlotSeller().getAuctionTile();
        int n2 = gameModel.getGameInfo().getLastRound() - gameModel.getRound();
        int n3 = 100 + this.random.nextInt(160);
        if (n2 > 0) {
            n3 += this.random.nextInt(n2 * 100);
            if (this.crystiteDeduction.isKnown(planetTile) && planetTile.getCrystite() > 0) {
                n3 += this.random.nextInt(n2 * this.crystiteDeduction.getDeduction(planetTile) * 12);
            }
            if (planetTile.getType() != PlanetTile.PlanetTileType.Plain) {
                n3 += this.random.nextInt(n2 * 10);
            }
            n = 0;
            PlanetMap planetMap = gameModel.getMap();
            for (int[] nArray : Building.adjacentDirs) {
                int n4;
                int n5 = planetTile.getPosX() + nArray[0];
                PlanetTile planetTile2 = (PlanetTile)planetMap.getTile(n5, n4 = planetTile.getPosY() + nArray[1]);
                if (planetTile2 == null || planetTile2.getOwner() != this.myPlayer) continue;
                ++n;
            }
            if (n > 0) {
                n3 += this.random.nextInt(n2 * n * 18);
            }
        }
        n = 1;
        for (PlanetTile planetTile3 : this.myPlayer.getOwnedTiles()) {
            if (planetTile3.getFactory() != null) continue;
            ++n;
        }
        int n6 = gameModel.getShop().getMuleCost();
        int n7 = Resource.Energy.equipmentCost;
        this.topPrice = this.myPlayer.getMoney() - n * (n6 + n7);
        int n8 = gameModel.getAuction().getCurrentLimits().getPriceStep();
        this.targetPrice = Math.min(this.topPrice, n3);
        this.targetPrice -= this.targetPrice % n8;
        logger.info("AI: " + this.myPlayer.getName() + " targets price $" + this.targetPrice);
        this.safeDistance = 25 + this.random.nextInt(60);
        this.updateChangePriceTime();
    }

    public void update(GameModel gameModel, long l) {
        int n;
        if (!gameModel.getPhaseTimer().isStarted()) {
            return;
        }
        if (gameModel.getPhaseTimer().isFinished()) {
            return;
        }
        AuctionLimits auctionLimits = gameModel.getAuction().getCurrentLimits();
        AuctionState auctionState = this.myPlayer.getAuctionState();
        int n2 = auctionState.getPrice(auctionLimits);
        int n3 = n = auctionLimits.getMinPrice();
        int n4 = Integer.MAX_VALUE;
        for (Player player : gameModel.getPlayers()) {
            int n5;
            if (player == this.myPlayer || !player.getAuctionState().isInAuction()) continue;
            int n6 = player.getAuctionState().getPrice(auctionLimits);
            if (n6 > n3) {
                n3 = n6;
            }
            if ((n5 = Math.abs(n2 - n6)) >= n4) continue;
            n4 = n5;
        }
        if (n4 < this.safeDistance) {
            --this.changePriceCounter;
            if (this.changePriceCounter <= 0) {
                this.changeTargetPrice(auctionLimits);
                this.updateChangePriceTime();
            }
        }
        if (this.targetPrice > n) {
            if (n2 < this.targetPrice && n2 <= n3) {
                this.buttonState.setUp(true);
            } else if (n2 > this.targetPrice || n2 > n3 + auctionLimits.getPriceStep()) {
                this.buttonState.setDown(true);
            }
        } else if (auctionState.isInAuction() || auctionState.getTick() > auctionLimits.getMaxOutOfAuctionTicks()) {
            this.buttonState.setDown(true);
        }
    }

    private void changeTargetPrice(AuctionLimits auctionLimits) {
        int n = this.random.nextInt(129) - 64;
        n = MuleMath.closest(n, auctionLimits.getPriceStep());
        this.targetPrice = Math.min(this.topPrice, this.targetPrice + n);
        this.targetPrice -= this.targetPrice % auctionLimits.getPriceStep();
        logger.info("AI: " + this.myPlayer.getName() + " new price $" + this.targetPrice + " (changed $" + n + ")");
    }

    private void updateChangePriceTime() {
        this.changePriceCounter = 10 + this.random.nextInt(160);
    }
}

