/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.search;

import com.turborilla.mule.MuleMath;
import com.turborilla.mule.controller.PlayerControllerState;
import com.turborilla.mule.model.Auction;
import com.turborilla.mule.model.AuctionLimits;
import com.turborilla.mule.model.AuctionState;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuctionActuator {
    private Logger logger = Logger.getLogger("mule");
    private Player myPlayer;
    private PlayerControllerState buttonState;
    private int myCritical;
    private int targetPrice;
    private Random random;

    AuctionActuator(Player player, PlayerControllerState playerControllerState, Random random) {
        this.myPlayer = player;
        this.buttonState = playerControllerState;
        this.random = random;
    }

    void begin(GameModel gameModel) {
        Resource resource = this.getResource(gameModel);
        this.myCritical = this.myPlayer.getResourceCritical(resource, gameModel);
        if (resource == Resource.Energy) {
            ++this.myCritical;
        }
    }

    void beginAuction(GameModel gameModel) {
        this.calcTargetPrice(gameModel);
    }

    void update(GameModel gameModel, long l) {
        if (gameModel.isLastRound()) {
            if (!this.myPlayer.isContinue()) {
                this.buttonState.setDown(true);
            }
            return;
        }
        Resource resource = this.getResource(gameModel);
        int n = this.myPlayer.getResource(resource);
        if (!gameModel.getCountdown().isFinished()) {
            if (n <= this.myCritical) {
                if (!this.myPlayer.isBuyer()) {
                    this.buttonState.setDownPressed(true);
                }
            } else if (n > this.myCritical && this.myPlayer.isBuyer()) {
                this.buttonState.setUpPressed(true);
            }
        } else {
            Auction auction = gameModel.getAuction();
            AuctionLimits auctionLimits = auction.getCurrentLimits();
            AuctionState auctionState = this.myPlayer.getAuctionState();
            int n2 = auctionState.getTick();
            if (this.myPlayer.isBuyer()) {
                if (n < this.myCritical) {
                    int n3 = auctionLimits.priceToMaxTick(this.targetPrice);
                    if (n3 >= auctionLimits.minTick && n2 < n3 && n2 < auctionLimits.auctionSellTick) {
                        this.buttonState.setUp(true);
                    }
                } else if (auctionState.isInAuction() || n2 > -auctionLimits.getMaxOutOfAuctionTicks()) {
                    this.buttonState.setDown(true);
                }
            } else if (n > this.myCritical) {
                int n4 = auctionLimits.priceToMinTick(this.targetPrice);
                if (!auctionState.isInAuction()) {
                    if (n4 <= auctionLimits.maxTick) {
                        this.buttonState.setDown(true);
                    } else if (n2 > 5) {
                        this.buttonState.setDown(true);
                    }
                } else if (n2 > n4 && n2 > auctionLimits.auctionBuyTick) {
                    this.buttonState.setDown(true);
                }
            } else if (auctionState.isInAuction() || n2 < auctionLimits.getMaxOutOfAuctionTicks()) {
                this.buttonState.setUp(true);
            }
        }
    }

    void calcTargetPrice(GameModel gameModel) {
        Resource resource = this.getResource(gameModel);
        int n = gameModel.getShop().getBuyPrice(resource);
        int n2 = gameModel.getShop().getSellPrice(resource);
        if (resource == Resource.Crystite) {
            this.targetPrice = MuleMath.closest(55 + this.random.nextInt(66), 4);
            if (this.targetPrice <= n + 4) {
                this.targetPrice = n;
            }
            this.logger.info("AI: " + this.myPlayer.getName() + " target price $" + this.targetPrice);
        } else if (resource == Resource.Smithore) {
            this.targetPrice = 50 + this.random.nextInt(16);
            if (this.targetPrice <= n + 1) {
                this.targetPrice = n;
            }
            this.logger.info("AI: " + this.myPlayer.getName() + " target price $" + this.targetPrice);
        } else {
            int n3 = this.myPlayer.getResource(resource);
            int n4 = n3 - this.myCritical;
            if (n4 == 0) {
                this.targetPrice = 0;
                return;
            }
            int n5 = 0;
            int n6 = 0;
            for (Player player : gameModel.getPlayers()) {
                if (player == this.myPlayer) continue;
                int n7 = player.getResourceCritical(resource, gameModel);
                int n8 = player.getResource(resource);
                int n9 = n8 - n7;
                if (player.isBuyer()) {
                    if (n9 >= 0) continue;
                    n6 -= n9;
                    continue;
                }
                if (n9 <= 0) continue;
                n5 += n9;
            }
            float f = AuctionActuator.calcPriceRatio(n4, n5, n6, gameModel.getShop().getResource(resource), true);
            this.targetPrice = (int)(f * (float)n2 + (1.0f - f) * (float)n);
            if (this.myPlayer.isBuyer() && this.myPlayer.getMoney() < this.targetPrice) {
                this.logger.info("AI: " + this.myPlayer.getName() + " target price $" + this.targetPrice + " ratio " + f + " capped by money $" + this.myPlayer.getMoney());
                this.targetPrice = this.myPlayer.getMoney();
            } else {
                this.logger.info("AI: " + this.myPlayer.getName() + " target price $" + this.targetPrice + " ratio " + f);
            }
        }
    }

    private static float calcPriceRatio(int n, int n2, int n3, int n4, boolean bl) {
        float f = 0.0f;
        if (n > 0) {
            float f2 = 0.03f * (float)n2 + 0.1f * (float)n;
            float f3 = 0.5f * (float)n3 - f2 + 0.3f;
            f = f3;
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 1.0f) {
                if (n4 > 0) {
                    f = 1.0f;
                } else if (bl && f > 2.5f) {
                    f = 2.5f;
                }
            }
        } else {
            float f4 = 3.0f * (float)n3 - 4.0f * (float)n;
            float f5 = f4 - 0.3f * (float)n2 + 6.5f;
            f = f5 / 7.5f;
            if (f < 0.0f) {
                f = 0.0f;
            } else if (bl && f > 2.5f) {
                f = 2.5f;
            }
        }
        return f;
    }

    public static void main(String[] stringArray) {
        AuctionActuator.printRatio(-1, 10, 0, 0);
        System.out.println();
    }

    private static void printRatio(int n, int n2, int n3, int n4) {
        System.out.println("Me: " + n + " Sellers: " + n2 + " Buyers: " + -n3 + " Shop: " + n4 + " Ratio: " + AuctionActuator.calcPriceRatio(n, n2, n3, n4, false));
    }

    private Resource getResource(GameModel gameModel) {
        switch (gameModel.getPhase()) {
            case AUCTION_CRYSTITE: {
                return Resource.Crystite;
            }
            case AUCTION_ENERGY: {
                return Resource.Energy;
            }
            case AUCTION_FOOD: {
                return Resource.Food;
            }
            case AUCTION_SMITHORE: {
                return Resource.Smithore;
            }
        }
        return null;
    }

    void transaction(GameModel gameModel, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2) {
        if (gameModel.getPhase() == Phase.AUCTION_ENERGY || gameModel.getPhase() == Phase.AUCTION_FOOD) {
            this.calcTargetPrice(gameModel);
        }
    }
}

