/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.adam;

import com.turborilla.mule.MuleMath;
import com.turborilla.mule.Properties;
import com.turborilla.mule.ai.CrystiteDeduction;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.Shop;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriceCalculator {
    int foodPrice;
    int energyPrice;
    int smithorePrice;
    int crystitePrice;
    private Shop shop;
    private CrystiteDeduction crystiteDeduction;
    LinkedList<PlanetTile> storage;

    PriceCalculator(Shop shop, CrystiteDeduction crystiteDeduction) {
        this.shop = shop;
        this.crystiteDeduction = crystiteDeduction;
        this.storage = new LinkedList();
    }

    public void calculatePrices(GameModel gameModel) {
        this.crystitePrice = 100;
        this.smithorePrice = MuleMath.clamp(this.shopSmithorePrice(gameModel), 20, 230);
        this.energyPrice = MuleMath.clamp(this.shopEnergyPrice(gameModel, gameModel.getPlayers()), 25, 230);
        this.foodPrice = MuleMath.clamp(this.shopFoodPrice(gameModel, gameModel.getPlayers()), 30, 230);
    }

    public void setPrices() {
        this.foodPrice = this.shop.getPrice(Resource.Food);
        this.energyPrice = this.shop.getPrice(Resource.Energy);
        this.smithorePrice = this.shop.getPrice(Resource.Smithore);
        this.crystitePrice = this.shop.getPrice(Resource.Crystite);
    }

    int getBuyPrice(Resource resource) {
        switch (resource) {
            case Food: {
                return this.foodPrice - 15;
            }
            case Energy: {
                return this.energyPrice - 15;
            }
            case Smithore: {
                return this.smithorePrice;
            }
            case Crystite: {
                return this.crystitePrice;
            }
        }
        return 0;
    }

    int getSellPrice(Resource resource) {
        switch (resource) {
            case Food: {
                return this.foodPrice - 15 + Properties.mule.shopFoodPriceRange;
            }
            case Energy: {
                return this.energyPrice - 15 + Properties.mule.shopEnergyPriceRange;
            }
            case Smithore: {
                return this.smithorePrice + Properties.mule.shopSmithorePriceRange;
            }
            case Crystite: {
                return this.crystitePrice + Properties.mule.shopCrystitePriceRange;
            }
        }
        return 0;
    }

    public int getShopPrice(GameModel gameModel, Resource resource) {
        switch (resource) {
            case Food: {
                return this.foodPrice;
            }
            case Energy: {
                return this.energyPrice;
            }
            case Smithore: {
                return this.smithorePrice;
            }
            case Crystite: {
                return this.crystitePrice;
            }
        }
        return 0;
    }

    public int getPlayerPrice(GameModel gameModel, Resource resource, Player player) {
        TreeSet<Player> treeSet = new TreeSet<Player>();
        treeSet.add(player);
        switch (resource) {
            case Food: {
                return this.shopFoodPrice(gameModel, treeSet);
            }
            case Energy: {
                return this.shopEnergyPrice(gameModel, treeSet);
            }
            case Smithore: {
                return 250 - gameModel.getRound() * 20;
            }
            case Crystite: {
                return 100;
            }
        }
        return 0;
    }

    private int shopFoodPrice(GameModel gameModel, Collection<Player> collection) {
        int n = collection.size() * Properties.mule.foodRequirements[Math.min(gameModel.getRound() + 1, 12)];
        int n2 = this.shop.getFood();
        for (Player player : collection) {
            n2 += player.getFood() + player.calcProduction(Resource.Food) - player.calcSpoilage(Resource.Food);
        }
        n2 = Math.max(n2, 1);
        float f = 0.25f + 0.75f * (float)n / (float)n2;
        int n3 = Math.round((float)this.shop.getPrice(Resource.Food) * f);
        return n3;
    }

    private int shopSmithorePrice(GameModel gameModel) {
        int n;
        int n2;
        PlanetMap planetMap = gameModel.getMap();
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < planetMap.getXSize(); ++n2) {
            for (n = 0; n < planetMap.getYSize(); ++n) {
                PlanetTile planetTile = (PlanetTile)planetMap.getTile(n2, n);
                if (planetTile.getOwner() == null) {
                    ++n3;
                    continue;
                }
                if (planetTile.getFactory() != null) continue;
                ++n4;
            }
        }
        n2 = Math.min(n3, gameModel.getPlayers().size()) + n4;
        n2 = Math.max(n2, 8);
        n = Math.max(1, this.shop.numMules() + this.shop.getSmithore() / 2);
        float f = MuleMath.clamp((float)n2 / (float)n, 0.25f, 3.0f);
        float f2 = 0.25f + 0.75f * f;
        int n5 = Math.round((float)this.shop.getPrice(Resource.Smithore) * f2);
        n5 = Math.max(n5, 50);
        return n5;
    }

    private int shopEnergyPrice(GameModel gameModel, Collection<Player> collection) {
        int n = this.shop.getEnergy();
        int n2 = 0;
        for (Player player : collection) {
            n += player.getEnergy() + player.calcProduction(Resource.Energy) - player.calcSpoilage(Resource.Energy);
            n2 += player.getEnergyRequirement() + 1;
        }
        n = Math.max(n2, 1);
        float f = 0.25f + 0.75f * (float)n2 / (float)n;
        int n3 = Math.round((float)gameModel.getShop().getPrice(Resource.Energy) * f);
        return n3;
    }

    public int expectedProduction(Collection<PlanetTile> collection, Resource resource) {
        int n = 0;
        for (PlanetTile planetTile : collection) {
            if (planetTile.getType().allow(resource)) continue;
            this.storage.add(planetTile);
        }
        for (PlanetTile planetTile : this.storage) {
            collection.remove(planetTile);
        }
        for (PlanetTile planetTile : collection) {
            n += resource == Resource.Crystite ? this.crystiteDeduction.getDeduction(planetTile) : planetTile.getYieldPotential(resource);
        }
        block3: for (PlanetTile planetTile : collection) {
            for (PlanetTile planetTile2 : collection) {
                if (MuleMath.tileDistance(planetTile, planetTile2) != 1) continue;
                ++n;
                continue block3;
            }
        }
        n += collection.size() * (collection.size() / 3);
        while (!this.storage.isEmpty()) {
            collection.add(this.storage.poll());
        }
        return n;
    }

    public int expectedValue(GameModel gameModel, Map<Resource, Collection<PlanetTile>> map) {
        int n = 0;
        for (Resource resource : Resource.values()) {
            int n2 = this.expectedProduction(map.get((Object)resource), resource);
            n += n2 * this.getShopPrice(gameModel, resource);
        }
        return n;
    }
}

