/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.adam;

import com.turborilla.mule.MuleMath;
import com.turborilla.mule.ai.CrystiteDeduction;
import com.turborilla.mule.ai.adam.AdamAI;
import com.turborilla.mule.ai.adam.PlayerLP;
import com.turborilla.mule.controller.PlayerControllerState;
import com.turborilla.mule.model.AuctionLimits;
import com.turborilla.mule.model.AuctionState;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.Building;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import java.util.logging.Logger;

public class LandAuctionActuator {
    private static Logger logger = Logger.getLogger("mule");
    private AdamAI ai;
    private Player myPlayer;
    private PlayerControllerState buttonState;
    private int targetPrice;
    private int topPrice;
    private int safeDistance;
    private int changePriceCounter;
    private float riskAllowance;

    public LandAuctionActuator(AdamAI adamAI, PlayerControllerState playerControllerState) {
        this.ai = adamAI;
        this.myPlayer = adamAI.getMyPlayer();
        this.buttonState = playerControllerState;
        this.riskAllowance = 1.0f + 0.5f * adamAI.getRandom().nextFloat();
    }

    public void beginLandAuction(GameModel gameModel, PlayerLP playerLP) {
        int n = gameModel.getGameInfo().getLastRound() - gameModel.getRound();
        PlanetTile planetTile = gameModel.getPlotSeller().getAuctionTile();
        CrystiteDeduction crystiteDeduction = this.ai.getCrystiteDeduction();
        int n2 = playerLP.getTileValue(gameModel, crystiteDeduction, planetTile, true, false);
        int n3 = 500 + 3 * n2 * n / 4;
        if (n2 <= 0) {
            n3 = this.oldEstimate(gameModel, crystiteDeduction);
            logger.info("AI: " + this.myPlayer.getName() + " reverted to old value estimation");
        }
        logger.info("AI: " + this.myPlayer.getName() + " originally valued the plot at $" + n3);
        int n4 = 1;
        for (PlanetTile planetTile2 : this.myPlayer.getOwnedTiles()) {
            if (!planetTile2.isEmpty()) continue;
            ++n4;
        }
        int n5 = gameModel.getShop().getMuleCost();
        int n6 = Resource.Energy.equipmentCost;
        this.topPrice = this.myPlayer.getMoney() - n4 * (n5 + n6);
        this.topPrice = (int)((float)this.topPrice * this.riskAllowance);
        int n7 = gameModel.getAuction().getCurrentLimits().getPriceStep();
        this.targetPrice = Math.min(this.topPrice, n3);
        this.targetPrice -= this.targetPrice % n7;
        logger.info("AI: " + this.myPlayer.getName() + " targets price $" + this.targetPrice);
        this.safeDistance = 25 + this.ai.getRandom().nextInt(60);
        this.updateChangePriceTime();
    }

    private int oldEstimate(GameModel gameModel, CrystiteDeduction crystiteDeduction) {
        PlanetTile planetTile = gameModel.getPlotSeller().getAuctionTile();
        int n = gameModel.getGameInfo().getLastRound() - gameModel.getRound();
        int n2 = 100 + this.ai.getRandom().nextInt(160);
        if (n > 0) {
            n2 += this.ai.getRandom().nextInt(n * 100);
            int n3 = crystiteDeduction.getDeduction(planetTile);
            if (n3 > 0) {
                n2 += this.ai.getRandom().nextInt(n * 12 * n3);
            }
            if (planetTile.getType() != PlanetTile.PlanetTileType.Plain) {
                n2 += this.ai.getRandom().nextInt(n * 10);
            }
            int n4 = 0;
            PlanetMap planetMap = gameModel.getMap();
            for (int[] nArray : Building.adjacentDirs) {
                int n5;
                int n6 = planetTile.getPosX() + nArray[0];
                PlanetTile planetTile2 = (PlanetTile)planetMap.getTile(n6, n5 = planetTile.getPosY() + nArray[1]);
                if (planetTile2 == null || planetTile2.getOwner() != this.myPlayer) continue;
                ++n4;
            }
            if (n4 > 0) {
                n2 += this.ai.getRandom().nextInt(n * n4 * 18);
            }
        }
        return n2;
    }

    public void update(GameModel gameModel, long l) {
        int n;
        if (!gameModel.getPhaseTimer().isStarted()) {
            return;
        }
        if (gameModel.getPhaseTimer().isFinished()) {
            return;
        }
        AuctionLimits auctionLimits = gameModel.getAuction().getCurrentLimits();
        AuctionState auctionState = this.myPlayer.getAuctionState();
        int n2 = auctionState.getPrice(auctionLimits);
        int n3 = n = auctionLimits.getMinPrice();
        int n4 = Integer.MAX_VALUE;
        for (Player player : gameModel.getPlayers()) {
            int n5;
            if (player == this.myPlayer || !player.getAuctionState().isInAuction()) continue;
            int n6 = player.getAuctionState().getPrice(auctionLimits);
            if (n6 > n3) {
                n3 = n6;
            }
            if ((n5 = Math.abs(n2 - n6)) >= n4) continue;
            n4 = n5;
        }
        if (n4 < this.safeDistance) {
            --this.changePriceCounter;
            if (this.changePriceCounter <= 0) {
                this.changeTargetPrice(auctionLimits);
                this.updateChangePriceTime();
            }
        }
        if (this.targetPrice > n) {
            if (n2 < this.targetPrice && n2 <= n3) {
                this.buttonState.setUp(true);
            } else if (n2 > this.targetPrice || n2 > n3 + auctionLimits.getPriceStep()) {
                this.buttonState.setDown(true);
            }
        } else if (auctionState.isInAuction() || auctionState.getTick() > auctionLimits.getMaxOutOfAuctionTicks()) {
            this.buttonState.setDown(true);
        }
    }

    private void changeTargetPrice(AuctionLimits auctionLimits) {
        int n = this.ai.getRandom().nextInt(129) - 64;
        n = MuleMath.closest(n, auctionLimits.getPriceStep());
        this.targetPrice = Math.min(this.topPrice, this.targetPrice + n);
        this.targetPrice -= this.targetPrice % auctionLimits.getPriceStep();
        logger.info("AI: " + this.myPlayer.getName() + " new price $" + this.targetPrice + " (changed $" + n + ")");
    }

    private void updateChangePriceTime() {
        this.changePriceCounter = 10 + this.ai.getRandom().nextInt(160);
    }
}

