/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.adam;

import com.turborilla.mule.ai.CrystiteDeduction;
import com.turborilla.mule.ai.adam.AdamAI;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.PlanetTile;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DevelopmentState
extends HashMap<PlanetTile, Resource> {
    private static final long serialVersionUID = 4042421508643324000L;
    int numMules;
    int mulePrice;
    Resource muleResource;
    int cash;
    boolean caughtWampus;
    int wampusPrize;
    CrystiteDeduction crystiteDeduction;

    public boolean hasMule() {
        return this.muleResource != null;
    }

    public DevelopmentState(int n, int n2) {
        super(2 * n * n2);
        this.crystiteDeduction = new CrystiteDeduction(n, n2);
    }

    public void reset(GameModel gameModel, AdamAI adamAI) {
        Player player = adamAI.getMyPlayer();
        this.numMules = gameModel.getShop().numMules();
        this.mulePrice = gameModel.getShop().getMuleCost();
        this.muleResource = null;
        this.cash = player.getMoney();
        this.caughtWampus = !gameModel.getWampus().hasMountains();
        this.wampusPrize = gameModel.getWampus().getMoneyReward();
        this.clear();
        for (PlanetTile planetTile : player.getOwnedTiles()) {
            if (planetTile.isEmpty()) continue;
            this.put(planetTile, planetTile.getFactory().getResource());
        }
        this.crystiteDeduction.copy(adamAI.getCrystiteDeduction());
    }

    public boolean doActionAtTile(PlanetTile planetTile) {
        Resource resource = (Resource)((Object)this.get(planetTile));
        if (resource == this.muleResource) {
            return false;
        }
        this.put(planetTile, this.muleResource);
        this.muleResource = resource;
        return true;
    }

    public int getNetCost(Resource resource) {
        int n = 0;
        if (this.muleResource != null) {
            n -= this.muleResource.equipmentCost + this.mulePrice;
        }
        if (resource != null) {
            n += this.mulePrice + resource.equipmentCost;
        }
        return n;
    }

    public boolean switchSetup(Resource resource) {
        if (resource == this.muleResource) {
            return false;
        }
        if (this.muleResource == null) {
            --this.numMules;
        } else if (resource == null) {
            ++this.numMules;
        }
        this.cash -= this.getNetCost(resource);
        this.muleResource = resource;
        return true;
    }

    public boolean testSwitchSetup(Resource resource) {
        boolean bl;
        boolean bl2 = bl = resource != null;
        if (resource == this.muleResource) {
            return true;
        }
        if (!this.hasMule() && bl && this.numMules == 0) {
            return false;
        }
        return this.getNetCost(resource) <= this.cash;
    }

    public boolean catchWampus() {
        if (this.caughtWampus) {
            return false;
        }
        this.caughtWampus = true;
        this.cash += this.wampusPrize;
        return true;
    }

    public PlanetTile assayRandomTile(Collection<PlanetTile> collection, Random random) {
        PlanetTile planetTile2;
        if (this.crystiteDeduction.isAllKnown()) {
            return null;
        }
        LinkedList<PlanetTile> linkedList = new LinkedList<PlanetTile>();
        for (PlanetTile planetTile2 : collection) {
            if (this.crystiteDeduction.isKnown(planetTile2)) continue;
            linkedList.add(planetTile2);
        }
        if (linkedList.isEmpty()) {
            return null;
        }
        int n = random.nextInt(linkedList.size());
        planetTile2 = (PlanetTile)linkedList.get(n);
        this.crystiteDeduction.setKnown(planetTile2, planetTile2.getCrystite());
        return planetTile2;
    }
}

