/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.adam;

import com.turborilla.mule.Properties;
import com.turborilla.mule.Settings;
import com.turborilla.mule.ai.DevelopmentAction;
import com.turborilla.mule.ai.DevelopmentActionControl;
import com.turborilla.mule.ai.DevelopmentActionQueue2;
import com.turborilla.mule.ai.adam.AdamAI;
import com.turborilla.mule.ai.adam.DevelopmentState;
import com.turborilla.mule.ai.adam.PlayerLP;
import com.turborilla.mule.ai.adam.SearchPlanManager;
import com.turborilla.mule.ai.simulator.DevelopmentPlan;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Logger;

public class DevelopmentPlanner {
    private static Logger logger = Logger.getLogger("mule");
    HashMap<PlanetTile, Resource> myPlan;
    private LinkedList<PlanetTile> planOrder;
    private AdamAI ai;
    private Player myPlayer;
    private DevelopmentActionQueue2 actionQueue;
    private DevelopmentActionControl actionControl;
    private SearchPlanManager searchPlanManager;
    private SafeSort mySort;
    private DevelopmentState state;
    private boolean singleDev;
    private boolean done;
    private float assayFirstProbability;

    public DevelopmentPlanner(AdamAI adamAI, DevelopmentActionControl developmentActionControl, PlanetMap planetMap, SearchPlanManager searchPlanManager) {
        this.ai = adamAI;
        this.myPlayer = developmentActionControl.getMyPlayer();
        this.actionControl = developmentActionControl;
        this.searchPlanManager = searchPlanManager;
        this.state = new DevelopmentState(planetMap.getXSize(), planetMap.getYSize());
        this.planOrder = new LinkedList();
        this.myPlan = new HashMap();
        this.mySort = new SafeSort();
        this.assayFirstProbability = 0.25f * adamAI.getRandom().nextFloat();
    }

    boolean isSearching() {
        return this.searchPlanManager.isSearching();
    }

    boolean isDone() {
        return this.done;
    }

    void setQueue(DevelopmentActionQueue2 developmentActionQueue2) {
        this.actionQueue = developmentActionQueue2;
    }

    public void reset(GameModel gameModel) {
        this.done = false;
        this.state.reset(gameModel, this.ai);
    }

    public void begin(GameModel gameModel, PlayerLP playerLP) {
        this.singleDev = gameModel.getGameInfo().isSingleDevelopment();
        if (this.myPlayer.getDevelopmentTime() < Properties.mule.minDevelopmentTime + 0.5f) {
            logger.info("AI: " + this.myPlayer.getName() + " is short on development time and goes to the pub");
            this.actionQueue.addAction(new DevelopmentAction.GoToPub(this.actionControl));
        }
        if (!(this.myPlayer.getDevelopmentTime() < Properties.mule.maxDevelopmentTime * 0.5f) && this.ai.getRandom().nextFloat() < this.assayFirstProbability) {
            PlanetTile planetTile;
            Properties.mule.getClass();
            if (!Properties.mule.turnOffExtras && (planetTile = this.state.assayRandomTile(this.myPlayer.getOwnedTiles(), this.ai.getRandom())) != null) {
                logger.info("AI: " + this.myPlayer.getName() + " starts by assaying " + planetTile);
                this.actionQueue.addAction(new DevelopmentAction.GoToAssayStore(this.actionControl));
                this.actionQueue.addAction(new DevelopmentAction.Assay(this.actionControl, planetTile));
            }
        }
        if (!playerLP.makeDevelopmentPlan(gameModel, this.state.crystiteDeduction, true, true, this.myPlan)) {
            logger.info("AI: " + this.myPlayer.getName() + " LP was infeasible (or ignored).");
            this.searchPlanManager.clearPlans();
            int n = 1;
            if (!this.singleDev) {
                n = Math.max(1, gameModel.getPlayers().size());
                for (Player player : gameModel.getPlayers()) {
                    if (player.hasClaimedLand) continue;
                    ++n;
                }
            }
            this.searchPlanManager.setNumPlans(n);
            this.searchPlanManager.startPlanSearch(gameModel, this.state.crystiteDeduction, true);
        } else {
            this.finalizePlan(gameModel);
        }
    }

    public void finalizePlan(GameModel gameModel) {
        if (this.isSearching()) {
            if (!this.searchPlanManager.finishSearch(gameModel)) {
                return;
            }
            if (this.searchPlanManager.hasCurrentPlan()) {
                Iterator iterator = this.searchPlanManager.getCurrentPlan();
                for (PlanetTile planetTile : this.myPlayer.getOwnedTiles()) {
                    if (this.myPlan.containsKey(planetTile) || planetTile.isEmpty()) continue;
                    this.myPlan.put(planetTile, planetTile.getFactory().getResource());
                }
                for (int i = 0; i < ((DevelopmentPlan)((Object)iterator)).numTiles(); ++i) {
                    if (this.state.get(((DevelopmentPlan)((Object)iterator)).getTile(i)) != null) continue;
                    this.myPlan.put(((DevelopmentPlan)((Object)iterator)).getTile(i), ((DevelopmentPlan)((Object)iterator)).getResource(i));
                }
                logger.info("AI: " + this.myPlayer.getName() + " is adding the search results to the plan.");
            } else {
                logger.info("AI: " + this.myPlayer.getName() + " had no search plans to add.");
            }
        }
        this.planOrder.clear();
        for (PlanetTile planetTile : this.myPlayer.getOwnedTiles()) {
            if (this.myPlan.get(planetTile) == this.state.get(planetTile)) continue;
            this.planOrder.add(planetTile);
        }
        Collections.sort(this.planOrder, this.mySort);
        logger.info("AI: " + this.myPlayer.getName() + " picked " + this.planOrder.size() + " tiles to be modified");
        for (PlanetTile planetTile : this.planOrder) {
            logger.info("\t" + (this.planOrder.indexOf(planetTile) + 1) + ". make plot (" + planetTile.getPosX() + "," + planetTile.getPosY() + ") into " + (this.myPlan.get(planetTile) == null ? "Empty" : this.myPlan.get(planetTile).getName()) + " from " + (planetTile.isEmpty() ? "Empty" : PlanetTile.getResourceFromTile(planetTile)));
        }
        if (Settings.get().fastAiDevelopment) {
            this.enqueueNormal(gameModel);
        } else {
            this.enqueueHeuristic(gameModel);
        }
        this.done = true;
    }

    private boolean bringMule(PlanetTile planetTile) {
        Resource resource = this.myPlan.get(planetTile);
        Resource resource2 = (Resource)((Object)this.state.get(planetTile));
        if (resource2 == null) {
            return true;
        }
        if (resource == null) {
            logger.info("Stripping because want it empty");
            return false;
        }
        if (this.state.muleResource == resource) {
            return true;
        }
        if (!this.state.testSwitchSetup(resource)) {
            logger.info("Stripping because short on something (either money or mules).");
            return false;
        }
        return true;
    }

    public void enqueueNormal(GameModel gameModel) {
        logger.info("AI: " + this.myPlayer.getName() + " is using the default (pretty lame) " + "enqueueing scheme.");
        for (PlanetTile planetTile : this.planOrder) {
            if (!planetTile.isEmpty()) {
                this.enqueueDevelop(planetTile, null);
                if (gameModel.getGameInfo().isFastAiDevelopment()) {
                    this.state.switchSetup(null);
                    this.actionQueue.addAction(new DevelopmentAction.GoToMuleStore(this.actionControl));
                }
            }
            if (this.myPlan.get(planetTile) == null) continue;
            this.enqueueDevelop(planetTile, this.myPlan.get(planetTile));
        }
        if (this.actionQueue.isEmpty() && !this.enqueueHuntWampus()) {
            this.actionQueue.addAction(new DevelopmentAction.NullAction(this.actionControl));
        }
    }

    public void enqueueHeuristic(GameModel gameModel) {
        logger.info("AI: " + this.myPlayer.getName() + " is using the heuristic enqueueing scheme.");
        PlanetTile planetTile = null;
        while (!this.planOrder.isEmpty()) {
            Resource resource;
            ListIterator listIterator = this.planOrder.listIterator();
            while (listIterator.hasNext()) {
                planetTile = (PlanetTile)listIterator.next();
                if (this.myPlan.get(planetTile) != this.state.muleResource) continue;
                listIterator = null;
                break;
            }
            if (listIterator != null) {
                planetTile = this.planOrder.getFirst();
                listIterator = null;
            }
            Resource resource2 = resource = this.bringMule(planetTile) ? this.myPlan.get(planetTile) : null;
            if (!this.enqueueDevelop(planetTile, resource)) {
                logger.info("AI: " + this.myPlayer.getName() + " was forced to end the enqueueing early.");
                break;
            }
            if (this.state.get(planetTile) != this.myPlan.get(planetTile)) continue;
            this.planOrder.remove(planetTile);
        }
        if (this.planOrder.isEmpty()) {
            logger.info("AI: " + this.myPlayer.getName() + " successfully enqueued the entire plan.");
        }
        if (this.state.switchSetup(null)) {
            this.actionQueue.addAction(new DevelopmentAction.GoToMuleStore(this.actionControl));
        }
        if (this.actionQueue.isEmpty() && !this.enqueueHuntWampus()) {
            this.actionQueue.addAction(new DevelopmentAction.NullAction(this.actionControl));
        }
    }

    private boolean enqueueDevelop(PlanetTile planetTile, Resource resource) {
        logger.info("AI: " + this.myPlayer.getName() + " ------- is trying " + planetTile + ": " + (this.state.get(planetTile) == null ? "Empty" : (Serializable)this.state.get(planetTile)) + " --> " + (resource == null ? "Empty" : resource));
        if (!this.enqueueEquipViaWampus(resource)) {
            return false;
        }
        if (this.state.doActionAtTile(planetTile)) {
            this.actionQueue.addAction(new DevelopmentAction.PlaceMule(this.actionControl, planetTile, resource));
            logger.info("AI: " + this.myPlayer.getName() + " ------- succeeded.");
        } else {
            logger.info("AI: " + this.myPlayer.getName() + " ------- tried to redevelop a tile with the same Resource!");
        }
        return true;
    }

    private boolean enqueueEquipViaWampus(Resource resource) {
        Resource resource2 = this.state.muleResource;
        if (resource == resource2) {
            return true;
        }
        if (resource == null) {
            this.state.switchSetup(null);
            this.actionQueue.addAction(new DevelopmentAction.GoToMuleStore(this.actionControl));
            return true;
        }
        if (!this.state.testSwitchSetup(resource)) {
            if (this.state.numMules == 0) {
                logger.info("AI: " + this.myPlayer.getName() + " has no mules to buy");
                return false;
            }
            if (this.state.muleResource == null) {
                logger.info("AI: " + this.myPlayer.getName() + " couldn't afford to equip a new mule");
            } else {
                logger.info("AI: " + this.myPlayer.getName() + " couldn't afford to re-equip his current mule");
            }
            if (this.enqueueHuntWampus()) {
                return this.enqueueEquipViaWampus(resource);
            }
            return false;
        }
        if (resource2 == null) {
            this.actionQueue.addAction(new DevelopmentAction.GoToMuleStore(this.actionControl));
        }
        this.actionQueue.addAction(new DevelopmentAction.GoToOutfitStore(this.actionControl, resource));
        this.state.switchSetup(resource);
        return true;
    }

    private boolean enqueueHuntWampus() {
        Properties.mule.getClass();
        logger.info("AI: " + this.myPlayer.getName() + " tries to hunt the wampus.");
        if (!this.state.catchWampus()) {
            logger.info("\t\t\t\t --- already caught.");
            return false;
        }
        logger.info("\t\t\t\t --- success (at least in theory)!");
        if (this.state.switchSetup(null)) {
            this.actionQueue.addAction(new DevelopmentAction.GoToMuleStore(this.actionControl));
        }
        this.actionQueue.addAction(new DevelopmentAction.CatchWampus(this.actionControl));
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SafeSort
    implements Comparator<PlanetTile> {
        private SafeSort() {
        }

        @Override
        public int compare(PlanetTile planetTile, PlanetTile planetTile2) {
            return this.getNetCost(planetTile).compareTo(this.getNetCost(planetTile2));
        }

        private Integer getNetCost(PlanetTile planetTile) {
            int n = ((DevelopmentPlanner)DevelopmentPlanner.this).state.mulePrice;
            int n2 = 0;
            if (!planetTile.isEmpty()) {
                n2 -= n + ((Resource)((Object)((DevelopmentPlanner)DevelopmentPlanner.this).state.get((Object)planetTile))).equipmentCost;
            }
            if (DevelopmentPlanner.this.myPlan.get(planetTile) != null) {
                n2 += n + DevelopmentPlanner.this.myPlan.get((Object)planetTile).equipmentCost;
            }
            return n2;
        }
    }
}

