/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.adam;

import com.turborilla.mule.Properties;
import com.turborilla.mule.ai.ActionQueueListener;
import com.turborilla.mule.ai.DevelopmentAction;
import com.turborilla.mule.ai.DevelopmentActionControl;
import com.turborilla.mule.ai.DevelopmentActionQueue2;
import com.turborilla.mule.ai.adam.AdamAI;
import com.turborilla.mule.ai.adam.DevelopmentPlanner;
import com.turborilla.mule.ai.adam.PlayerLP;
import com.turborilla.mule.controller.WampusMenu;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import java.util.ArrayList;
import java.util.logging.Logger;

public class DevelopmentActuator
implements ActionQueueListener {
    private static Logger logger = Logger.getLogger("mule");
    private AdamAI ai;
    private Player myPlayer;
    private DevelopmentActionQueue2 actionQueue;
    private DevelopmentActionControl actionControl;
    private DevelopmentPlanner developmentPlanner;
    private float wampusProbability;
    private float assayLastProbability;
    private Throwable threadException;
    private Thread myThread;

    public DevelopmentActuator(DevelopmentActionControl developmentActionControl, DevelopmentPlanner developmentPlanner, AdamAI adamAI) {
        this.myPlayer = developmentActionControl.getMyPlayer();
        this.actionQueue = new DevelopmentActionQueue2(this.myPlayer);
        this.actionControl = developmentActionControl;
        this.developmentPlanner = developmentPlanner;
        this.ai = adamAI;
        this.wampusProbability = 0.5f + 0.5f * adamAI.getRandom().nextFloat();
        this.assayLastProbability = 0.5f + 0.25f * adamAI.getRandom().nextFloat();
        developmentPlanner.setQueue(this.actionQueue);
        this.actionQueue.addListener(this);
    }

    public DevelopmentActionQueue2 getActionQueue() {
        return this.actionQueue;
    }

    private void runDevelopmentThread(final GameModel gameModel, final PlayerLP playerLP) {
        this.myThread = new Thread(new Runnable(){

            public void run() {
                try {
                    DevelopmentActuator.this.developmentPlanner.begin(gameModel, playerLP);
                }
                catch (Throwable throwable) {
                    DevelopmentActuator.this.threadException = throwable;
                    System.err.println("Error in DevelopmentActuator.runDevelopmentThread: " + throwable.toString());
                }
            }
        });
        this.myThread.start();
    }

    public void mergeThread(GameModel gameModel) {
        if (this.myThread != null && this.myThread.isAlive()) {
            try {
                this.myThread.join();
                logger.info("Merged the development thread.");
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Error in DevelopmentActuator.mergeThread: " + interruptedException.toString());
            }
        }
    }

    public void begin(GameModel gameModel, PlayerLP playerLP) {
        this.actionQueue.clearActions();
        logger.info("AI: " + this.myPlayer.getName() + " copying development state.");
        this.developmentPlanner.reset(gameModel);
        logger.info("AI: " + this.myPlayer.getName() + " beginning UN-threaded development.");
        this.developmentPlanner.begin(gameModel, playerLP);
    }

    public void beginThreaded(GameModel gameModel, PlayerLP playerLP) {
        this.actionQueue.clearActions();
        logger.info("AI: " + this.myPlayer.getName() + " copying development state.");
        this.developmentPlanner.reset(gameModel);
        logger.info("AI: " + this.myPlayer.getName() + " beginning threaded development.");
        this.runDevelopmentThread(gameModel, playerLP);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(GameModel gameModel, long l) {
        if (!gameModel.getDevelopment().getDevelopmentTimer().isStarted()) {
            return;
        }
        if (!this.developmentPlanner.isDone()) {
            this.mergeThread(gameModel);
            if (!this.developmentPlanner.isSearching()) return;
            this.developmentPlanner.finalizePlan(gameModel);
            return;
        } else {
            if (gameModel.getPhase() == Phase.FAST_DEVELOPMENT) return;
            this.actionQueue.update(gameModel, l);
        }
    }

    public void checkPlanner(GameModel gameModel) {
        if (!gameModel.getDevelopment().getDevelopmentTimer().isStarted()) {
            return;
        }
        if (!this.developmentPlanner.isDone()) {
            this.mergeThread(gameModel);
            if (this.developmentPlanner.isSearching()) {
                this.developmentPlanner.finalizePlan(gameModel);
            }
        }
    }

    public void landClaimed(PlanetTile planetTile, GameModel gameModel) {
    }

    public void actionComplete(GameModel gameModel, DevelopmentAction developmentAction) {
        float f;
        if (this.myPlayer.hasGambled()) {
            logger.info("AI: " + this.myPlayer.getName() + " gambled and can't do more actions.");
            this.actionQueue.clearActions();
        } else if (this.actionQueue.isEmpty()) {
            logger.info("AI: " + this.myPlayer.getName() + " action queue is empty.");
            this.doEndingActions(gameModel);
        } else if (developmentAction instanceof DevelopmentAction.PlaceMule && (f = gameModel.getDevelopment().getTimeLeft()) < 11.0f) {
            logger.info("AI: " + this.myPlayer.getName() + " developed a tile but is short on time: " + f);
            this.actionQueue.clearActions();
            this.doEndingActions(gameModel);
        }
    }

    private void doEndingActions(GameModel gameModel) {
        if (this.myPlayer.getAvatar().getMule() != null) {
            this.actionQueue.addAction(new DevelopmentAction.GoToMuleStore(this.actionControl));
            logger.info("AI: " + this.myPlayer.getName() + " needs to sell his mule before doing anything else!");
            return;
        }
        if (Properties.mule.turnOffExtras || !this.testHuntWampus(gameModel) && !this.testAssayLast(gameModel)) {
            this.actionQueue.addAction(new DevelopmentAction.GoToPub(this.actionControl));
        }
    }

    public void wampusCaught(Player player, GameModel gameModel, WampusMenu wampusMenu) {
        this.actionQueue.catchWampus(player, wampusMenu);
    }

    public void assay(Player player, PlanetTile planetTile, GameModel gameModel) {
        this.actionQueue.assay(player);
    }

    public void mulesChanged(Player player, GameModel gameModel) {
        if (!gameModel.getGameInfo().isSingleDevelopment() && player != this.myPlayer && gameModel.getShop().numMules() == 0) {
            this.actionQueue.clearActions();
            this.developmentPlanner.finalizePlan(gameModel);
        }
    }

    public boolean testHuntWampus(GameModel gameModel) {
        if (gameModel.getWampus().isDead()) {
            return false;
        }
        float f = gameModel.getDevelopment().getTimeLeft();
        if (!gameModel.getDevelopment().getDevelopmentTimer().isStarted()) {
            logger.info("AI: " + this.myPlayer.getName() + " has nothing better to do than hunt the wampus.");
            this.actionQueue.addAction(new DevelopmentAction.CatchWampus(this.actionControl));
            return true;
        }
        if (gameModel.getGameInfo().isFastAiDevelopment()) {
            if (f < Properties.mule.maxDevelopmentTime * 0.6f) {
                logger.info("AI: " + this.myPlayer.getName() + " not enough time to assay.");
                return false;
            }
        } else {
            if (f < Properties.mule.maxDevelopmentTime * 0.25f) {
                logger.info("AI: " + this.myPlayer.getName() + " not enough time to assay.");
                return false;
            }
            if (this.ai.getRandom().nextFloat() > this.wampusProbability) {
                logger.info("AI: " + this.myPlayer.getName() + " chose not to hunt the wampus.");
                return false;
            }
        }
        logger.info("AI: " + this.myPlayer.getName() + " is hunting the wampus.");
        this.actionQueue.addAction(new DevelopmentAction.CatchWampus(this.actionControl));
        return true;
    }

    public boolean testAssayLast(GameModel gameModel) {
        if (Properties.mule.debugAssayLast) {
            return true;
        }
        Properties.mule.getClass();
        float f = gameModel.getDevelopment().getTimeLeft();
        if (gameModel.getGameInfo().isFastAiDevelopment()) {
            if (f < Properties.mule.maxDevelopmentTime * 0.6f) {
                logger.info("AI: " + this.myPlayer.getName() + " not enough time to assay.");
                return false;
            }
        } else if (f < Properties.mule.maxDevelopmentTime * 0.25f) {
            logger.info("AI: " + this.myPlayer.getName() + " not enough time to assay.");
            return false;
        }
        if (this.ai.getRandom().nextFloat() > this.assayLastProbability) {
            logger.info("AI: " + this.myPlayer.getName() + " chose not to assay.");
            return false;
        }
        PlanetTile planetTile = this.chooseAssayTile(gameModel.getMap());
        if (planetTile == null) {
            logger.info("AI: " + this.myPlayer.getName() + " nothing left to assay.");
            return false;
        }
        logger.info("AI: " + this.myPlayer.getName() + " is assaying " + planetTile + ".");
        this.actionQueue.addAction(new DevelopmentAction.GoToAssayStore(this.actionControl));
        this.actionQueue.addAction(new DevelopmentAction.Assay(this.actionControl, planetTile));
        return true;
    }

    public PlanetTile chooseAssayTile(PlanetMap planetMap) {
        int n;
        if (this.ai.getCrystiteDeduction().isAllKnown()) {
            return null;
        }
        ArrayList<PlanetTile> arrayList = new ArrayList<PlanetTile>(15);
        ArrayList<PlanetTile> arrayList2 = new ArrayList<PlanetTile>(40);
        for (int i = 0; i < planetMap.getXSize(); ++i) {
            for (n = 0; n < planetMap.getYSize(); ++n) {
                PlanetTile planetTile = (PlanetTile)planetMap.getTile(i, n);
                if (this.ai.getCrystiteDeduction().isKnown(planetTile) || planetTile.getType() == PlanetTile.PlanetTileType.Shop) continue;
                if (planetTile.getOwner() == null) {
                    arrayList2.add(planetTile);
                    continue;
                }
                if (planetTile.getOwner() != this.myPlayer) continue;
                arrayList.add(planetTile);
            }
        }
        ArrayList<PlanetTile> arrayList3 = null;
        if (arrayList.isEmpty()) {
            if (arrayList2.isEmpty()) {
                return null;
            }
            arrayList3 = arrayList2;
        } else {
            arrayList3 = arrayList;
        }
        n = this.ai.getRandom().nextInt(arrayList3.size());
        return (PlanetTile)arrayList3.get(n);
    }
}

