/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai;

import com.turborilla.mule.ai.AISystem;
import com.turborilla.mule.ai.AbstractAI;
import com.turborilla.mule.model.Auction;
import com.turborilla.mule.model.AuctionLimits;
import com.turborilla.mule.model.AuctionState;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;

public class SimpleAI
extends AbstractAI {
    private static final long serialVersionUID = 1L;
    private final Player player;

    public SimpleAI(AISystem aISystem, Player player) {
        super(aISystem);
        this.player = player;
    }

    public void update(GameModel gameModel, long l) {
        switch (gameModel.getPhase()) {
            case LAND_RUSH: {
                this.updateLandRush(gameModel, l);
                break;
            }
            case DEVELOPMENT: {
                break;
            }
            case AUCTION_CRYSTITE: {
                this.updateAuction(Resource.Crystite, gameModel, l);
                break;
            }
            case AUCTION_SMITHORE: {
                this.updateAuction(Resource.Smithore, gameModel, l);
                break;
            }
            case AUCTION_ENERGY: {
                this.updateAuction(Resource.Energy, gameModel, l);
                break;
            }
            case AUCTION_FOOD: {
                this.updateAuction(Resource.Food, gameModel, l);
                break;
            }
            default: {
                if (this.player.isContinue()) break;
                this.buttonState.setActionButtonPressed(true);
            }
        }
    }

    public void updateLandRush(GameModel gameModel, long l) {
        switch ((int)(l % 4L)) {
            case 0: {
                this.buttonState.setUpPressed(true);
            }
            case 1: {
                this.buttonState.setDownPressed(true);
            }
            case 2: {
                this.buttonState.setLeftPressed(true);
            }
            case 3: {
                this.buttonState.setRightPressed(true);
            }
        }
    }

    public void updateAuction(Resource resource, GameModel gameModel, long l) {
        int n = this.player.getResource(resource);
        int n2 = this.player.getResourceCritical(resource, gameModel);
        if (resource == Resource.Energy) {
            ++n2;
        }
        if (!this.player.isContinue()) {
            if (n <= n2) {
                this.buttonState.setDown(true);
                if (this.player.isBuyer()) {
                    this.buttonState.setActionButtonPressed(true);
                }
            } else if (n > n2) {
                this.buttonState.setUp(true);
                if (!this.player.isBuyer()) {
                    this.buttonState.setActionButtonPressed(true);
                }
            }
        } else {
            Auction auction = gameModel.getAuction();
            AuctionLimits auctionLimits = auction.getCurrentLimits();
            AuctionState auctionState = this.player.getAuctionState();
            if (this.player.isBuyer()) {
                if (n < n2) {
                    if (!auctionState.isInAuction() || auctionState.getTick() < auctionLimits.auctionSellTick) {
                        this.buttonState.setUp(true);
                    }
                } else if (auctionState.isInAuction()) {
                    this.buttonState.setDown(true);
                }
            } else if (n > n2) {
                if (!auctionState.isInAuction() || auctionState.getTick() > auctionLimits.auctionBuyTick) {
                    this.buttonState.setDown(true);
                }
            } else if (auctionState.isInAuction()) {
                this.buttonState.setUp(true);
            }
        }
    }

    public boolean isThinking() {
        return false;
    }
}

