/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai;

import com.turborilla.mule.MuleMath;
import com.turborilla.mule.Properties;
import com.turborilla.mule.model.Shop;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.model.util.Vec2;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PathFindingGraph {
    private int numLandNodesX;
    private int numLandNodesY;
    private float landSpacingX;
    private float landSpacingY;
    private float landStartX;
    private float landStartY;
    private ArrayList<Node> landNodes;
    private final Node crystiteNode;
    private final Node smithoreNode;
    private final Node energyNode;
    private final Node foodNode;
    private final Node assayNode;
    private final Node landSaleNode;
    private final Node pubNode;
    private final Node muleStoreNode;
    private final Node outsideMuleStoreNode;
    private ArrayList<Node> shopNodes;
    private ArrayList<Node> landEnteranceNodes;
    private ArrayList<Node> shopEnteranceNodes;
    public static final int EAST = 0;
    public static final int NORTH = 1;
    public static final int WEST = 2;
    public static final int SOUTH = 3;
    private float[][] heuristics;
    private static final int landGranularity = 4;
    private static final float[] edgeWeightLand = new float[3];
    private static final float[] edgeWeightObstacle1 = new float[3];
    private static final float[] edgeWeightObstacle2 = new float[3];
    private static final int EDGE_X = 0;
    private static final int EDGE_Y = 1;
    private static final int EDGE_DIAG = 2;
    private static final float invShopSpeed = 1.0f / Properties.mule.shopMovingSpeed;

    /*
     * WARNING - void declaration
     */
    public PathFindingGraph(PlanetMap planetMap, Shop shop) {
        void var10_17;
        Node[][] nodeArrayArray;
        void var10_15;
        int n;
        int n2;
        Object object;
        float f;
        ArrayList<Portal> arrayList = new ArrayList<Portal>();
        this.numLandNodesX = 4 * planetMap.getXSize();
        this.numLandNodesY = 4 * planetMap.getYSize();
        this.landSpacingX = 16.0f;
        this.landSpacingY = 16.0f;
        this.landStartX = this.landSpacingX / 2.0f;
        this.landStartY = this.landSpacingY / 2.0f;
        this.landNodes = new ArrayList(this.numLandNodesX * this.numLandNodesY);
        PlanetTile planetTile = planetMap.getShopTile();
        for (int i = 0; i < this.numLandNodesY; ++i) {
            for (int j = 0; j < this.numLandNodesX; ++j) {
                int n3;
                f = this.landStartX + (float)j * this.landSpacingX;
                float f2 = this.landStartY + (float)i * this.landSpacingY;
                object = (PlanetTile)planetMap.getTile(j / 4, i / 4);
                boolean n32 = ((PlanetTile)object).isInCollision(f, f2);
                n2 = 1;
                if (object == planetTile) {
                    n3 = j % 4;
                    n = i % 4;
                    if (n3 == 0) {
                        arrayList.add(new Portal(j - 1, i, 2));
                    } else if (n3 == 3) {
                        arrayList.add(new Portal(j + 1, i, 0));
                    }
                    if (n == 0) {
                        arrayList.add(new Portal(j, i - 1, 1));
                    } else if (n == 3) {
                        arrayList.add(new Portal(j, i + 1, 3));
                    }
                    n2 = 0;
                }
                n3 = this.landNodes.size();
                this.landNodes.add(new Node(n3, f, f2, false, n32, n2 != 0));
            }
        }
        this.landEnteranceNodes = new ArrayList(4);
        this.landEnteranceNodes.add(this.getNodeAtPosition(planetMap.getEastEnterance(), false));
        this.landEnteranceNodes.add(this.getNodeAtPosition(planetMap.getNorthEnterance(), false));
        this.landEnteranceNodes.add(this.getNodeAtPosition(planetMap.getWestEnterance(), false));
        this.landEnteranceNodes.add(this.getNodeAtPosition(planetMap.getSouthEnterance(), false));
        this.shopNodes = new ArrayList();
        this.crystiteNode = this.createShopNode(52.0f, 95.0f);
        this.smithoreNode = this.createShopNode(153.0f, 95.0f);
        this.energyNode = this.createShopNode(290.0f, 95.0f);
        this.foodNode = this.createShopNode(389.0f, 95.0f);
        this.assayNode = this.createShopNode(52.0f, 263.0f);
        this.landSaleNode = this.createShopNode(153.0f, 263.0f);
        this.pubNode = this.createShopNode(290.0f, 263.0f);
        this.muleStoreNode = this.createShopNode(389.0f, 263.0f);
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        arrayList2.add(this.createShopNode(52.0f, 180.0f));
        arrayList2.add(this.createShopNode(153.0f, 180.0f));
        arrayList2.add(this.createShopNode(219.0f, 180.0f));
        arrayList2.add(this.createShopNode(290.0f, 180.0f));
        this.outsideMuleStoreNode = this.createShopNode(389.0f, 180.0f);
        arrayList2.add(this.outsideMuleStoreNode);
        this.shopEnteranceNodes = new ArrayList(4);
        this.shopEnteranceNodes.add(this.createShopNode(420.0f, 180.0f));
        this.shopEnteranceNodes.add(this.createShopNode(219.0f, 20.0f));
        this.shopEnteranceNodes.add(this.createShopNode(20.0f, 180.0f));
        this.shopEnteranceNodes.add(this.createShopNode(219.0f, 328.0f));
        float f3 = 1.0f / Properties.mule.landMovingSpeed;
        f = 1.0f / Properties.mule.obstacleMovingSpeedFactor;
        PathFindingGraph.edgeWeightLand[0] = this.landSpacingX * f3;
        PathFindingGraph.edgeWeightLand[1] = this.landSpacingY * f3;
        PathFindingGraph.edgeWeightLand[2] = (float)(Math.sqrt(this.landSpacingX * this.landSpacingX + this.landSpacingY * this.landSpacingY) * (double)f3);
        PathFindingGraph.edgeWeightObstacle1[0] = edgeWeightLand[0] * (1.0f + f) / 2.0f;
        PathFindingGraph.edgeWeightObstacle1[1] = edgeWeightLand[1] * (1.0f + f) / 2.0f;
        PathFindingGraph.edgeWeightObstacle1[2] = edgeWeightLand[2] * (1.0f + f) / 2.0f;
        PathFindingGraph.edgeWeightObstacle2[0] = edgeWeightLand[0] * f;
        PathFindingGraph.edgeWeightObstacle2[1] = edgeWeightLand[1] * f;
        PathFindingGraph.edgeWeightObstacle2[2] = edgeWeightLand[2] * f;
        int[][] nArrayArray = new int[][]{{1, 0}, {1, 1}, {0, 1}, {-1, 1}};
        object = new int[]{0, 2, 1, 2};
        boolean f4 = false;
        while (var10_15 < this.numLandNodesY) {
            for (n2 = 0; n2 < this.numLandNodesX; ++n2) {
                Node node = this.getLandNode(n2, (int)var10_15);
                for (n = 0; n < nArrayArray.length; ++n) {
                    nodeArrayArray = this.getLandNode(n2 + nArrayArray[n][0], (int)(var10_15 + nArrayArray[n][1]));
                    if (nodeArrayArray == null) continue;
                    this.createLandEdge(node, (Node)nodeArrayArray, (int)object[n]);
                }
            }
            ++var10_15;
        }
        this.createShopEdge(this.crystiteNode, (Node)arrayList2.get(0));
        this.createShopEdge(this.smithoreNode, (Node)arrayList2.get(1));
        this.createShopEdge(this.energyNode, (Node)arrayList2.get(3));
        this.createShopEdge(this.foodNode, (Node)arrayList2.get(4));
        this.createShopEdge(this.assayNode, (Node)arrayList2.get(0));
        this.createShopEdge(this.landSaleNode, (Node)arrayList2.get(1));
        this.createShopEdge(this.pubNode, (Node)arrayList2.get(3));
        this.createShopEdge(this.muleStoreNode, (Node)arrayList2.get(4));
        boolean bl = false;
        while (var10_17 < arrayList2.size() - 1) {
            this.createShopEdge((Node)arrayList2.get((int)var10_17), (Node)arrayList2.get((int)(var10_17 + true)));
            ++var10_17;
        }
        this.createShopEdge(this.shopEnteranceNodes.get(0), (Node)arrayList2.get(4));
        this.createShopEdge(this.shopEnteranceNodes.get(1), (Node)arrayList2.get(2));
        this.createShopEdge(this.shopEnteranceNodes.get(2), (Node)arrayList2.get(0));
        this.createShopEdge(this.shopEnteranceNodes.get(3), (Node)arrayList2.get(2));
        int n4 = 4 * planetTile.getPosX();
        n2 = 4 * planetTile.getPosY();
        Object object2 = new int[]{n4 - 1, n4, n4 - 1 + 4, n4 + 4};
        Object object3 = new int[]{n2 - 1, n2, n2 - 1 + 4, n2 + 4};
        for (Node[] nodeArray : nodeArrayArray = new Node[][]{{this.getLandNode(object2[1], object3[0]), this.getLandNode(object2[0], object3[1])}, {this.getLandNode(object2[0], object3[2]), this.getLandNode(object2[1], object3[3])}, {this.getLandNode(object2[2], object3[3]), this.getLandNode(object2[3], object3[2])}, {this.getLandNode(object2[3], object3[1]), this.getLandNode(object2[2], object3[0])}}) {
            block7: for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < nodeArray[i].edges.size(); ++j) {
                    if (((Edge)((Node)nodeArray[i]).edges.get((int)j)).neighbor != nodeArray[(i + 1) % 2]) continue;
                    nodeArray[i].edges.remove(j);
                    continue block7;
                }
            }
        }
        float f2 = 3.0f * edgeWeightLand[0];
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object2 = (Portal)iterator.next();
            object3 = this.getLandNode(((Portal)object2).x, ((Portal)object2).y);
            if (object3 == null || !((Node)object3).isReachable()) continue;
            ((Node)object3).addEdge(new Edge(this.shopEnteranceNodes.get(((Portal)object2).direction), f2));
        }
        for (int i = 0; i < 4; ++i) {
            object2 = this.shopEnteranceNodes.get(i);
            object3 = this.landEnteranceNodes.get(i);
            ((Node)object2).addEdge(new Edge((Node)object3, f2));
        }
        this.calcHeuristics(planetMap.getShopCenter());
    }

    private Node createShopNode(float f, float f2) {
        int n = this.landNodes.size() + this.shopNodes.size();
        Node node = new Node(n, f, f2, true, false, true);
        this.shopNodes.add(node);
        return node;
    }

    private void calcHeuristics(Vec2 vec2) {
        float f;
        Node node;
        Node node2;
        int n;
        int n2;
        int n3 = this.landNodes.size() + this.shopNodes.size();
        this.heuristics = new float[n3][n3];
        float f2 = 1.0f / Properties.mule.landMovingSpeed;
        float f3 = 1.0f / Properties.mule.shopMovingSpeed;
        for (n2 = 0; n2 < this.landNodes.size(); ++n2) {
            for (n = n2; n < this.landNodes.size(); ++n) {
                node2 = this.landNodes.get(n2);
                node = this.landNodes.get(n);
                this.heuristics[((Node)node2).index][((Node)node).index] = f = f2 * node2.pos.distance(node.pos);
            }
            for (n = 0; n < this.shopNodes.size(); ++n) {
                node2 = this.landNodes.get(n2);
                node = this.shopNodes.get(n);
                this.heuristics[((Node)node2).index][((Node)node).index] = f = f2 * node2.pos.distance(vec2);
            }
        }
        for (n2 = 0; n2 < this.shopNodes.size(); ++n2) {
            for (n = n2; n < this.shopNodes.size(); ++n) {
                node2 = this.shopNodes.get(n2);
                node = this.shopNodes.get(n);
                this.heuristics[((Node)node2).index][((Node)node).index] = f = f3 * node2.pos.distance(node.pos);
            }
        }
    }

    public float getHeuristic(int n, int n2) {
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        return this.heuristics[n][n2];
    }

    public Node getNodeAtPosition(Vec2 vec2, boolean bl) {
        return this.getNodeAtPosition(vec2.x, vec2.y, bl);
    }

    public Node getNodeAtPosition(float f, float f2, boolean bl) {
        if (bl) {
            float f3 = Float.MAX_VALUE;
            int n = -1;
            for (int i = 0; i < this.shopNodes.size(); ++i) {
                Node node = this.shopNodes.get(i);
                float f4 = MuleMath.distanceSquare(f, f2, ((Node)node).pos.x, ((Node)node).pos.y);
                if (!(f4 < f3)) continue;
                f3 = f4;
                n = i;
            }
            return this.shopNodes.get(n);
        }
        int n = MuleMath.clamp(Math.round((f - this.landStartX) / this.landSpacingX), 0, this.numLandNodesX - 1);
        int n2 = MuleMath.clamp(Math.round((f2 - this.landStartY) / this.landSpacingY), 0, this.numLandNodesY - 1);
        return this.getLandNode(n, n2);
    }

    private Node getLandNode(int n, int n2) {
        if (n < 0 || n >= this.numLandNodesX) {
            return null;
        }
        if (n2 < 0 || n2 >= this.numLandNodesY) {
            return null;
        }
        return this.landNodes.get(n2 * this.numLandNodesX + n);
    }

    private void createLandEdge(Node node, Node node2, int n) {
        if (node.isReachable() && node2.isReachable()) {
            float f = 0.0f;
            f = node.inCollision && node2.inCollision ? edgeWeightObstacle2[n] : (node.inCollision || node2.inCollision ? edgeWeightObstacle1[n] : edgeWeightLand[n]);
            node.addEdge(new Edge(node2, f));
            node2.addEdge(new Edge(node, f));
        }
    }

    private void createShopEdge(Node node, Node node2) {
        float f = node.pos.distance(node2.pos);
        float f2 = f * invShopSpeed;
        node.addEdge(new Edge(node2, f2));
        node2.addEdge(new Edge(node, f2));
    }

    public Node getClosestNode(PlanetTile planetTile, float f, float f2) {
        int n = planetTile.getPosX() * 4;
        int n2 = planetTile.getPosY() * 4;
        int n3 = MuleMath.clamp(Math.round((f - this.landStartX) / this.landSpacingX), n, n + 4 - 1);
        int n4 = MuleMath.clamp(Math.round((f2 - this.landStartY) / this.landSpacingY), n2, n2 + 4 - 1);
        return this.getLandNode(n3, n4);
    }

    public ArrayList<Node> getLandNodes() {
        return this.landNodes;
    }

    public ArrayList<Node> getShopNodes() {
        return this.shopNodes;
    }

    public int numNodes() {
        return this.landNodes.size() + this.shopNodes.size();
    }

    public Node getCrystiteNode() {
        return this.crystiteNode;
    }

    public Node getSmithoreNode() {
        return this.smithoreNode;
    }

    public Node getEnergyNode() {
        return this.energyNode;
    }

    public Node getFoodNode() {
        return this.foodNode;
    }

    public Node getAssayNode() {
        return this.assayNode;
    }

    public Node getLandSaleNode() {
        return this.landSaleNode;
    }

    public Node getPubNode() {
        return this.pubNode;
    }

    public Node getMuleStoreNode() {
        return this.muleStoreNode;
    }

    public Node getOutsideMuleStoreNode() {
        return this.outsideMuleStoreNode;
    }

    public final class Edge {
        protected Node neighbor;
        protected float weight;

        public Edge(Node node, float f) {
            this.neighbor = node;
            this.weight = f;
        }

        public Node getNeighbor() {
            return this.neighbor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Node {
        private int index;
        private Vec2 pos;
        private boolean inShop;
        private boolean inCollision;
        private boolean reachable;
        private ArrayList<Edge> edges;

        public Node(int n, float f, float f2, boolean bl, boolean bl2, boolean bl3) {
            this.index = n;
            this.pos = new Vec2(f, f2);
            this.inShop = bl;
            this.inCollision = bl2;
            this.reachable = bl3;
            this.edges = new ArrayList(8);
        }

        public Vec2 getPos() {
            return this.pos;
        }

        public ArrayList<Edge> getEdges() {
            return this.edges;
        }

        protected void addEdge(Edge edge) {
            this.edges.add(edge);
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isReachable() {
            return this.reachable;
        }

        public boolean isInShop() {
            return this.inShop;
        }
    }

    public final class Portal {
        int x;
        int y;
        int direction;

        public Portal(int n, int n2, int n3) {
            this.x = n;
            this.y = n2;
            this.direction = n3;
        }
    }
}

