/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai;

import com.turborilla.mule.ai.ActionQueueListener;
import com.turborilla.mule.ai.DevelopmentAction;
import com.turborilla.mule.controller.WampusMenu;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Logger;

public class DevelopmentActionQueue2 {
    private static final Logger logger = Logger.getLogger("mule");
    private final Player myPlayer;
    private final LinkedList<DevelopmentAction> actionQueue;
    private DevelopmentAction currentAction = null;
    private final ArrayList<ActionQueueListener> listeners;

    public DevelopmentActionQueue2(Player player) {
        this.myPlayer = player;
        this.actionQueue = new LinkedList();
        this.listeners = new ArrayList();
    }

    public void addAction(DevelopmentAction developmentAction) {
        logger.info("AI: " + this.myPlayer.getName() + " Queue: " + developmentAction.getClass().getSimpleName());
        this.actionQueue.add(developmentAction);
    }

    public void clearActions() {
        this.currentAction = null;
        this.actionQueue.clear();
    }

    public boolean isEmpty() {
        return this.actionQueue.isEmpty();
    }

    public DevelopmentAction poll() {
        this.currentAction = null;
        return this.actionQueue.poll();
    }

    public DevelopmentAction getCurrentAction() {
        return this.currentAction;
    }

    public void update(GameModel gameModel, long l) {
        DevelopmentAction developmentAction = null;
        while ((developmentAction = this.actionQueue.peek()) != null) {
            if (developmentAction != this.currentAction) {
                this.currentAction = developmentAction;
                logger.info("AI: " + this.myPlayer.getName() + " Action: " + developmentAction.getClass().getSimpleName());
                developmentAction.begin(gameModel, l);
            }
            if (developmentAction.isCompleted()) {
                this.actionQueue.poll();
                this.currentAction = null;
                for (ActionQueueListener actionQueueListener : this.listeners) {
                    actionQueueListener.actionComplete(gameModel, developmentAction);
                }
                continue;
            }
            developmentAction.update(gameModel, l);
            break;
        }
    }

    public void addListener(ActionQueueListener actionQueueListener) {
        this.listeners.add(actionQueueListener);
    }

    public void removeListener(ActionQueueListener actionQueueListener) {
        this.listeners.remove(actionQueueListener);
    }

    public void catchWampus(Player player, WampusMenu wampusMenu) {
        if (this.currentAction != null) {
            if (this.currentAction instanceof DevelopmentAction.CatchWampus) {
                ((DevelopmentAction.CatchWampus)this.currentAction).caughtWampus(player, wampusMenu);
            } else if (player == this.myPlayer) {
                if (this.currentAction instanceof DevelopmentAction.ClickTile) {
                    ((DevelopmentAction.ClickTile)this.currentAction).caughtWampus();
                } else {
                    logger.severe("AI: " + player.toString() + " shouldn't catch wampus during action " + this.currentAction.getClass().getSimpleName());
                }
            }
        }
    }

    public void assay(Player player) {
        if (this.currentAction != null && player == this.myPlayer) {
            if (this.currentAction instanceof DevelopmentAction.Assay) {
                ((DevelopmentAction.Assay)this.currentAction).assayDone();
            } else {
                logger.severe("AI: " + player.toString() + " shouldn't assay during action " + this.currentAction.getClass().getSimpleName());
            }
        }
    }
}

