/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai;

import com.turborilla.mule.ai.DevelopmentActionControl;
import com.turborilla.mule.ai.PathFinder;
import com.turborilla.mule.ai.PathFindingGraph;
import com.turborilla.mule.ai.PathWalker;
import com.turborilla.mule.controller.WampusMenu;
import com.turborilla.mule.model.Avatar;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.Wampus;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.model.util.Vec2;

public abstract class DevelopmentAction {
    final DevelopmentActionControl control;

    DevelopmentAction(DevelopmentActionControl developmentActionControl) {
        this.control = developmentActionControl;
    }

    abstract void begin(GameModel var1, long var2);

    abstract void update(GameModel var1, long var2);

    abstract boolean isCompleted();

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class GoToPub
    extends DevelopmentAction {
        public GoToPub(DevelopmentActionControl developmentActionControl) {
            super(developmentActionControl);
        }

        void begin(GameModel gameModel, long l) {
            PathFindingGraph.Node node = this.control.getPathFindingGraph().getPubNode();
            PathFinder.Path path = this.control.findLocation(node);
            this.control.getPathWalker().setPath(path);
        }

        boolean isCompleted() {
            return this.control.getMyPlayer().hasGambled();
        }

        void update(GameModel gameModel, long l) {
            this.control.getPathWalker().update(gameModel.getMap(), gameModel.getShop());
        }
    }

    public static class Assay
    extends ClickTile {
        private boolean done = false;

        public Assay(DevelopmentActionControl developmentActionControl, PlanetTile planetTile) {
            super(developmentActionControl, planetTile);
        }

        boolean isCompleted() {
            return this.done;
        }

        void assayDone() {
            this.done = true;
        }
    }

    public static class CatchWampus
    extends DevelopmentAction {
        private Vec2 pos = new Vec2(-1.0f, -1.0f);
        private boolean clicked = false;
        private boolean done = false;
        private WampusMenu menu;

        public CatchWampus(DevelopmentActionControl developmentActionControl) {
            super(developmentActionControl);
        }

        void begin(GameModel gameModel, long l) {
            Wampus wampus = gameModel.getWampus();
            if (wampus.isDead()) {
                this.done = true;
            } else if (wampus.hasAppeared()) {
                this.findWampus(gameModel);
            }
        }

        boolean isCompleted() {
            return this.done;
        }

        void update(GameModel gameModel, long l) {
            Wampus wampus = gameModel.getWampus();
            if (!wampus.hasAppeared()) {
                return;
            }
            if (!wampus.getPos().equals(this.pos)) {
                this.findWampus(gameModel);
            }
            PathWalker pathWalker = this.control.getPathWalker();
            pathWalker.update(gameModel.getMap(), gameModel.getShop());
            if (pathWalker.isCompleted()) {
                if (!this.clicked) {
                    this.clicked = true;
                    this.control.getButtonState().setActionButtonPressed(true);
                }
                if (!this.done && this.menu != null && this.menu.isIntroComplete()) {
                    this.control.getButtonState().setActionButtonPressed(true);
                    this.done = true;
                }
            }
        }

        private void findWampus(GameModel gameModel) {
            this.pos.set(gameModel.getWampus().getPos());
            PathFinder.Path path = this.control.findLocation(this.pos, false);
            this.control.getPathWalker().setPath(path);
        }

        void caughtWampus(Player player, WampusMenu wampusMenu) {
            this.menu = wampusMenu;
        }
    }

    public static class PlaceMule
    extends ClickTile {
        public Resource targetResource;

        public PlaceMule(DevelopmentActionControl developmentActionControl, PlanetTile planetTile, Resource resource) {
            super(developmentActionControl, planetTile);
            this.targetResource = resource;
        }

        boolean isCompleted() {
            return this.targetResource == PlanetTile.getResourceFromTile(this.tile);
        }
    }

    public static class ClaimTile
    extends ClickTile {
        public ClaimTile(DevelopmentActionControl developmentActionControl, PlanetTile planetTile) {
            super(developmentActionControl, planetTile);
        }

        boolean isCompleted() {
            return this.tile.getOwner() != null;
        }
    }

    static abstract class ClickTile
    extends DevelopmentAction {
        protected PlanetTile tile;
        private int clicks;
        private int numClicks;

        ClickTile(DevelopmentActionControl developmentActionControl, PlanetTile planetTile) {
            super(developmentActionControl);
            this.tile = planetTile;
            this.numClicks = 1;
        }

        void begin(GameModel gameModel, long l) {
            Avatar avatar = this.control.getAvatar();
            Vec2 vec2 = avatar.getPosition();
            if (avatar.isInShop()) {
                vec2 = gameModel.getMap().getShopCenter();
            }
            PathFindingGraph.Node node = this.control.getPathFindingGraph().getClosestNode(this.tile, vec2.x, vec2.y);
            PathFinder.Path path = this.control.findLocation(node.getPos(), false);
            this.control.getPathWalker().setPath(path);
        }

        void update(GameModel gameModel, long l) {
            PathWalker pathWalker = this.control.getPathWalker();
            pathWalker.update(gameModel.getMap(), gameModel.getShop());
            if (pathWalker.isCompleted() && this.clicks < this.numClicks) {
                this.control.getButtonState().setActionButtonPressed(true);
                ++this.clicks;
            }
        }

        void caughtWampus() {
            --this.clicks;
        }

        public PlanetTile getTile() {
            return this.tile;
        }
    }

    public static class GoToAssayStore
    extends DevelopmentAction {
        public GoToAssayStore(DevelopmentActionControl developmentActionControl) {
            super(developmentActionControl);
        }

        void begin(GameModel gameModel, long l) {
            PathFindingGraph.Node node = this.control.getPathFindingGraph().getAssayNode();
            PathFinder.Path path = this.control.findLocation(node);
            this.control.getPathWalker().setPath(path);
        }

        boolean isCompleted() {
            return this.control.getPathWalker().isCompleted();
        }

        void update(GameModel gameModel, long l) {
            this.control.getPathWalker().update(gameModel.getMap(), gameModel.getShop());
        }
    }

    public static class GoToOutfitStore
    extends DevelopmentAction {
        private Resource resource;

        public GoToOutfitStore(DevelopmentActionControl developmentActionControl, Resource resource) {
            super(developmentActionControl);
            this.resource = resource;
        }

        void begin(GameModel gameModel, long l) {
            PathFinder.Path path = null;
            PathFindingGraph pathFindingGraph = this.control.getPathFindingGraph();
            switch (this.resource) {
                case Crystite: {
                    path = this.control.findLocation(pathFindingGraph.getCrystiteNode());
                    break;
                }
                case Smithore: {
                    path = this.control.findLocation(pathFindingGraph.getSmithoreNode());
                    break;
                }
                case Energy: {
                    path = this.control.findLocation(pathFindingGraph.getEnergyNode());
                    break;
                }
                case Food: {
                    path = this.control.findLocation(pathFindingGraph.getFoodNode());
                }
            }
            this.control.getPathWalker().setPath(path);
        }

        boolean isCompleted() {
            return this.control.getPathWalker().isCompleted();
        }

        void update(GameModel gameModel, long l) {
            this.control.getPathWalker().update(gameModel.getMap(), gameModel.getShop());
        }

        public Resource getResource() {
            return this.resource;
        }
    }

    public static class GoToMuleStore
    extends DevelopmentAction {
        private boolean goingOutside;

        public GoToMuleStore(DevelopmentActionControl developmentActionControl) {
            super(developmentActionControl);
        }

        void begin(GameModel gameModel, long l) {
            this.findTarget(gameModel);
        }

        private void findTarget(GameModel gameModel) {
            PathFindingGraph.Node node;
            Avatar avatar = this.control.getAvatar();
            Vec2 vec2 = avatar.getPosition();
            if (gameModel.getShop().getMuleStore().intersects(vec2.x, vec2.y, avatar.getGeometry())) {
                node = this.control.getPathFindingGraph().getOutsideMuleStoreNode();
                this.goingOutside = true;
            } else {
                node = this.control.getPathFindingGraph().getMuleStoreNode();
                this.goingOutside = false;
            }
            PathFinder.Path path = this.control.findLocation(node);
            this.control.getPathWalker().setPath(path);
        }

        boolean isCompleted() {
            return !this.goingOutside && this.control.getPathWalker().isCompleted();
        }

        void update(GameModel gameModel, long l) {
            this.control.getPathWalker().update(gameModel.getMap(), gameModel.getShop());
            if (this.goingOutside && this.control.getPathWalker().isCompleted()) {
                this.findTarget(gameModel);
            }
        }
    }

    public static class NullAction
    extends DevelopmentAction {
        public NullAction(DevelopmentActionControl developmentActionControl) {
            super(developmentActionControl);
        }

        void begin(GameModel gameModel, long l) {
        }

        boolean isCompleted() {
            return true;
        }

        void update(GameModel gameModel, long l) {
        }
    }
}

