/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai;

import com.turborilla.mule.ai.AISystem;
import com.turborilla.mule.ai.DevelopmentAction;
import com.turborilla.mule.controller.PlayerControllerState;
import com.turborilla.mule.controller.WampusMenu;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.map.PlanetTile;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAI
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final AISystem aiSystem;
    protected final PlayerControllerState buttonState;

    public AbstractAI(AISystem aISystem) {
        this.aiSystem = aISystem;
        this.buttonState = new PlayerControllerState();
    }

    public abstract void update(GameModel var1, long var2);

    public abstract boolean isThinking();

    public DevelopmentAction nextDevelopmentAction(GameModel gameModel) {
        return null;
    }

    public void developmentActionCompleted(GameModel gameModel, DevelopmentAction developmentAction) {
    }

    public void beginPhase(Phase phase, GameModel gameModel) {
    }

    public void endPhase(Phase phase, GameModel gameModel) {
    }

    public void landClaimed(PlanetTile planetTile, GameModel gameModel) {
    }

    public void mulesChanged(Player player, GameModel gameModel) {
    }

    public void wampusCaught(Player player, GameModel gameModel, WampusMenu wampusMenu) {
    }

    public void assay(Player player, PlanetTile planetTile, GameModel gameModel) {
    }

    public void meteoriteStrike(PlanetTile planetTile) {
    }

    public void beginLandAuction(GameModel gameModel) {
    }

    public void beginAuction(GameModel gameModel) {
    }

    public void transaction(GameModel gameModel, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2) {
    }
}

