/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai;

import com.turborilla.mule.ai.AbstractAI;
import com.turborilla.mule.controller.PlayerController;
import com.turborilla.mule.controller.PlayerControllerState;
import com.turborilla.mule.model.GameModel;

public class AIPlayerController
extends PlayerController {
    private static final long serialVersionUID = 1L;
    private AbstractAI ai;
    private PlayerControllerState state;

    public AIPlayerController(AbstractAI abstractAI) {
        this.state = abstractAI.buttonState;
        this.ai = abstractAI;
        this.ai.aiSystem.addAi(abstractAI);
    }

    public void uninstall() {
        this.ai.aiSystem.removeAi(this.ai);
    }

    public void update(GameModel gameModel, long l) {
        this.state.clear();
        this.ai.update(gameModel, l);
    }

    public boolean isUp() {
        return this.state.isUp();
    }

    public boolean isDown() {
        return this.state.isDown();
    }

    public boolean isLeft() {
        return this.state.isLeft();
    }

    public boolean isRight() {
        return this.state.isRight();
    }

    public boolean isUpPressed() {
        return this.state.isUpPressed();
    }

    public boolean isDownPressed() {
        return this.state.isDownPressed();
    }

    public boolean isLeftPressed() {
        return this.state.isLeftPressed();
    }

    public boolean isRightPressed() {
        return this.state.isRightPressed();
    }

    public boolean isActionButtonPressed() {
        return this.state.isActionButtonPressed();
    }

    public boolean isActionButtonDown() {
        return this.state.isActionButtonDown();
    }

    public boolean isRemote() {
        return false;
    }

    public AbstractAI getAi() {
        return this.ai;
    }
}

