/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule;

import com.turborilla.mule.Properties;
import com.turborilla.mule.PropertiesBase;
import java.io.FileNotFoundException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Settings
extends PropertiesBase
implements Cloneable {
    private static Stack<Settings> settings;
    private static String settingsPath;
    public String username = "";
    public String manualJoinAddress = "";
    public String masterServer = "";
    public int[] primaryKeys = new int[13];
    public int[] secondaryKeys = new int[13];
    public boolean soundOn = true;
    public boolean playLoginMusic = true;
    public String mapSkin;
    public String windowSkin;
    public boolean fastAiDevelopment;
    public int vsync;
    public boolean useTwoWindows;
    public boolean useAWTGLCanvas;
    public boolean ignoreRepaint;
    public boolean snapFullscreenScale;
    public int bufferStrategy;
    public static final int VSYNC_OFF = 0;
    public static final int VSYNC_ON = 1;
    public static final int VSYNC_AUTO = 2;

    public static void create() {
        settings = new Stack();
        settings.push(new Settings());
    }

    public static Settings get() {
        return settings.peek();
    }

    public static void push() {
        Settings settings = Settings.settings.peek().clone();
        Settings.settings.push(settings);
    }

    public static void pop() {
        settings.pop();
    }

    public Settings() {
        super(false);
        this.mapSkin = Properties.mule.defaultMapSkin;
        this.windowSkin = Properties.mule.defaultWindowSkin;
        this.fastAiDevelopment = true;
        this.vsync = 1;
        this.useTwoWindows = false;
        this.useAWTGLCanvas = false;
        this.ignoreRepaint = true;
        this.snapFullscreenScale = true;
        this.bufferStrategy = 1;
        this.primaryKeys[0] = 38;
        this.primaryKeys[1] = 40;
        this.primaryKeys[2] = 37;
        this.primaryKeys[3] = 39;
        this.primaryKeys[4] = 32;
        this.primaryKeys[5] = 116;
        this.secondaryKeys[0] = 87;
        this.secondaryKeys[1] = 83;
        this.secondaryKeys[2] = 65;
        this.secondaryKeys[3] = 68;
        this.secondaryKeys[4] = 17;
        try {
            this.readFromFile(settingsPath);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger logger = Logger.getLogger("mule");
            logger.info("Settings file not found: " + fileNotFoundException.getMessage());
        }
    }

    public void saveToFile() {
        try {
            this.writeToFile(settingsPath);
        }
        catch (Exception exception) {
            Logger logger = Logger.getLogger("mule");
            logger.severe("Failed to save settings to \"+settingsPath+\". " + exception.toString());
        }
    }

    public Settings clone() {
        try {
            Settings settings = (Settings)super.clone();
            settings.primaryKeys = (int[])this.primaryKeys.clone();
            settings.secondaryKeys = (int[])this.secondaryKeys.clone();
            return settings;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Logger logger = Logger.getLogger("mule");
            logger.log(Level.SEVERE, cloneNotSupportedException.toString(), cloneNotSupportedException);
            return null;
        }
    }

    static {
        settingsPath = "settings.txt";
    }
}

