/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule;

import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLEncode {
    private static final String[] ENTITIES = new String[]{">", "&gt;", "<", "&lt;", "&", "&amp;", "\"", "&quot;", "'", "&#039;", "\\", "&#092;", "\u00a9", "&copy;", "\u00ae", "&reg;"};
    private static Hashtable<String, String> entityTableEncode = null;

    private HTMLEncode() {
    }

    protected static synchronized void buildEntityTables() {
        entityTableEncode = new Hashtable(ENTITIES.length);
        for (int i = 0; i < ENTITIES.length; i += 2) {
            if (entityTableEncode.containsKey(ENTITIES[i])) continue;
            entityTableEncode.put(ENTITIES[i], ENTITIES[i + 1]);
        }
    }

    public static final String encode(String string) {
        return HTMLEncode.encode(string, "\n");
    }

    public static final String encode(String string, String string2) {
        if (entityTableEncode == null) {
            HTMLEncode.buildEntityTables();
        }
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '?' && c <= 'Z' || c >= 'a' && c <= 'z' || c == ' ') {
                stringBuffer.append(c);
                continue;
            }
            if (c == '\n') {
                stringBuffer.append(string2);
                continue;
            }
            String string3 = HTMLEncode.encodeSingleChar(String.valueOf(c));
            if (string3 != null) {
                stringBuffer.append(string3);
                continue;
            }
            stringBuffer.append("&#");
            stringBuffer.append(new Integer(c).toString());
            stringBuffer.append(';');
        }
        return stringBuffer.toString();
    }

    private static String encodeSingleChar(String string) {
        return entityTableEncode.get(string);
    }

    protected static String encodeHREFParam(String string) {
        try {
            return URLEncoder.encode(string, "UTF8");
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Error invoking 1.4 URLEncoder.encode with reflection: " + throwable.getMessage());
        }
    }

    public static String encodeQuery(String string, String[] stringArray) {
        return HTMLEncode.encodeHREFQuery(string, stringArray, false);
    }

    public static String encodeHREFQuery(String string, String[] stringArray) {
        return HTMLEncode.encodeHREFQuery(string, stringArray, true);
    }

    public static String encodeHREFQuery(String string, String[] stringArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(string);
        if (stringArray != null && stringArray.length > 0) {
            stringBuffer.append("?");
            for (int i = 0; i < (stringArray.length + 1) / 2; ++i) {
                int n = i * 2;
                if (n != 0) {
                    if (bl) {
                        stringBuffer.append("&amp;");
                    } else {
                        stringBuffer.append("&");
                    }
                }
                stringBuffer.append(HTMLEncode.encodeHREFParam(stringArray[n]));
                if (n + 1 >= stringArray.length) continue;
                stringBuffer.append("=");
                stringBuffer.append(HTMLEncode.encodeHREFParam(stringArray[n + 1]));
            }
        }
        return stringBuffer.toString();
    }

    public static String encodeHREFQuery(String string, Map<String, String> map, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(string);
        if (map != null && map.size() > 0) {
            stringBuffer.append("?");
            int n = 0;
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                if (n != 0) {
                    if (bl) {
                        stringBuffer.append("&amp;");
                    } else {
                        stringBuffer.append("&");
                    }
                }
                String string2 = iterator.next();
                stringBuffer.append(HTMLEncode.encodeHREFParam(string2));
                stringBuffer.append("=");
                stringBuffer.append(HTMLEncode.encodeHREFParam(map.get(string2)));
                ++n;
            }
        }
        return stringBuffer.toString();
    }
}

