/*
 * Decompiled with CFR 0.152.
 */
package de.vxart.zipupdate;

import de.vxart.io.ThrottledInputStream;
import de.vxart.io.ZipEntryInputStream;
import de.vxart.net.MultipartMessage;
import de.vxart.zipupdate.ProgressListener;
import de.vxart.zipupdate.ProgressListenerManager;
import de.vxart.zipupdate.Resource;
import de.vxart.zipupdate.UpdateEngine;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.InflaterInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateLocation {
    protected Logger logger = UpdateEngine.logger;
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String BOUNDARY_DELIM = "boundary=";
    private static long DOWNLOAD_SPEED;
    private URL url;
    private Set<Resource> resources;
    private ProgressListenerManager listeners;
    private Map<Map<Resource, String>, CacheEntry> cache;
    private final Map<String, Range> namedRanges;
    final Map<String, String> rangedNames;
    private String authorizationString;

    public UpdateLocation(URL uRL) {
        this(uRL, null);
    }

    public UpdateLocation(URL uRL, String string) {
        this.url = uRL;
        this.authorizationString = string;
        try {
            String string2 = System.getProperty("de.vxart.zipupdate.UpdateLocation.downloadSpeed");
            DOWNLOAD_SPEED = Long.parseLong(string2);
            if (DOWNLOAD_SPEED < 0L) {
                throw new IllegalAccessException("Illegal value: " + string2);
            }
            this.logger.log(Level.CONFIG, "Enabling throttling: " + DOWNLOAD_SPEED + " KB/s max");
        }
        catch (Exception exception) {
            this.logger.log(Level.CONFIG, "Disabling throttling: " + exception.getMessage());
            DOWNLOAD_SPEED = -1L;
        }
        this.listeners = new ProgressListenerManager();
        this.cache = new HashMap<Map<Resource, String>, CacheEntry>();
        this.namedRanges = new HashMap<String, Range>();
        this.rangedNames = new HashMap<String, String>();
        this.resources = new LinkedHashSet<Resource>();
    }

    public URL getUrl() {
        return this.url;
    }

    public Set<Resource> getResources() throws IOException {
        long l;
        String string;
        this.resources.clear();
        this.namedRanges.clear();
        this.rangedNames.clear();
        CRC32 cRC32 = new CRC32();
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(this.url.toString() + ".idx").openConnection();
        if (this.authorizationString != null) {
            httpURLConnection.setRequestProperty("Authorization", "Basic " + this.authorizationString);
        }
        httpURLConnection.connect();
        DataInputStream dataInputStream = new DataInputStream(new CheckedInputStream(new InflaterInputStream(new BufferedInputStream(httpURLConnection.getInputStream())), cRC32));
        long l2 = -1L;
        while (!"".equals(string = dataInputStream.readUTF())) {
            Resource resource = new Resource(string);
            resource.setCrc(dataInputStream.readLong());
            this.resources.add(resource);
            long l3 = dataInputStream.readLong();
            Range range = new Range(l2, l3);
            this.rangedNames.put(range.toString(), string);
            this.namedRanges.put(string, range);
            l2 = l3;
        }
        long l4 = cRC32.getValue();
        if (l4 != (l = dataInputStream.readLong())) {
            throw new IOException("Index file corrupted or out-of-date: " + this.url);
        }
        return this.resources;
    }

    public void fetchData(Map<Resource, String> map) throws IOException {
        int n = 0;
        TreeSet<Range> treeSet = new TreeSet<Range>();
        for (Resource resource : map.keySet()) {
            String string = map.get(resource);
            if (string != "+++" && string != "!!!") continue;
            Range range = this.namedRanges.get(resource.getName());
            treeSet.add(range);
            n = (int)((long)n + (range.end - range.start));
        }
        if (treeSet.size() == 0) {
            return;
        }
        int n2 = 5000;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        StringBuilder stringBuilder = null;
        this.listeners.init("Downloading new resources...", 0, n);
        CacheEntry cacheEntry = new CacheEntry();
        cacheEntry.files = new ArrayList();
        cacheEntry.headersList = new ArrayList();
        cacheEntry.singleRange = new ArrayList();
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            int n6;
            Range range = (Range)iterator.next();
            if (n3 == 0) {
                stringBuilder = new StringBuilder(n2 + 50);
                stringBuilder.append("bytes=");
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(range.start + 1L);
            stringBuilder.append('-');
            stringBuilder.append(range.end);
            ++n3;
            if (stringBuilder.length() <= n2 && iterator.hasNext()) continue;
            this.logger.info("Byte Ranges Size: " + stringBuilder.length());
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.url.openConnection();
            httpURLConnection.setRequestProperty("Range", stringBuilder.toString());
            if (this.authorizationString != null) {
                httpURLConnection.setRequestProperty("Authorization", "Basic " + this.authorizationString);
            }
            httpURLConnection.connect();
            this.logger.info("Headers: " + httpURLConnection.getHeaderFields());
            InputStream inputStream = httpURLConnection.getInputStream();
            if (DOWNLOAD_SPEED > 0L) {
                inputStream = new ThrottledInputStream(inputStream, DOWNLOAD_SPEED);
            }
            inputStream = new BufferedInputStream(inputStream);
            File file = File.createTempFile("banana" + n4, null);
            file.delete();
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.logger.log(Level.FINE, "Downloading data into cache: source=" + this.url + " cache=" + file.getAbsolutePath());
            byte[] byArray = new byte[4096];
            while ((n6 = inputStream.read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n6);
                this.listeners.update(n5 += n6);
            }
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            cacheEntry.files.add(file);
            cacheEntry.headersList.add(httpURLConnection.getHeaderFields());
            cacheEntry.singleRange.add(n3 == 1);
            this.logger.log(Level.FINE, "Downloaded data successfully: source=" + this.url + " cache=" + file.getAbsolutePath());
            ++n4;
            n3 = 0;
        }
        this.cache.put(map, cacheEntry);
    }

    public Iterator<Resource> getData(Map<Resource, String> map) throws IOException {
        CacheEntry cacheEntry = this.cache.get(map);
        if (cacheEntry == null) {
            return null;
        }
        final ArrayList<MultipartMessage> arrayList = new ArrayList<MultipartMessage>();
        for (int i = 0; i < cacheEntry.files.size(); ++i) {
            Iterable<MultipartMessage.Part> iterable;
            Object object;
            Object object2;
            File file = cacheEntry.files.get(i);
            Map<String, List<String>> map2 = cacheEntry.headersList.get(i);
            Boolean bl = cacheEntry.singleRange.get(i);
            FileInputStream fileInputStream = new FileInputStream(file);
            if (bl.booleanValue()) {
                object2 = null;
                try {
                    object2 = new ZipEntryInputStream(new DataInputStream(fileInputStream));
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                object = new Resource(map.keySet().iterator().next().getName());
                ((Resource)object).setData((InputStream)object2);
                iterable = new LinkedList();
                iterable.add(object);
                return iterable.iterator();
            }
            object2 = map2.get(CONTENT_TYPE).get(0);
            object = UpdateLocation.getBoundary((String)object2);
            iterable = new MultipartMessage(fileInputStream, (String)object);
            arrayList.add((MultipartMessage)iterable);
        }
        return new Iterator<Resource>(){
            private int cur = 0;

            @Override
            public boolean hasNext() {
                boolean bl = ((MultipartMessage)arrayList.get(this.cur)).hasNext();
                if (!bl && this.cur + 1 < arrayList.size()) {
                    ++this.cur;
                    bl = this.hasNext();
                }
                return bl;
            }

            @Override
            public Resource next() {
                MultipartMessage.Part part = ((MultipartMessage)arrayList.get(this.cur)).next();
                String string = part.getHeaders().get("Content-Range".toLowerCase());
                String string2 = string.substring(string.indexOf(32) + 1, string.indexOf(47));
                String string3 = UpdateLocation.this.rangedNames.get(string2);
                ZipEntryInputStream zipEntryInputStream = null;
                try {
                    zipEntryInputStream = new ZipEntryInputStream(new DataInputStream(part.openStream()));
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                Resource resource = new Resource(string3);
                resource.setData(zipEntryInputStream);
                return resource;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return this.getClass().getName() + ":Iterator[multipart]";
            }
        };
    }

    private static String getBoundary(String string) {
        int n = string.indexOf(BOUNDARY_DELIM);
        if (n < 0) {
            throw new NullPointerException("No boundary was found.");
        }
        String string2 = null;
        int n2 = string.indexOf(";", n);
        string2 = n2 > 0 ? string.substring(n + BOUNDARY_DELIM.length(), n2) : string.substring(n + BOUNDARY_DELIM.length());
        return string2;
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.listeners.add(progressListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.listeners.remove(progressListener);
    }

    public String toString() {
        String string = DOWNLOAD_SPEED > 0L ? String.valueOf(DOWNLOAD_SPEED) + " KB/s" : "no throttling";
        return this.getClass().getName() + "[" + this.url + ";" + string + "]";
    }

    protected class Range
    implements Comparable {
        long start;
        long end;

        Range(long l, long l2) {
            this.start = l;
            this.end = l2;
        }

        public String toString() {
            return this.start + 1L + "-" + this.end;
        }

        public int compareTo(Object object) {
            if (object instanceof Range) {
                Range range = (Range)object;
                return (int)this.start - (int)range.start;
            }
            throw new ClassCastException("Different class: " + object.getClass());
        }
    }

    protected class CacheEntry {
        ArrayList<Boolean> singleRange;
        ArrayList<File> files;
        ArrayList<Map<String, List<String>>> headersList;

        protected CacheEntry() {
        }
    }
}

