/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.launcher;

import com.turborilla.mule.launcher.DynamicUpdater;
import com.turborilla.mule.launcher.NativeFileSelector;
import com.turborilla.mule.launcher.SplashScreen;
import com.turborilla.mule.launcher.UpdaterFrame;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Launcher {
    private static Logger logger = Logger.getLogger(Launcher.class.getCanonicalName());
    private static final boolean skipUpdate = false;
    private static SplashScreen splashScreen = null;
    private static UpdaterFrame updaterFrame = null;
    private static Preferences settings;

    public Launcher() {
        settings = Preferences.userRoot().node("Planet Mule Updater");
    }

    public static void launch(String[] stringArray) {
        String string = "";
        try {
            String[] stringArray2;
            String[] stringArray3 = stringArray2 = stringArray[0].split(";");
            int n = stringArray3.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                stringArray[0] = string2 = stringArray3[i];
                ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                try {
                    processBuilder.start();
                    return;
                }
                catch (Exception exception) {
                    logger.info(exception.toString());
                    string = string + exception.toString();
                    continue;
                }
            }
        }
        catch (Throwable throwable) {
            Launcher.logThrowable(throwable);
            string = string + throwable.toString();
        }
        Launcher.showDialog(null, "Planet M.U.L.E.", "Failed to start game.\n" + string + "\nWorking directory: " + System.getProperty("user.dir"));
    }

    private static DynamicUpdater initUpdater() {
        DynamicUpdater dynamicUpdater = new DynamicUpdater("www.planetmule.com", "/updater");
        return dynamicUpdater;
    }

    public static void main(String[] stringArray) {
        try {
            Launcher.initLogging();
            Launcher.run(stringArray);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Launcher.launch(stringArray);
        System.exit(0);
    }

    public static void run(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("Arguments: ");
        for (String object2 : stringArray) {
            stringBuffer.append(object2);
            stringBuffer.append(" ");
        }
        logger.info(stringBuffer.toString());
        logger.info("Classpath: " + System.getProperties().get("java.class.path"));
        logger.info("Java VM: " + System.getProperties().get("java.vm.version"));
        logger.info("Java Runtime: " + System.getProperties().get("java.runtime.version"));
        logger.info("OS: " + System.getProperties().get("os.name") + " " + System.getProperties().get("os.version") + " " + System.getProperties().get("os.arch"));
        logger.info("Sun Arch: " + System.getProperties().get("sun.arch.data.model"));
        String string = System.getProperty("os.name").toLowerCase();
        int n = string.startsWith("mac os x") ? 1 : 0;
        if (n != 0) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Planet M.U.L.E.");
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            logger.warning("Couldn't set native look and feel. " + throwable.toString());
        }
        Launcher launcher = new Launcher();
        final DynamicUpdater dynamicUpdater = Launcher.initUpdater();
        if (dynamicUpdater.isNewBuildNumber()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        Launcher.updaterFrame = new UpdaterFrame(dynamicUpdater.getCurrentBuildNumber(), dynamicUpdater.getNewBuildNumber());
                    }
                });
            }
            catch (Throwable throwable) {
                Launcher.logThrowable(throwable);
                Launcher.showDialog(null, "Planet M.U.L.E.", "Failed to create updater window.\nPlease download and install a new copy of the game.");
                System.exit(0);
            }
            final UpdaterFrame updaterFrame = Launcher.updaterFrame;
            if (!updaterFrame.isVisible()) {
                logger.info("User doesn't want to update");
            } else {
                try {
                    Runnable runnable = new Runnable(){

                        public void run() {
                            try {
                                dynamicUpdater.update(updaterFrame);
                            }
                            catch (Throwable throwable) {
                                logger.log(Level.SEVERE, "Update failed due to " + throwable.toString(), throwable);
                                Launcher.showDialog(updaterFrame, "Planet M.U.L.E.", "Update failed, please download and install a newer copy of the game.\n" + throwable.toString());
                                Launcher.killFrame();
                                System.exit(-1);
                            }
                        }
                    };
                    Thread thread = new Thread(runnable);
                    thread.start();
                    thread.join();
                }
                catch (Exception exception) {
                    Launcher.logThrowable(exception);
                    Launcher.showDialog(updaterFrame, "Planet M.U.L.E.", "Update failed, please download and install a newer copy of the game.");
                    Launcher.killFrame();
                    System.exit(-1);
                }
            }
        }
        NativeFileSelector nativeFileSelector = new NativeFileSelector();
        nativeFileSelector.run();
        logger.info("Launching game");
        Launcher.killFrame();
    }

    private static void killFrame() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    if (updaterFrame != null) {
                        updaterFrame.setVisible(false);
                        updaterFrame.dispose();
                    }
                    if (splashScreen != null) {
                        splashScreen.setVisible(false);
                        splashScreen.dispose();
                    }
                }
            });
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.toString(), exception);
        }
    }

    private static void initLogging() {
        try {
            for (Handler handler : Logger.getLogger("").getHandlers()) {
                Logger.getLogger("").removeHandler(handler);
            }
            File file = new File("updater_log.txt");
            FileHandler fileHandler = new FileHandler(file.getAbsolutePath());
            fileHandler.setFormatter(new SimpleFormatter());
            fileHandler.setLevel(Level.FINEST);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.FINEST);
            Logger.getLogger("").addHandler(fileHandler);
            Logger.getLogger("").addHandler(consoleHandler);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void showDialog(final JFrame jFrame, final String string, final String string2) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(jFrame, string2, string, 0);
                }
            });
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, throwable.toString(), throwable);
        }
    }

    private static String convertToHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] >>> 4 & 0xF;
            int n2 = 0;
            do {
                if (0 <= n && n <= 9) {
                    stringBuffer.append((char)(48 + n));
                } else {
                    stringBuffer.append((char)(97 + (n - 10)));
                }
                n = byArray[i] & 0xF;
            } while (n2++ < 1);
        }
        return stringBuffer.toString();
    }

    public static String SHA1(String string) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] byArray = new byte[40];
        messageDigest.update(string.getBytes("iso-8859-1"), 0, string.length());
        byArray = messageDigest.digest();
        return Launcher.convertToHex(byArray);
    }

    private static String logThrowable(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            InvocationTargetException invocationTargetException = (InvocationTargetException)throwable;
            Throwable throwable2 = invocationTargetException.getTargetException();
            logger.log(Level.SEVERE, throwable2.toString(), throwable2);
            logger.log(Level.SEVERE, invocationTargetException.toString(), invocationTargetException);
            return throwable2.getMessage();
        }
        logger.log(Level.SEVERE, throwable.toString(), throwable);
        return throwable.getMessage();
    }
}

