/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.painter.utils.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceTextUtilities;

public class SubstanceLabelUI
extends BasicLabelUI {
    private SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate();
    protected PropertyChangeListener substancePropertyChangeListener;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceLabelUI();
    }

    @Override
    protected void installListeners(final JLabel c) {
        super.installListeners(c);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("opaque".equals(evt.getPropertyName()) && !Boolean.TRUE.equals(c.getClientProperty("substancelaf.lockopacity"))) {
                    c.putClientProperty("substancelaf.buttonopacityoriginal", evt.getNewValue());
                }
            }
        };
        c.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    @Override
    protected void uninstallListeners(JLabel c) {
        c.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon = null;
        if (label.isEnabled()) {
            icon = label.getIcon();
            if (icon != null && SubstanceCoreUtilities.useThemedDefaultIcon()) {
                icon = SubstanceCoreUtilities.getThemedIcon(label, icon);
            }
        } else {
            icon = label.getDisabledIcon();
        }
        if (icon == null && text == null) {
            return;
        }
        Rectangle paintIconR = new Rectangle();
        Rectangle paintTextR = new Rectangle();
        Rectangle paintViewR = new Rectangle();
        Insets paintViewInsets = new Insets(0, 0, 0, 0);
        Insets insets = label.getInsets(paintViewInsets);
        paintViewR.x = insets.left;
        paintViewR.y = insets.top;
        paintViewR.width = c.getWidth() - (insets.left + insets.right);
        paintViewR.height = c.getHeight() - (insets.top + insets.bottom);
        paintIconR.height = 0;
        paintIconR.width = 0;
        paintIconR.y = 0;
        paintIconR.x = 0;
        paintTextR.height = 0;
        paintTextR.width = 0;
        paintTextR.y = 0;
        paintTextR.x = 0;
        String clippedText = SwingUtilities.layoutCompoundLabel(label, g.getFontMetrics(), text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), paintViewR, paintIconR, paintTextR, label.getIconTextGap());
        Graphics2D g2d = (Graphics2D)g.create();
        this.bgDelegate.updateIfOpaque(g2d, c);
        if (icon != null) {
            icon.paintIcon(c, g2d, paintIconR.x, paintIconR.y);
        }
        ComponentState labelState = label.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
        float labelAlpha = SubstanceColorSchemeUtilities.getAlpha(label, labelState);
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g2d, paintTextR);
            } else {
                SubstanceTextUtilities.paintText(g, (JComponent)label, paintTextR, clippedText, label.getDisplayedMnemonicIndex(), labelState, labelState, labelAlpha);
            }
        }
        g2d.dispose();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        this.paint(g, c);
    }
}

