/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.MuleException;
import com.turborilla.mule.Properties;
import com.turborilla.mule.model.Avatar;
import com.turborilla.mule.model.Collidable;
import com.turborilla.mule.model.CollisionDetector;
import com.turborilla.mule.model.ColonyEvent;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.GameModelObserver;
import com.turborilla.mule.model.Geometry;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Wampus;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.view.ActorPainter;
import com.turborilla.mule.view.AnimatedSprite;
import com.turborilla.mule.view.ArrowPainter;
import com.turborilla.mule.view.AuctionNumberPainter;
import com.turborilla.mule.view.AuctionPainter;
import com.turborilla.mule.view.AvatarImageStore;
import com.turborilla.mule.view.Blinker;
import com.turborilla.mule.view.CollectionPainter;
import com.turborilla.mule.view.ColonyEventPainter;
import com.turborilla.mule.view.EffectPainter;
import com.turborilla.mule.view.HUDPainter;
import com.turborilla.mule.view.HirelingPainter;
import com.turborilla.mule.view.IntroPainter;
import com.turborilla.mule.view.LandGrantPainter;
import com.turborilla.mule.view.LandPingEffect;
import com.turborilla.mule.view.LobbyPainter3;
import com.turborilla.mule.view.MapBorderPainter;
import com.turborilla.mule.view.MapPainter;
import com.turborilla.mule.view.MapSkin;
import com.turborilla.mule.view.MenuPainter;
import com.turborilla.mule.view.MessagePainter;
import com.turborilla.mule.view.MuleImage;
import com.turborilla.mule.view.MuleSpriteSheetFont;
import com.turborilla.mule.view.PathFindingPainter;
import com.turborilla.mule.view.ReconnectPainter;
import com.turborilla.mule.view.ShopPainter;
import com.turborilla.mule.view.SpriteLoader;
import com.turborilla.mule.view.SummaryPainter3;
import com.turborilla.mule.view.Transition;
import com.turborilla.mule.view.Transitionable;
import com.turborilla.mule.view.ViewProperties;
import java.util.Random;
import java.util.logging.Logger;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.AngelCodeFont;
import org.newdawn.slick.Color;
import org.newdawn.slick.Font;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;

public final class View
implements GameModelObserver {
    private Logger logger = Logger.getLogger("mule");
    private Graphics graphics;
    private AvatarImageStore avatarImageStore;
    private Blinker globalBlinker;
    private LobbyPainter3 lobbyPainter;
    private IntroPainter introPainter;
    private MapPainter mapPainter;
    private MapBorderPainter mapBorderPainter;
    private ActorPainter actorPainter;
    private MessagePainter messagePainter;
    private LandGrantPainter landGrantPainter;
    private HUDPainter hudPainter;
    private ShopPainter shopPainter;
    private AuctionPainter auctionPainter2;
    private CollectionPainter collectionPainter;
    private ColonyEventPainter colonyEventPainter;
    private SummaryPainter3 summaryPainter;
    private MenuPainter menuPainter;
    private HirelingPainter hirelingPainter;
    private EffectPainter effectPainter;
    private ReconnectPainter reconnectPainter;
    private PathFindingPainter pathFindingPainter;
    private ArrowPainter arrowPainter;
    private Random random;
    private boolean hudEnabled = true;
    private static Color focusBackgroundColor = new Color(0.0f, 0.0f, 0.0f, 0.75f);
    private AnimatedSprite wumpus;
    private boolean titleEnabled = true;

    public View(Graphics graphics, boolean bl) throws MuleException, SlickException {
        this.logger.info("Creating view...");
        this.graphics = graphics;
        MuleImage muleImage = new MuleImage("images/auction3/auction_text.png", Color.magenta);
        MuleImage muleImage2 = new MuleImage("images/font-big.png", Color.magenta);
        MuleImage muleImage3 = new MuleImage("fonts/hud.png");
        MuleImage muleImage4 = new MuleImage("fonts/arial_14px_bold_00.png");
        MuleSpriteSheetFont muleSpriteSheetFont = new MuleSpriteSheetFont(new SpriteSheet(muleImage, 10, 18), ' ');
        MuleSpriteSheetFont muleSpriteSheetFont2 = new MuleSpriteSheetFont(new SpriteSheet(muleImage2, 16, 32), ' ');
        AngelCodeFont angelCodeFont = new AngelCodeFont("fonts/hud.fnt", muleImage3);
        AngelCodeFont angelCodeFont2 = new AngelCodeFont("fonts/arial_14px_bold_adjusted.fnt", muleImage4);
        muleSpriteSheetFont2.setCharWidth(15);
        muleSpriteSheetFont.setCharWidth(9);
        Color color = new Color(161, 26, 0);
        Color color2 = new Color(244, 174, 4);
        TextStyle.DEBUG.font = graphics.getFont();
        TextStyle.DEBUG.color = new Color(Color.white);
        TextStyle.TERMINAL.font = angelCodeFont2;
        TextStyle.TERMINAL.color = new Color(color);
        TextStyle.FLOATING_BUY.font = angelCodeFont2;
        TextStyle.FLOATING_BUY.color = new Color(Color.red);
        TextStyle.FLOATING_SELL.font = angelCodeFont2;
        TextStyle.FLOATING_SELL.color = new Color(Color.yellow);
        TextStyle.DISPLAY.font = angelCodeFont2;
        TextStyle.DISPLAY.color = new Color(color2);
        TextStyle.HUD.font = angelCodeFont2;
        TextStyle.HUD.color = new Color(color2);
        TextStyle.HUD_SMALL.font = angelCodeFont;
        TextStyle.HUD_SMALL.color = new Color(ViewProperties.get().hudTextColor);
        TextStyle.BIG.font = muleSpriteSheetFont2;
        TextStyle.BIG.color = new Color(Color.white);
        SpriteLoader.initialize();
        LandPingEffect.initialize();
        this.avatarImageStore = new AvatarImageStore();
        this.globalBlinker = new Blinker(Properties.mule.globalBlinksPerSecond);
        this.random = new Random();
        AuctionNumberPainter auctionNumberPainter = new AuctionNumberPainter();
        this.hudPainter = new HUDPainter(this.graphics, this.globalBlinker);
        this.lobbyPainter = new LobbyPainter3();
        this.introPainter = new IntroPainter();
        this.mapBorderPainter = new MapBorderPainter(this.graphics);
        this.mapPainter = new MapPainter(this.graphics, this.globalBlinker, this.mapBorderPainter);
        this.actorPainter = new ActorPainter(this.graphics);
        this.messagePainter = new MessagePainter(this.graphics);
        this.landGrantPainter = new LandGrantPainter();
        this.shopPainter = new ShopPainter(this.graphics, this.messagePainter);
        this.auctionPainter2 = new AuctionPainter(this.graphics, this.actorPainter, auctionNumberPainter);
        this.collectionPainter = new CollectionPainter(this.graphics);
        this.colonyEventPainter = new ColonyEventPainter(this.mapPainter, this.introPainter);
        this.summaryPainter = new SummaryPainter3(this.graphics, this.actorPainter, auctionNumberPainter);
        this.hirelingPainter = new HirelingPainter(this.graphics);
        this.menuPainter = new MenuPainter(this.graphics);
        this.effectPainter = new EffectPainter();
        this.reconnectPainter = new ReconnectPainter(this.graphics);
        this.pathFindingPainter = new PathFindingPainter(this.graphics);
        this.arrowPainter = new ArrowPainter();
        this.wumpus = new AnimatedSprite("images/wumpus/wumpus.png", 7, 9, 100);
        this.wumpus.getAnimation().setDuration(0, 600);
        this.wumpus.getAnimation().setDuration(1, 100);
        this.logger.info("Finished creating view");
    }

    public void update() {
        this.globalBlinker.update();
        this.messagePainter.update();
        this.effectPainter.update();
    }

    public Blinker getGlobalBlinker() {
        return this.globalBlinker;
    }

    public LobbyPainter3 getLobbyPainter() {
        return this.lobbyPainter;
    }

    public IntroPainter getIntroPainter() {
        return this.introPainter;
    }

    public LandGrantPainter getLandGrantPainter() {
        return this.landGrantPainter;
    }

    public PathFindingPainter getPathFindingPainter() {
        return this.pathFindingPainter;
    }

    public void print(String string, float f, float f2) {
        this.print(string, TextStyle.DEBUG, f, f2);
    }

    public void print(String string, TextStyle textStyle, float f, float f2) {
        this.print(string, textStyle, textStyle.color, f, f2);
    }

    public void print(String string, TextStyle textStyle, Color color, float f, float f2) {
        textStyle.font.drawString(f, f2, string, color);
    }

    public void printCentered(String string, TextStyle textStyle, float f) {
        float f2 = this.calcCentered(string, textStyle);
        this.print(string, textStyle, textStyle.color, f2, f);
    }

    public void printCentered(String string, TextStyle textStyle, Color color, float f) {
        float f2 = this.calcCentered(string, textStyle);
        this.print(string, textStyle, color, f2, f);
    }

    public int calcCentered(String string, TextStyle textStyle) {
        int n = textStyle.font.getWidth(string);
        return ViewProperties.get().screenWidth / 2 - n / 2;
    }

    public ActorPainter getActorPainter() {
        return this.actorPainter;
    }

    public void setHUDEnabled(boolean bl) {
        this.hudEnabled = bl;
    }

    public boolean isHUDEnabled() {
        return this.hudEnabled;
    }

    public HUDPainter getHUDPainter() {
        return this.hudPainter;
    }

    public ShopPainter getShopPainter() {
        return this.shopPainter;
    }

    public void drawTerminalMessage() {
        this.messagePainter.drawTerminal(this.graphics);
    }

    public void drawInfoMessages() {
        this.messagePainter.drawInfo(this.graphics);
    }

    public void drawFloatingMessages() {
        this.messagePainter.drawFloating(this.graphics);
    }

    public void setTitleEnabled(boolean bl) {
        this.titleEnabled = bl;
    }

    public void drawTitle() {
        if (this.titleEnabled) {
            this.messagePainter.drawSimpleTitle();
        }
    }

    public void drawBigMessage() {
        this.messagePainter.drawBig(this.graphics);
    }

    public void setTitle(String string) {
        MessagePainter messagePainter = this.messagePainter;
        messagePainter.getClass();
        this.messagePainter.setTitle(messagePainter.new MessagePainter.TitleMessage(string));
    }

    public void fadeTitle() {
        this.messagePainter.fadeTitle();
    }

    public void setTerminalMessage(String string, float f) {
        MessagePainter messagePainter = this.messagePainter;
        messagePainter.getClass();
        this.messagePainter.setTerminalMessage(messagePainter.new MessagePainter.TerminalMessage(string, f));
    }

    public void setTerminalMessage(String string) {
        MessagePainter messagePainter = this.messagePainter;
        messagePainter.getClass();
        this.messagePainter.setTerminalMessage(messagePainter.new MessagePainter.TerminalMessage(string));
    }

    public void setTerminalMessage(String string, Player player, float f) {
        string = string.replace("%s", player.getName());
        this.setTerminalMessage(string, player.getColorIndex(), f);
    }

    public void setTerminalMessage(String string, int n, float f) {
        Color color = ViewProperties.get().avatarColors[n][5];
        MessagePainter messagePainter = this.messagePainter;
        messagePainter.getClass();
        this.messagePainter.setTerminalMessage(messagePainter.new MessagePainter.TerminalMessage(string, color, f));
    }

    public void setScrollingTerminalMessage(String string, MessagePainter.ScrollingTerminalMessageListener scrollingTerminalMessageListener) {
        MessagePainter messagePainter = this.messagePainter;
        messagePainter.getClass();
        this.messagePainter.setTerminalMessage(messagePainter.new MessagePainter.ScrollingTerminalMessage(string, scrollingTerminalMessageListener));
    }

    public void setScrollingTerminalMessage(String string, Player player, MessagePainter.ScrollingTerminalMessageListener scrollingTerminalMessageListener) {
        string = string.replace("%s", player.getName());
        Color color = ViewProperties.get().avatarColors[player.getColorIndex()][3];
        MessagePainter messagePainter = this.messagePainter;
        messagePainter.getClass();
        this.messagePainter.setTerminalMessage(messagePainter.new MessagePainter.ScrollingTerminalMessage(string, color, scrollingTerminalMessageListener));
    }

    public void changeTerminalMessage(String string) {
        this.messagePainter.changeTerminalMessage(string);
    }

    public void fadeTerminalMessage() {
        this.messagePainter.removeTerminalMessage();
    }

    public void draw(CollisionDetector.CollisionSet collisionSet, Color color, float f, float f2) {
        Color color2 = this.graphics.getColor();
        this.graphics.setColor(color);
        for (Collidable collidable : collisionSet.getCollidables()) {
            Geometry geometry;
            float f3 = collidable.getPosition().x + f;
            float f4 = collidable.getPosition().y + f2;
            Geometry geometry2 = collidable.getGeometry();
            if (geometry2 instanceof Geometry.Rectangle) {
                geometry = (Geometry.Rectangle)geometry2;
                this.graphics.drawRect(f3 - ((Geometry.Rectangle)geometry).getHalfWidth(), f4 - ((Geometry.Rectangle)geometry).getHalfHeight(), ((Geometry.Rectangle)geometry).getWidth(), ((Geometry.Rectangle)geometry).getHeight());
                continue;
            }
            if (!(geometry2 instanceof Geometry.Circle)) continue;
            geometry = (Geometry.Circle)geometry2;
            float f5 = ((Geometry.Circle)geometry).getRadius();
            this.graphics.drawOval(f3 - f5, f4 - f5, 2.0f * f5, 2.0f * f5);
        }
        this.graphics.setColor(color2);
    }

    public void notifyEvent(GameModelObserver.Event event, Object ... objectArray) {
        switch (event) {
            case LAND_CLAIMED: {
                this.mapPainter.tileClaimed((PlanetTile)objectArray[0], this.effectPainter);
                break;
            }
            case BUYING: {
                Player player = (Player)objectArray[0];
                int n = (Integer)objectArray[1];
                this.createFloatingMoney(player, n);
                break;
            }
            case TOO_EXPENSIVE: {
                Player player = (Player)objectArray[0];
                this.createFloatingText(player, "TOO EXPENSIVE", TextStyle.FLOATING_BUY);
                break;
            }
            case TRADE_ASSAY: {
                Player player = (Player)objectArray[0];
                int n = (Integer)objectArray[1];
                this.createFloatingMoney(player, n);
                break;
            }
            case SELL: {
                Player player = (Player)objectArray[0];
                boolean bl = (Boolean)objectArray[1];
                if (bl) {
                    this.createFloatingText(player, "SELL LAND", TextStyle.FLOATING_SELL);
                    break;
                }
                this.createFloatingText(player, "NOT SELLING", TextStyle.FLOATING_BUY);
                break;
            }
        }
    }

    private void createFloatingMoney(Player player, int n) {
        String string = null;
        TextStyle textStyle = null;
        if (n < 0) {
            string = "-$" + -n;
            textStyle = TextStyle.FLOATING_BUY;
        } else {
            string = "$" + n;
            textStyle = TextStyle.FLOATING_SELL;
        }
        this.createFloatingText(player, string, textStyle);
    }

    private void createFloatingText(Player player, String string, TextStyle textStyle) {
        Avatar avatar = player.getAvatar();
        float f = avatar.getPosition().x;
        float f2 = avatar.getPosition().y;
        if (avatar.isInShop()) {
            ViewProperties.get().getClass();
            f += 100.0f;
            ViewProperties.get().getClass();
            f2 += 16.0f;
        } else {
            f += (float)ViewProperties.get().mapOffsetX;
            f2 += (float)ViewProperties.get().mapOffsetY;
        }
        this.messagePainter.addFloatingMessage(new MessagePainter.FloatingMessage(string, textStyle, f + 15.0f, f2 - 10.0f));
    }

    public void drawTransition(Transition transition, Transitionable transitionable, Transitionable transitionable2) {
        if (transition == null) {
            transitionable2.draw();
        } else {
            transition.draw(transitionable, transitionable2, this.graphics);
        }
    }

    public void drawTimer(float f) {
        float f2 = Properties.mule.maxTimerDuration;
        int n = 299;
        if (!Properties.mule.showTimerDigits) {
            n = 321;
        }
        float f3 = Math.min(f / f2, 1.0f);
        float f4 = (float)n * f3;
        Color color = this.graphics.getColor();
        this.graphics.setColor(ViewProperties.get().hudTextColor);
        this.graphics.fillRect(612.0f, (float)(29 + n) - f4, 16.0f, f4);
        int n2 = (int)Math.ceil(f);
        if (Properties.mule.showTimerDigits && n2 > 0) {
            TextStyle.TERMINAL.printCentered("" + n2, 620, 29 + n + 7);
        }
        this.graphics.setColor(color);
    }

    public void beginColonyEvent(ColonyEvent colonyEvent, GameModel gameModel) {
        this.colonyEventPainter.begin(colonyEvent, gameModel);
    }

    public void updateColonyEvent(ColonyEvent colonyEvent, float f) {
        this.colonyEventPainter.update(colonyEvent, f);
    }

    public boolean isColonyEventAppliable(ColonyEvent colonyEvent) {
        return this.colonyEventPainter.isTimeToApply(colonyEvent);
    }

    public boolean isColonyEventFinished(ColonyEvent colonyEvent) {
        return this.colonyEventPainter.isFinished(colonyEvent);
    }

    public void drawColonyEvent(ColonyEvent colonyEvent, int n) {
        if (colonyEvent == null) {
            return;
        }
        if (colonyEvent.round != n) {
            return;
        }
        this.colonyEventPainter.draw(colonyEvent);
    }

    public void drawWampus(Wampus wampus) {
        if (wampus.isVisible()) {
            this.wumpus.draw((float)ViewProperties.get().mapOffsetX + wampus.getPos().x - (float)(this.wumpus.getWidth() / 2), (float)ViewProperties.get().mapOffsetY + wampus.getPos().y - (float)(this.wumpus.getHeight() / 2));
        }
    }

    public void enterMuleStore() {
        this.shopPainter.enterMuleStore();
    }

    public void close() {
    }

    public ReconnectPainter getReconnectPainter() {
        return this.reconnectPainter;
    }

    public AuctionPainter getAuctionPainter2() {
        return this.auctionPainter2;
    }

    public MapPainter getMapPainter() {
        return this.mapPainter;
    }

    public MenuPainter getMenuPainter() {
        return this.menuPainter;
    }

    public EffectPainter getEffectPainter() {
        return this.effectPainter;
    }

    public SummaryPainter3 getSummaryPainter() {
        return this.summaryPainter;
    }

    public HirelingPainter getHirelingPainter() {
        return this.hirelingPainter;
    }

    public AvatarImageStore getAvatarImageStore() {
        return this.avatarImageStore;
    }

    public void setBigMessage(String string) {
        this.messagePainter.setBigMessage(new MessagePainter.BigMessage(string));
    }

    public void setMapSkin(MapSkin mapSkin) {
        this.mapPainter.setSkin(mapSkin);
        this.landGrantPainter.setSkin(mapSkin);
    }

    public ArrowPainter getArrowPainter() {
        return this.arrowPainter;
    }

    public void beginFrame() {
        GL11.glLoadIdentity();
    }

    public void setScissorBox(int n, int n2, int n3, int n4) {
    }

    public void clearScissorBox() {
    }

    public MessagePainter getMessagePainter() {
        return this.messagePainter;
    }

    public Random getRandom() {
        return this.random;
    }

    public CollectionPainter getCollectionPainter() {
        return this.collectionPainter;
    }

    public void drawFocusLost() {
        TextStyle textStyle = TextStyle.HUD;
        this.graphics.setColor(focusBackgroundColor);
        this.graphics.fillRect(8.0f, 175.0f, 624.0f, 40.0f);
        textStyle.printCentered("CLICK HERE OR PRESS ESCAPE TO FOCUS THE GAME", 320, 187);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextStyle {
        DEBUG,
        TERMINAL,
        DISPLAY,
        HUD,
        HUD_SMALL,
        BIG,
        FLOATING_SELL,
        FLOATING_BUY;

        public Font font;
        public Color color;

        public void print(String string, int n, int n2) {
            this.font.drawString(n, n2, string, this.color);
        }

        public void print(String string, Color color, int n, int n2) {
            this.font.drawString(n, n2, string, color);
        }

        public void printCentered(String string, int n, int n2) {
            this.printCentered(string, this.color, n, n2);
        }

        public void printCentered(String string, Color color, int n, int n2) {
            this.font.drawString(n -= this.font.getWidth(string) / 2, n2, string, color);
        }

        public void printRight(String string, int n, int n2) {
            this.printRight(string, this.color, n, n2);
        }

        public void printRight(String string, Color color, int n, int n2) {
            this.font.drawString(n -= this.font.getWidth(string), n2, string, color);
        }

        public int getWidth(String string) {
            return this.font.getWidth(string);
        }

        public int getLineHeight() {
            return this.font.getLineHeight();
        }
    }
}

