/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.model.map.TileBorder;
import com.turborilla.mule.view.MapSkin;
import com.turborilla.mule.view.ViewProperties;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;

public class TileBorderPainter {
    private Image[][] edges;
    private Image[][] verticals;
    private Image[][] horizontals;
    private Image[][] angledClosed;
    private Image[][] angledOpen;
    private int[][] edgePositions;
    private int[][] cornerPositions;

    public TileBorderPainter() throws SlickException {
        this.edges = new Image[4][ViewProperties.get().avatarColors.length];
        this.verticals = new Image[4][];
        this.horizontals = new Image[4][];
        this.angledOpen = new Image[4][];
        this.angledClosed = new Image[4][];
    }

    public void setSkin(MapSkin mapSkin) {
        int n;
        int n2;
        int n3 = ViewProperties.get().avatarColors.length;
        Image[][] imageArray = new Image[4][n3];
        Image[][] imageArray2 = new Image[4][n3];
        Image[][] imageArray3 = new Image[4][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.edges[0][n2] = mapSkin.getImage("border-top-bottom0-color" + n2);
            this.edges[1][n2] = mapSkin.getImage("border-left-right1-color" + n2);
            this.edges[2][n2] = mapSkin.getImage("border-top-bottom1-color" + n2);
            this.edges[3][n2] = mapSkin.getImage("border-left-right0-color" + n2);
            for (n = 0; n < 4; ++n) {
                imageArray[n][n2] = mapSkin.getImage("border-corners" + (n + 0) + "-color" + n2);
                imageArray2[n][n2] = mapSkin.getImage("border-corners" + (n + 4) + "-color" + n2);
                imageArray3[n][n2] = mapSkin.getImage("border-corners" + (n + 8) + "-color" + n2);
            }
        }
        this.verticals[0] = imageArray[3];
        this.verticals[1] = imageArray[1];
        this.verticals[2] = imageArray[1];
        this.verticals[3] = imageArray[3];
        this.horizontals[0] = imageArray[0];
        this.horizontals[1] = imageArray[0];
        this.horizontals[2] = imageArray[2];
        this.horizontals[3] = imageArray[2];
        this.angledClosed[0] = imageArray2[0];
        this.angledClosed[1] = imageArray2[1];
        this.angledClosed[2] = imageArray2[2];
        this.angledClosed[3] = imageArray2[3];
        this.angledOpen[0] = imageArray3[2];
        this.angledOpen[1] = imageArray3[3];
        this.angledOpen[2] = imageArray3[0];
        this.angledOpen[3] = imageArray3[1];
        n2 = 64;
        n = 64;
        int n4 = imageArray[0][0].getWidth();
        int n5 = imageArray[0][0].getHeight();
        this.cornerPositions = new int[][]{{0, 0}, {n2 - n4, 0}, {n2 - n4, n - n5}, {0, n - n5}};
        this.edgePositions = new int[][]{{n4, 0}, {n2 - n4, n5}, {n4, n - n5}, {0, n5}};
    }

    public void draw(TileBorder tileBorder, Color color, int n, int n2, int n3) {
        for (int i = 0; i < 4; ++i) {
            if (tileBorder.getEdge(i) == TileBorder.Edge.FILLED) {
                this.edges[i][n].draw((float)(n2 + this.edgePositions[i][0]), (float)(n3 + this.edgePositions[i][1]), color);
            }
            Image[][] imageArray = null;
            switch (tileBorder.getVertex(i)) {
                case VERTICAL: {
                    imageArray = this.verticals;
                    break;
                }
                case HORIZONTAL: {
                    imageArray = this.horizontals;
                    break;
                }
                case ANGLE_CLOSED: {
                    imageArray = this.angledClosed;
                    break;
                }
                case ANGLE_OPEN: {
                    imageArray = this.angledOpen;
                    break;
                }
            }
            if (imageArray == null) continue;
            imageArray[i][n].draw((float)(n2 + this.cornerPositions[i][0]), (float)(n3 + this.cornerPositions[i][1]), color);
        }
    }
}

