/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.Properties;
import com.turborilla.mule.model.Avatar;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.util.Vec2;
import com.turborilla.mule.view.ActorPainter;
import com.turborilla.mule.view.ActorSprite;
import com.turborilla.mule.view.AuctionNumberPainter;
import com.turborilla.mule.view.MuleImage;
import com.turborilla.mule.view.View;
import com.turborilla.mule.view.ViewProperties;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SummaryPainter3 {
    private Logger logger = Logger.getLogger("mule");
    private Graphics graphics;
    private ActorPainter actorPainter;
    private AuctionNumberPainter numberPainter;
    private MuleImage background;
    private MuleImage header;
    private ArrayList<PlayerSprite> players;
    private boolean started;
    private boolean finished;
    private String winText;
    private String toggleMapText;
    private String shortageMessage;
    private ArrayList<SummaryListener> listeners;
    private static final int HEADER_CENTER_X = ViewProperties.get().screenWidth / 2 - 2;
    private static final int HEADER_Y = 11;

    public SummaryPainter3(Graphics graphics, ActorPainter actorPainter, AuctionNumberPainter auctionNumberPainter) throws SlickException {
        this.graphics = graphics;
        this.actorPainter = actorPainter;
        this.numberPainter = auctionNumberPainter;
        this.background = new MuleImage("images/summary/summary.png");
        this.header = new MuleImage("images/summary/summary_header.png");
        this.listeners = new ArrayList();
        this.players = new ArrayList(4);
        this.winText = null;
        this.toggleMapText = null;
    }

    public void addListener(SummaryListener summaryListener) {
        this.listeners.add(summaryListener);
    }

    public void removeListener(SummaryListener summaryListener) {
        this.listeners.remove(summaryListener);
    }

    public void start(ArrayList<Player> arrayList) {
        if (!this.players.isEmpty()) {
            this.logger.severe("Player sprites not empty at start of summary animation.");
            this.players.clear();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            PlayerSprite playerSprite = new PlayerSprite(arrayList.get(i), i);
            this.players.add(playerSprite);
        }
        this.started = true;
        this.finished = false;
    }

    public boolean isSummaryFinished() {
        return this.finished;
    }

    public void setWinner(Player player, String string) {
        for (PlayerSprite playerSprite : this.players) {
            if (playerSprite.player != player) continue;
            playerSprite.setCheering(true);
        }
        this.winText = string;
    }

    public void showToggleMap() {
        this.toggleMapText = "Press Button to Show Colony";
    }

    public void update() {
        if (!this.started) {
            return;
        }
        boolean bl = true;
        for (PlayerSprite object : this.players) {
            object.update();
            if (object.finished) continue;
            bl = false;
        }
        if (!this.finished && bl) {
            this.finished = true;
            for (SummaryListener summaryListener : this.listeners) {
                summaryListener.summaryFinished();
            }
        }
    }

    public void draw(int n, int n2) {
        int n3;
        int n4;
        int n5;
        this.background.draw(8.0f, 8.0f);
        if (n2 == 0) {
            int n6 = this.header.getWidth();
            n5 = HEADER_CENTER_X - n6 / 2;
            n4 = 19;
            this.header.draw(n5, n4);
        } else {
            n5 = this.header.getWidth() + 5 + this.numberPainter.getWidth(n2);
            n4 = HEADER_CENTER_X - n5 / 2;
            n3 = 19;
            this.header.draw(n4, n3);
            this.numberPainter.draw(n2, n4 += this.header.getWidth() + 5, n3 - 5);
        }
        for (PlayerSprite playerSprite : this.players) {
            this.actorPainter.drawActor(playerSprite.getAvatar(), ((PlayerSprite)playerSprite).pos.x, ((PlayerSprite)playerSprite).pos.y, 1.0f);
        }
        if (this.finished) {
            View.TextStyle textStyle = View.TextStyle.TERMINAL;
            for (n4 = 0; n4 < this.players.size(); ++n4) {
                n3 = 208;
                int n7 = 126 + n4 * 41;
                Player player = this.players.get(n4).player;
                Color color = textStyle.color;
                player.getColor();
                int n8 = player.getLandPoints() + player.getGoodsPoints();
                textStyle.printRight("" + player.getMoney(), color, n3 + 0, n7);
                textStyle.printRight("" + player.getOwnedTiles().size(), color, n3 + 105, n7);
                textStyle.printRight("" + n8, color, n3 + 210, n7);
                textStyle.printRight("" + player.getPoints(), color, n3 + 315, n7);
            }
            Color color = textStyle.color;
            textStyle.printRight("" + n, color, 523, 290);
            if (this.winText != null) {
                textStyle.printCentered(this.winText, 320, 48);
            }
            if (this.toggleMapText != null) {
                textStyle.printCentered(this.toggleMapText, 320, 326);
            }
            if (this.shortageMessage != null) {
                textStyle.printCentered(this.shortageMessage, 320, 326);
            }
        }
    }

    public void stop() {
        this.players.clear();
        this.started = false;
        this.finished = false;
    }

    public void setShortageMessage(String string) {
        this.shortageMessage = string;
    }

    public static class SummaryListener {
        public void summaryFinished() {
        }
    }

    private static class PlayerSprite {
        private final Player player;
        private Vec2 pos;
        private float endY;
        private static final Vec2 lineupStart = new Vec2(55.0f, 95.0f);
        private static final float lineupSpacing = 46.0f;
        private static final float speed = 120.0f;
        private boolean finished = false;
        private boolean cheering = false;
        private float jumpSpeed;

        public PlayerSprite(Player player, int n) {
            this.player = player;
            this.pos = new Vec2();
            this.pos.x = 650 + 110 * n;
            this.pos.y = 285.0f;
            this.endY = PlayerSprite.lineupStart.y + (float)n * 46.0f;
            this.getAvatar().setInShop(true);
            this.getAvatar().startWalking();
            this.getAvatar().setDirection(ActorSprite.Direction.West);
        }

        private void update() {
            if (this.pos.x > PlayerSprite.lineupStart.x) {
                this.pos.x -= 120.0f * Properties.mule.delta;
                if (this.pos.x <= PlayerSprite.lineupStart.x) {
                    this.getAvatar().setDirection(ActorSprite.Direction.North);
                    this.pos.x = PlayerSprite.lineupStart.x;
                }
            } else if (this.pos.y > this.endY) {
                this.pos.y -= 120.0f * Properties.mule.delta;
                if (this.pos.y <= this.endY) {
                    this.getAvatar().setDirection(ActorSprite.Direction.South);
                    this.getAvatar().stopWalking();
                    this.pos.y = this.endY;
                    this.finished = true;
                }
            } else if (this.cheering) {
                if (this.jumpSpeed > 400.0f) {
                    this.jumpSpeed = -200.0f;
                }
                this.jumpSpeed += 600.0f * Properties.mule.delta;
                this.pos.y += this.jumpSpeed * Properties.mule.delta;
                if (this.pos.y > this.endY) {
                    this.pos.y = this.endY;
                }
            }
        }

        private void setCheering(boolean bl) {
            this.cheering = bl;
            this.jumpSpeed = 0.0f;
        }

        private Avatar getAvatar() {
            return this.player.getAvatar();
        }
    }
}

