/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.Properties;

public class Strobe {
    private float speed;
    private boolean decrease = true;
    private float value;
    private float min;
    private float max;
    private float stopAt;
    private boolean doStop;
    private boolean stopped;

    public Strobe(float f, float f2, float f3) {
        this.speed = f3;
        this.value = f2;
        this.min = f;
        this.max = f2;
        this.doStop = false;
        this.stopped = false;
        this.decrease = true;
        if (f >= f2) {
            throw new IllegalArgumentException("Strobe min value is over max value in strobe.");
        }
    }

    public void update() {
        if (this.stopped) {
            return;
        }
        float f = this.speed * Properties.mule.delta;
        while (f > 0.0f) {
            boolean bl;
            if (this.decrease) {
                bl = this.doStop && this.value >= this.stopAt;
                this.value -= f;
                if (this.value < this.min) {
                    f = this.min - this.value;
                    this.value = this.min;
                    this.decrease = false;
                } else {
                    f = 0.0f;
                }
                if (!bl || !(this.value <= this.stopAt)) continue;
                this.value = this.stopAt;
                this.stopped = true;
                continue;
            }
            bl = this.doStop && this.value <= this.stopAt;
            this.value += f;
            if (this.value > this.max) {
                f = this.value - this.max;
                this.value = this.max;
                this.decrease = true;
            } else {
                f = 0.0f;
            }
            if (!bl || !(this.value >= this.stopAt)) continue;
            this.value = this.stopAt;
            this.stopped = true;
        }
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float f) {
        this.value = f;
    }

    public void start() {
        this.doStop = false;
        this.stopped = false;
    }

    public void stop() {
        this.stopped = true;
    }

    public void stopAt(float f) {
        this.stopAt = f;
        this.doStop = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public boolean isDecreasing() {
        return this.decrease;
    }
}

