/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.MuleException;
import com.turborilla.mule.model.Race;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.view.PaletteImage;
import com.turborilla.mule.view.ViewProperties;
import java.util.HashMap;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;

class SpriteLoader {
    private static SpriteSheet muleSheetSmall;
    private static SpriteSheet muleSheetBig;
    private static SpriteSheet assayBotSheetSmall;
    private static SpriteSheet assayBotSheetBig;
    private static HashMap<Integer, AvatarSheets> avatarSheetsBig;
    private static HashMap<Integer, AvatarSheets> avatarSheetsSmall;
    private static HashMap<Integer, EquipmentSheets> equipmentSheetsBig;
    private static HashMap<Integer, EquipmentSheets> equipmentSheetsSmall;

    SpriteLoader() {
    }

    /*
     * WARNING - void declaration
     */
    public static void initialize() throws SlickException, MuleException {
        void var4_8;
        Object object;
        muleSheetSmall = new SpriteSheet("images/followers/sprite-mule-small.png", 32, 40, Color.magenta);
        muleSheetBig = new SpriteSheet("images/followers/sprite-mule.png", 64, 80, Color.magenta);
        assayBotSheetSmall = new SpriteSheet("images/followers/assaybot-small.png", 18, 20, Color.magenta);
        assayBotSheetBig = new SpriteSheet("images/followers/assaybot.png", 35, 41, Color.magenta);
        HashMap<String, PaletteImage> hashMap = new HashMap<String, PaletteImage>();
        HashMap<String, PaletteImage> hashMap2 = new HashMap<String, PaletteImage>();
        for (int i = 0; i < Race.races.length; ++i) {
            object = "images/races/" + Race.races[i].getIdentifier() + ".png";
            String object2 = "images/races/" + Race.races[i].getIdentifier() + "-small.png";
            hashMap.put(Race.races[i].getIdentifier(), new PaletteImage((String)object));
            hashMap2.put(Race.races[i].getIdentifier(), new PaletteImage(object2));
        }
        HashMap<Resource, PaletteImage> hashMap3 = new HashMap<Resource, PaletteImage>();
        object = new HashMap();
        for (Resource resource : Resource.values()) {
            hashMap3.put(resource, new PaletteImage("images/followers/sprite-packet-" + resource.ordinal() + ".png"));
            ((HashMap)object).put(resource, new PaletteImage("images/followers/sprite-packet-" + resource.ordinal() + "-small.png"));
        }
        boolean bl = false;
        while (var4_8 < ViewProperties.get().avatarColors.length) {
            avatarSheetsBig.put((int)var4_8, new AvatarSheets(hashMap, (int)var4_8, true));
            avatarSheetsSmall.put((int)var4_8, new AvatarSheets(hashMap2, (int)var4_8, false));
            equipmentSheetsBig.put((int)var4_8, new EquipmentSheets(hashMap3, (int)var4_8, true));
            equipmentSheetsSmall.put((int)var4_8, new EquipmentSheets((HashMap<Resource, PaletteImage>)object, (int)var4_8, false));
            ++var4_8;
        }
    }

    public static SpriteSheet getAvatarSpriteSheet(String string, int n, boolean bl) {
        if (bl) {
            return SpriteLoader.avatarSheetsBig.get((Object)Integer.valueOf((int)n)).raceSheet.get(string);
        }
        return SpriteLoader.avatarSheetsSmall.get((Object)Integer.valueOf((int)n)).raceSheet.get(string);
    }

    public static SpriteSheet getMuleSpriteSheet(String string, int n, boolean bl) {
        if (string.equals("mule")) {
            if (bl) {
                return muleSheetBig;
            }
            return muleSheetSmall;
        }
        if (string.equals("food")) {
            if (bl) {
                return SpriteLoader.equipmentSheetsBig.get((Object)Integer.valueOf((int)n)).food;
            }
            return SpriteLoader.equipmentSheetsSmall.get((Object)Integer.valueOf((int)n)).food;
        }
        if (string.equals("energy")) {
            if (bl) {
                return SpriteLoader.equipmentSheetsBig.get((Object)Integer.valueOf((int)n)).energy;
            }
            return SpriteLoader.equipmentSheetsSmall.get((Object)Integer.valueOf((int)n)).energy;
        }
        if (string.equals("crystite")) {
            if (bl) {
                return SpriteLoader.equipmentSheetsBig.get((Object)Integer.valueOf((int)n)).crystite;
            }
            return SpriteLoader.equipmentSheetsSmall.get((Object)Integer.valueOf((int)n)).crystite;
        }
        if (string.equals("smithore")) {
            if (bl) {
                return SpriteLoader.equipmentSheetsBig.get((Object)Integer.valueOf((int)n)).smithore;
            }
            return SpriteLoader.equipmentSheetsSmall.get((Object)Integer.valueOf((int)n)).smithore;
        }
        return null;
    }

    public static SpriteSheet getAssayBotSpriteSheet(boolean bl) {
        return bl ? assayBotSheetBig : assayBotSheetSmall;
    }

    static {
        avatarSheetsBig = new HashMap();
        avatarSheetsSmall = new HashMap();
        equipmentSheetsBig = new HashMap();
        equipmentSheetsSmall = new HashMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EquipmentSheets {
        public SpriteSheet food;
        public SpriteSheet energy;
        public SpriteSheet crystite;
        public SpriteSheet smithore;

        public EquipmentSheets(HashMap<Resource, PaletteImage> hashMap, int n, boolean bl) throws SlickException, MuleException {
            Color[] colorArray = ViewProperties.get().avatarColors[n];
            if (bl) {
                this.food = new SpriteSheet(hashMap.get((Object)Resource.Food).createImage(colorArray), 64, 80);
                this.energy = new SpriteSheet(hashMap.get((Object)Resource.Energy).createImage(colorArray), 64, 80);
                this.smithore = new SpriteSheet(hashMap.get((Object)Resource.Smithore).createImage(colorArray), 64, 80);
                this.crystite = new SpriteSheet(hashMap.get((Object)Resource.Crystite).createImage(colorArray), 64, 80);
            } else {
                this.food = new SpriteSheet(hashMap.get((Object)Resource.Food).createImage(colorArray), 32, 40);
                this.energy = new SpriteSheet(hashMap.get((Object)Resource.Energy).createImage(colorArray), 32, 40);
                this.smithore = new SpriteSheet(hashMap.get((Object)Resource.Smithore).createImage(colorArray), 32, 40);
                this.crystite = new SpriteSheet(hashMap.get((Object)Resource.Crystite).createImage(colorArray), 32, 40);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AvatarSheets {
        public HashMap<String, SpriteSheet> raceSheet = new HashMap();

        public AvatarSheets(HashMap<String, PaletteImage> hashMap, int n, boolean bl) throws SlickException, MuleException {
            for (int i = 0; i < Race.races.length; ++i) {
                Color[] colorArray = ViewProperties.get().avatarColors[n];
                int n2 = bl ? 32 : 16;
                int n3 = bl ? 48 : 24;
                String string = Race.races[i].getIdentifier();
                Image image = hashMap.get(string).createImage(colorArray);
                SpriteSheet spriteSheet = new SpriteSheet(image, n2, n3);
                this.raceSheet.put(Race.races[i].getIdentifier(), spriteSheet);
            }
        }
    }
}

