/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.ai.PathFinder;
import com.turborilla.mule.ai.PathFindingGraph;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.view.ViewProperties;
import java.util.ArrayList;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;

public class PathFindingPainter {
    Graphics graphics;

    public PathFindingPainter(Graphics graphics) {
        this.graphics = graphics;
    }

    public void draw(PlanetMap planetMap, PathFindingGraph pathFindingGraph, boolean bl) {
        float f = ViewProperties.get().mapOffsetX;
        float f2 = ViewProperties.get().mapOffsetY;
        if (bl) {
            ViewProperties.get().getClass();
            f = 100.0f;
            ViewProperties.get().getClass();
            f2 = 16.0f;
        }
        ArrayList<PathFindingGraph.Node> arrayList = bl ? pathFindingGraph.getShopNodes() : pathFindingGraph.getLandNodes();
        this.graphics.setColor(Color.orange);
        for (PathFindingGraph.Node node : arrayList) {
            for (PathFindingGraph.Edge edge : node.getEdges()) {
                float f3 = f + node.getPos().x;
                float f4 = f2 + node.getPos().y;
                float f5 = f + edge.getNeighbor().getPos().x;
                float f6 = f2 + edge.getNeighbor().getPos().y;
                if (edge.getNeighbor().isInShop() != bl) {
                    if (bl) {
                        f5 = f3 + f5 - f - planetMap.getShopCenter().x;
                        f6 = f4 + f6 - f - planetMap.getShopCenter().y;
                    } else {
                        f5 = f + planetMap.getShopCenter().x;
                        f6 = f2 + planetMap.getShopCenter().y;
                    }
                }
                this.graphics.drawLine(f3, f4, f5, f6);
            }
        }
        this.graphics.setColor(Color.red);
        for (PathFindingGraph.Node node : arrayList) {
            float f7 = (float)Math.floor(f + node.getPos().x - 1.0f);
            float f8 = (float)Math.floor(f2 + node.getPos().y - 1.0f);
            this.graphics.fillOval(f7, f8, 3.0f, 3.0f);
        }
    }

    public void draw(PathFinder.Path path, boolean bl) {
        float f = ViewProperties.get().mapOffsetX;
        float f2 = ViewProperties.get().mapOffsetY;
        if (bl) {
            ViewProperties.get().getClass();
            f = 100.0f;
            ViewProperties.get().getClass();
            f2 = 16.0f;
        }
        this.graphics.setColor(Color.green);
        this.graphics.setLineWidth(3.0f);
        for (int i = 0; i < path.size() - 1; ++i) {
            PathFinder.PathNode pathNode = (PathFinder.PathNode)path.get(i);
            PathFinder.PathNode pathNode2 = (PathFinder.PathNode)path.get(i + 1);
            if (pathNode.inShop != bl || pathNode2.inShop != bl) continue;
            float f3 = f + pathNode.pos.x;
            float f4 = f2 + pathNode.pos.y;
            float f5 = f + pathNode2.pos.x;
            float f6 = f2 + pathNode2.pos.y;
            this.graphics.drawLine(f3, f4, f5, f6);
        }
        this.graphics.setLineWidth(1.0f);
    }
}

