/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.MuleException;
import com.turborilla.mule.Properties;
import com.turborilla.mule.Settings;
import com.turborilla.mule.frame.MetaFrame;
import com.turborilla.mule.model.GameInfo;
import com.turborilla.mule.model.UserInfo;
import com.turborilla.mule.network.MasterClient;
import com.turborilla.mule.sound.SoundPlayer;
import com.turborilla.mule.view.GameInput;
import com.turborilla.mule.view.MuleGame;
import com.turborilla.mule.view.ViewProperties;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Music;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.opengl.InternalTextureLoader;
import org.newdawn.slick.opengl.renderer.Renderer;
import org.newdawn.slick.util.Log;

public class MuleGameContainer {
    private static Logger logger = Logger.getLogger("mule");
    private MuleGame muleGame;
    private MetaFrame metaFrame;
    private GameInfo gameInfo;
    private UserInfo userInfo;
    private boolean stopped;
    private boolean soundOn;
    private boolean running;
    private String closeString;
    private DisplayMode originalDisplayMode;
    private DisplayMode windowedDisplayMode;
    private ArrayList<Runnable> eventQueue;
    private boolean macSetWindowedMode;
    private Graphics graphics;
    private int skippedFrames;

    public MuleGameContainer(String string, MetaFrame metaFrame) throws MuleException, SlickException {
        logger.info("LWJGL Version: " + Sys.getVersion());
        logger.info("Desktop Display Mode: " + Display.getDesktopDisplayMode());
        logger.info("Current Display Mode: " + Display.getDisplayMode());
        logger.info("Display Adapter: " + Display.getAdapter());
        logger.info("Display Driver: " + Display.getVersion());
        this.muleGame = new MuleGame(string);
        this.metaFrame = metaFrame;
        this.eventQueue = new ArrayList();
        this.originalDisplayMode = Display.getDesktopDisplayMode();
        this.windowedDisplayMode = new DisplayMode(ViewProperties.get().screenWidth, ViewProperties.get().screenHeight);
        try {
            MuleGameContainer.setParent(metaFrame);
            Display.setDisplayModeAndFullscreen(this.windowedDisplayMode);
        }
        catch (Throwable throwable) {
            throw new MuleException(throwable);
        }
        Display.setTitle(string);
        this.setVSync();
        this.stopped = true;
        this.soundOn = true;
        this.running = false;
        logger.info("Setting pixel format");
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    PixelFormat pixelFormat = new PixelFormat();
                    logger.info("Pixel format: Samples=" + pixelFormat.getSamples() + " Alpha=" + pixelFormat.getAlphaBits() + " Depth=" + pixelFormat.getDepthBits() + " Stencil=" + pixelFormat.getStencilBits());
                    Display.create(pixelFormat);
                }
                catch (Exception exception) {
                    logger.severe(exception.getMessage());
                }
                return null;
            }
        });
        if (!Display.isCreated()) {
            throw new MuleException("Failed to initialize LWJGL Display.\nPlease update your video card drivers.\nMore information at " + Properties.mule.masterServerUrl + "/faq.");
        }
        logger.info("GL Vendor: " + GL11.glGetString(7936));
        logger.info("GL Renderer: " + GL11.glGetString(7937));
        logger.info("GL Version: " + GL11.glGetString(7938));
        logger.info("GL Max Texture Size: " + GL11.glGetString(3379));
        Renderer.get().initDisplay(ViewProperties.get().screenWidth, ViewProperties.get().screenHeight);
        this.graphics = new Graphics(ViewProperties.get().screenWidth, ViewProperties.get().screenHeight);
        this.setOrthoProjection();
        logger.info("Display finished");
    }

    private void setOrthoProjection() {
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, ViewProperties.get().screenWidth, ViewProperties.get().screenHeight, 0.0, 1.0, -1.0);
        GL11.glMatrixMode(5888);
    }

    private void setVSync() {
        int n = Settings.get().vsync;
        boolean bl = n == 0 ? false : (n == 1 ? true : this.originalDisplayMode.getFrequency() == Properties.mule.framesPerSecond);
        logger.info("Setting vsync: " + bl);
        Display.setVSyncEnabled(bl);
    }

    public void setSoundOn(final boolean bl) {
        this.soundOn = bl;
        this.invokeLater(new Runnable(){

            public void run() {
                SoundPlayer.get().setSoundsOn(bl);
            }
        });
    }

    public boolean isSoundOn() {
        return this.soundOn;
    }

    public void setup(GameInfo gameInfo, UserInfo userInfo) {
        this.gameInfo = gameInfo;
        this.userInfo = userInfo;
    }

    public void init(MasterClient masterClient) throws MuleException {
        logger.info("*** Starting Game ***");
        if (this.userInfo == null) {
            throw new MuleException("Game can't start without User Info.");
        }
        this.closeString = null;
        this.stopped = false;
        logger.info("Display: Created=" + Display.isCreated() + " Active=" + Display.isActive() + " Visible=" + Display.isVisible());
        try {
            logger.info("Making display the current GL context");
            Display.makeCurrent();
        }
        catch (LWJGLException lWJGLException) {
            logger.log(Level.SEVERE, lWJGLException.toString(), lWJGLException);
        }
        for (int i = 0; i < 3; ++i) {
            GL11.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            GL11.glClear(16384);
            this.getGraphics().setAntiAlias(false);
            this.getGraphics().setColor(Color.white);
            this.getGraphics().drawString("LOADING ...", 20.0f, 20.0f);
            Display.update();
        }
        if (Display.getDisplayMode().getBitsPerPixel() == 16) {
            logger.info("Using 16 bit textures");
            InternalTextureLoader.get().set16BitMode();
        }
        this.muleGame.init(this, this.gameInfo, this.userInfo, masterClient);
        if (this.metaFrame != null) {
            this.muleGame.getController().addListener(this.metaFrame);
            this.metaFrame.focusDefaultComponent();
        }
        this.macSetWindowedMode = false;
    }

    public void standBy() {
        Display.update();
        this.processEventQueue();
    }

    public void run() throws MuleException {
        long l;
        long l2 = Properties.mule.framesPerSecond;
        long l3 = 0L;
        long l4 = 0L;
        this.skippedFrames = 0;
        try {
            Display.swapBuffers();
            Display.swapBuffers();
        }
        catch (LWJGLException lWJGLException) {
            throw new MuleException(lWJGLException.getMessage());
        }
        this.running = true;
        long l5 = l = System.currentTimeMillis() - 1L;
        while (this.running) {
            this.processEventQueue();
            int n = 0;
            if (System.currentTimeMillis() - l5 >= 1000L + l3 * 1000L / l2) {
                Log.info("Too much real time passed since last frame. Breaking sync with real time.");
                l5 = System.currentTimeMillis() - 1L;
                l3 = 0L;
            }
            while (System.currentTimeMillis() - l5 >= l3 * 1000L / l2) {
                this.update();
                ++n;
                ++l3;
                if (this.muleGame.closeRequested()) {
                    this.closeString = this.muleGame.getCloseString();
                    this.running = false;
                    return;
                }
                if (n <= 5) continue;
            }
            if (n == 0) {
                logger.severe("Ignored update");
            } else if (n > 1) {
                this.skippedFrames += n;
                if (this.skippedFrames > 1000) {
                    this.logSkippedFrames();
                }
            }
            ++l4;
            long l6 = System.currentTimeMillis() - l;
            if (l6 >= 1000L) {
                double d = (double)l4 * 1000.0 / (double)l6;
                this.metaFrame.setFpsCounter((int)Math.round(d));
                l = System.currentTimeMillis();
                l4 = 0L;
                int n2 = this.muleGame.getController().getClient().getRoundtripTime();
                this.metaFrame.setPing(n2);
            }
            this.render();
            try {
                Display.swapBuffers();
            }
            catch (LWJGLException lWJGLException) {
                throw new MuleException(lWJGLException.getMessage());
            }
            if (!this.macSetWindowedMode) {
                this.setWindowedMode();
                this.macSetWindowedMode = true;
            }
            if (this.muleGame.getInput().isPressed(10)) {
                this.setWindowedMode();
            }
            while (System.currentTimeMillis() - l5 < l3 * 1000L / l2) {
                this.idle();
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEventQueue() {
        ArrayList<Runnable> arrayList = this.eventQueue;
        synchronized (arrayList) {
            for (Runnable runnable : this.eventQueue) {
                runnable.run();
            }
            this.eventQueue.clear();
        }
        this.metaFrame.refreshLobby();
    }

    public void release() {
        logger.info("Closing game.");
        GL11.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        GL11.glClear(16384);
        this.getGraphics().setColor(Color.white);
        this.getGraphics().drawString("DISCONNECTING ...", 20.0f, 20.0f);
        Display.update();
        try {
            this.muleGame.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.running = false;
        this.stopped = true;
        if (Display.isFullscreen()) {
            this.setWindowedMode();
        }
        System.gc();
        logger.info("*** Game Over ***");
    }

    public String getCloseString() {
        return this.closeString;
    }

    private void update() {
        Display.processMessages();
        Music.poll(16);
        if (this.muleGame.getInput().isPressed(5)) {
            this.setFullscreen(!Display.isFullscreen());
        }
        this.muleGame.update();
    }

    private void render() {
        this.muleGame.render();
    }

    private void idle() {
        this.processEventQueue();
        this.muleGame.idle();
    }

    public void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean hasStopped() {
        return this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeLater(Runnable runnable) {
        ArrayList<Runnable> arrayList = this.eventQueue;
        synchronized (arrayList) {
            this.eventQueue.add(runnable);
        }
    }

    public void sendChatMessage(final String string) {
        this.invokeLater(new Runnable(){

            public void run() {
                if (!MuleGameContainer.this.muleGame.isClosed()) {
                    MuleGameContainer.this.muleGame.getController().sendChatMessage(string);
                }
            }
        });
    }

    public void kick(final int n) {
        this.invokeLater(new Runnable(){

            public void run() {
                if (!MuleGameContainer.this.muleGame.isClosed()) {
                    MuleGameContainer.this.muleGame.getController().kick(n);
                }
            }
        });
    }

    public void settingsChanged(final Settings settings, final Settings settings2) {
        this.invokeLater(new Runnable(){

            public void run() {
                if (!MuleGameContainer.this.muleGame.isClosed()) {
                    MuleGameContainer.this.muleGame.getController().settingsChanged(settings, settings2);
                }
            }
        });
    }

    public void setFullscreen(boolean bl) {
        if (bl) {
            int n;
            int n2;
            double d;
            int n3;
            int n4;
            Object object;
            logger.info("Setting fullscreen mode");
            ArrayList<MuleDisplayMode> arrayList = new ArrayList<MuleDisplayMode>();
            if (Properties.mule.onlyUseOriginalDisplayMode) {
                arrayList.add(new MuleDisplayMode(this.originalDisplayMode));
            } else {
                try {
                    object = Display.getAvailableDisplayModes();
                    for (int i = 0; i < ((DisplayMode[])object).length; ++i) {
                        DisplayMode displayMode = object[i];
                        if (!displayMode.isFullscreenCapable() || displayMode.getBitsPerPixel() != this.originalDisplayMode.getBitsPerPixel() || displayMode.getFrequency() != this.originalDisplayMode.getFrequency()) continue;
                        arrayList.add(new MuleDisplayMode(displayMode));
                    }
                }
                catch (Throwable throwable) {
                    logger.log(Level.SEVERE, throwable.toString(), throwable);
                }
                Collections.sort(arrayList);
            }
            if (arrayList.size() == 0) {
                logger.warning("No suitable fullscreen display mode candidate available.");
                return;
            }
            object = (MuleDisplayMode)arrayList.get(0);
            logger.info("Fullscreen mode: " + object + " Snap Scale: " + Settings.get().snapFullscreenScale);
            this.metaFrame.storeLocation();
            try {
                Display.setDisplayModeAndFullscreen(object.mode);
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, throwable.toString(), throwable);
            }
            try {
                Display.setParent(null);
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, throwable.toString(), throwable);
            }
            ViewProperties viewProperties = ViewProperties.get();
            if (Settings.get().snapFullscreenScale) {
                n4 = (object.mode.getWidth() - object.scale * viewProperties.screenWidth) / 2;
                n3 = (object.mode.getHeight() - object.scale * viewProperties.screenHeight) / 2;
                d = object.scale;
                n2 = object.scale * viewProperties.screenWidth;
                n = object.scale * viewProperties.screenHeight;
            } else {
                double d2;
                double d3 = (double)object.mode.getWidth() / (double)viewProperties.screenWidth;
                d = d3 < (d2 = (double)object.mode.getHeight() / (double)viewProperties.screenHeight) ? d3 : d2;
                n2 = (int)((double)viewProperties.screenWidth * d);
                n = (int)((double)viewProperties.screenHeight * d);
                n4 = (object.mode.getWidth() - n2) / 2;
                n3 = (object.mode.getHeight() - n) / 2;
            }
            for (int i = 0; i < 2; ++i) {
                GL11.glViewport(0, 0, object.mode.getWidth(), object.mode.getHeight());
                GL11.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
                GL11.glClear(16384);
                try {
                    Display.swapBuffers();
                    continue;
                }
                catch (Throwable throwable) {
                    logger.log(Level.SEVERE, throwable.toString(), throwable);
                }
            }
            logger.info("Viewport: x=" + n4 + " y=" + n3 + " width=" + n2 + " height=" + n);
            viewProperties.setView(n4, n3, d);
            GL11.glViewport(n4, n3, n2, n);
            this.setOrthoProjection();
        } else {
            this.setWindowedMode();
            this.metaFrame.restoreLocation();
        }
        if (!Keyboard.isCreated()) {
            try {
                Keyboard.create();
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, throwable.toString(), throwable);
            }
        }
    }

    private void setWindowedMode() {
        logger.info("Setting windowed mode: " + this.windowedDisplayMode.toString());
        try {
            MuleGameContainer.setParent(this.metaFrame);
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, throwable.toString(), throwable);
        }
        try {
            Display.setDisplayMode(this.windowedDisplayMode);
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, throwable.toString(), throwable);
        }
        ViewProperties viewProperties = ViewProperties.get();
        viewProperties.setView(0, 0, 1.0);
        GL11.glViewport(viewProperties.getViewX(), viewProperties.getViewY(), viewProperties.screenWidth, viewProperties.screenHeight);
        this.setOrthoProjection();
    }

    private static void setParent(MetaFrame metaFrame) throws LWJGLException {
        if (!Settings.get().useTwoWindows) {
            Display.setParent(metaFrame.getGameCanvas());
        } else {
            Display.setParent(null);
        }
    }

    public GameInput getGameInput() {
        return this.muleGame.getInput();
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public void destroy() {
        Display.destroy();
    }

    public void logSkippedFrames() {
        if (this.skippedFrames > 0) {
            logger.info("Skipped frames: " + this.skippedFrames);
            this.skippedFrames = 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MuleDisplayMode
    implements Comparable<MuleDisplayMode> {
        public int scale;
        public int heightError;
        public float aspectError;
        public DisplayMode mode;

        public MuleDisplayMode(DisplayMode displayMode) {
            this.mode = displayMode;
            this.scale = displayMode.getHeight() / ViewProperties.get().screenHeight;
            this.heightError = displayMode.getHeight() % ViewProperties.get().screenHeight;
            this.heightError = Math.min(ViewProperties.get().screenHeight - this.heightError, this.heightError);
            float f = (float)displayMode.getWidth() / (float)displayMode.getHeight();
            ViewProperties.get().getClass();
            ViewProperties.get().getClass();
            float f2 = 640.0f / 480.0f;
            this.aspectError = Math.abs(f - f2);
        }

        @Override
        public int compareTo(MuleDisplayMode muleDisplayMode) {
            if (this.heightError < muleDisplayMode.heightError) {
                return 0;
            }
            if (this.heightError > muleDisplayMode.heightError) {
                return -1;
            }
            if (this.aspectError < muleDisplayMode.aspectError) {
                return 0;
            }
            if (this.aspectError > muleDisplayMode.aspectError) {
                return -1;
            }
            if (this.mode.getWidth() < muleDisplayMode.mode.getWidth()) {
                return 0;
            }
            if (this.mode.getWidth() > muleDisplayMode.mode.getWidth()) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return this.mode.toString() + " Scale: " + this.scale + " Height-Diff: " + this.heightError + " Aspect-Diff: " + this.aspectError;
        }
    }
}

