/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.MuleException;
import com.turborilla.mule.controller.GameController;
import com.turborilla.mule.model.GameInfo;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.UserInfo;
import com.turborilla.mule.network.MasterClient;
import com.turborilla.mule.view.GameInput;
import com.turborilla.mule.view.MuleGameContainer;
import com.turborilla.mule.view.View;
import java.io.IOException;
import java.util.logging.Logger;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.SlickException;

public class MuleGame {
    private static Logger logger = Logger.getLogger("mule");
    private final String title;
    private final GameInput gameInput;
    private GameController gameController;
    private View view;
    private int numUpdates = 0;
    private int numRenders = 0;
    private boolean closed = true;

    public MuleGame(String string) throws MuleException {
        this.title = string;
        this.gameInput = new GameInput();
    }

    public void init(MuleGameContainer muleGameContainer, GameInfo gameInfo, UserInfo userInfo, MasterClient masterClient) throws MuleException {
        try {
            this.view = new View(muleGameContainer.getGraphics(), muleGameContainer.isSoundOn());
        }
        catch (SlickException slickException) {
            throw new MuleException(slickException);
        }
        GameModel gameModel = null;
        gameModel = userInfo.isReconnect() ? new GameModel(Phase.RECONNECT, gameInfo) : new GameModel(Phase.CONNECT, gameInfo);
        this.gameController = new GameController(gameModel, this.view, this.gameInput, masterClient, userInfo);
        this.numUpdates = 0;
        this.numRenders = 0;
        this.closed = false;
    }

    public void update() {
        this.gameInput.update();
        this.gameController.update(this.gameInput);
        ++this.numUpdates;
    }

    public void render() {
        this.gameController.draw();
        ++this.numRenders;
    }

    public void idle() {
        this.gameController.idle();
    }

    public boolean closeRequested() {
        return this.gameController.isCloseRequested();
    }

    public String getCloseString() {
        return this.gameController.getCloseString();
    }

    public void close() throws IOException {
        this.closed = true;
        if (this.view != null) {
            this.view.close();
        }
        if (this.gameController != null) {
            this.gameController.close();
        }
        this.gameController = null;
        this.view = null;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getTitle() {
        return this.title;
    }

    public void init(GameContainer gameContainer) throws SlickException {
        throw new SlickException("Don't use this init method.");
    }

    public View getView() {
        return this.view;
    }

    public GameController getController() {
        return this.gameController;
    }

    public GameInput getInput() {
        return this.gameInput;
    }
}

