/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.Properties;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.util.Vec2i;
import com.turborilla.mule.view.View;
import com.turborilla.mule.view.ViewProperties;
import java.util.Iterator;
import java.util.LinkedList;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagePainter {
    private View.TextStyle terminalStyle = View.TextStyle.TERMINAL;
    private Graphics graphics;
    private LinkedList<InfoMessage> infoMessages;
    private LinkedList<FloatingMessage> floatingMessages;
    private TerminalMessage terminalMessage;
    private TitleMessage titleMessage;
    private BigMessage bigMessage;
    private static final int MAX_NUM_INFO_MESSAGES = 7;
    public static final Vec2i TITLE_POS = new Vec2i(320, 11);
    public static final Vec2i TERMINAL_POS = new Vec2i(320, 353);
    private final float TERMINAL_FADE = 0.5f;

    MessagePainter(Graphics graphics) {
        this.graphics = graphics;
        this.infoMessages = new LinkedList();
        this.floatingMessages = new LinkedList();
        this.terminalMessage = new TerminalMessage("");
        this.titleMessage = new TitleMessage("");
        this.bigMessage = new BigMessage("");
    }

    public void setTerminalStyle(View.TextStyle textStyle) {
        this.terminalStyle = textStyle;
    }

    public void addInfoMessage(String string) {
        this.addInfoMessage(new InfoMessage(string));
    }

    public void addInfoMessage(String string, Player player) {
        string = string.replace("%s", player.getName());
        InfoMessage infoMessage = new InfoMessage(string);
        infoMessage.color = player.getColor();
        this.addInfoMessage(infoMessage);
    }

    public void addInfoMessage(InfoMessage infoMessage) {
        this.infoMessages.add(infoMessage);
        if (this.infoMessages.size() > 7) {
            this.infoMessages.poll();
        }
    }

    public void addFloatingMessage(FloatingMessage floatingMessage) {
        this.floatingMessages.add(floatingMessage);
    }

    public void setTerminalMessage(TerminalMessage terminalMessage) {
        this.terminalMessage = terminalMessage;
    }

    public Color getTerminalColor() {
        return this.terminalMessage.color;
    }

    public int getTitleWidth() {
        return this.titleMessage.getWidth();
    }

    public int getTerminalWidth() {
        return this.terminalMessage.getWidth();
    }

    public void removeTerminalMessage() {
        this.terminalMessage.kill();
    }

    public void changeTerminalMessage(String string) {
        this.terminalMessage.text = string;
    }

    public void setBigMessage(BigMessage bigMessage) {
        this.bigMessage = bigMessage;
    }

    public void setTitle(TitleMessage titleMessage) {
        this.titleMessage = titleMessage;
    }

    public void fadeTitle() {
        this.titleMessage.kill();
    }

    void update() {
        this.update(this.infoMessages);
        this.update(this.floatingMessages);
        this.terminalMessage.update();
        this.titleMessage.update();
        this.bigMessage.update();
    }

    private <T extends Message> void update(LinkedList<T> linkedList) {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Message message = (Message)iterator.next();
            message.update();
            if (!message.isDone()) continue;
            iterator.remove();
        }
    }

    public void drawInfo(Graphics graphics) {
        this.draw(this.infoMessages, graphics);
    }

    public void drawFloating(Graphics graphics) {
        this.draw(this.floatingMessages, graphics);
    }

    public void drawTerminal(Graphics graphics) {
        if (this.terminalMessage != null) {
            this.terminalMessage.draw(graphics, 0);
        }
    }

    public void drawSimpleTitle() {
        if (this.titleMessage != null) {
            this.titleMessage.draw(this.graphics, 0);
        }
    }

    public void drawBig(Graphics graphics) {
        if (this.bigMessage != null) {
            this.bigMessage.draw(graphics, 0);
        }
    }

    private <T extends Message> void draw(LinkedList<T> linkedList, Graphics graphics) {
        Iterator iterator = linkedList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Message message = (Message)iterator.next();
            message.draw(graphics, n);
            ++n;
        }
    }

    public class TitleMessage
    implements Message {
        private String text;
        private float life;
        private Color color;
        private int width;

        public TitleMessage(String string) {
            this(string, Float.POSITIVE_INFINITY);
        }

        public TitleMessage(String string, float f) {
            this.text = string;
            this.life = f;
            this.color = new Color(((MessagePainter)MessagePainter.this).terminalStyle.color);
            this.width = MessagePainter.this.terminalStyle.getWidth(string);
        }

        public int getWidth() {
            return this.width;
        }

        public void update() {
            this.life -= Properties.mule.delta;
            if (this.life < 0.0f) {
                this.life = 0.0f;
            }
            if (this.life < 0.5f) {
                this.color.a = this.life / 0.5f;
            }
        }

        public void draw(Graphics graphics, int n) {
            if (this.life > 0.0f) {
                MessagePainter.this.terminalStyle.printCentered(this.text, this.color, MessagePainter.TITLE_POS.x, MessagePainter.TITLE_POS.y);
            }
        }

        public void kill() {
            if (this.life > 0.5f) {
                this.life = 0.5f;
            }
        }

        public boolean isDone() {
            return this.life == 0.0f;
        }
    }

    public static interface ScrollingTerminalMessageListener {
        public void finished();
    }

    public class ScrollingTerminalMessage
    extends TerminalMessage {
        private int posX;
        private int width;
        private boolean done;
        private ScrollingTerminalMessageListener listener;

        public ScrollingTerminalMessage(String string, ScrollingTerminalMessageListener scrollingTerminalMessageListener) {
            this(string, ((MessagePainter)messagePainter).terminalStyle.color, scrollingTerminalMessageListener);
        }

        public ScrollingTerminalMessage(String string, Color color, ScrollingTerminalMessageListener scrollingTerminalMessageListener) {
            super(string, color);
            this.posX = ViewProperties.get().screenWidth;
            this.width = MessagePainter.this.terminalStyle.getWidth(string);
            this.listener = scrollingTerminalMessageListener;
            this.done = false;
        }

        public void update() {
            super.update();
            if (!this.done) {
                this.posX -= 2;
                if (this.posX < -this.width) {
                    this.done = true;
                    if (this.listener != null) {
                        this.listener.finished();
                    }
                }
            }
        }

        public void draw(Graphics graphics, int n) {
            MessagePainter.this.terminalStyle.print(this.text, this.color, this.posX, 353);
        }
    }

    public class TerminalMessage
    implements Message {
        protected String text;
        protected Color color;
        private float life;
        private int width;

        public TerminalMessage(String string) {
            this(string, Float.POSITIVE_INFINITY);
        }

        public TerminalMessage(String string, Color color) {
            this(string, color, Float.POSITIVE_INFINITY);
        }

        public TerminalMessage(String string, float f) {
            this(string, ((MessagePainter)messagePainter).terminalStyle.color, f);
        }

        public TerminalMessage(String string, Color color, float f) {
            this.text = string;
            this.life = f;
            this.color = new Color(color);
            this.width = MessagePainter.this.terminalStyle.getWidth(string);
        }

        public int getWidth() {
            return this.width;
        }

        public void update() {
            this.life -= Properties.mule.delta;
            if (this.life < 0.0f) {
                this.life = 0.0f;
            }
            if (this.life < 0.5f) {
                this.color.a = this.life / 0.5f;
            }
        }

        public void draw(Graphics graphics, int n) {
            if (this.life > 0.0f) {
                MessagePainter.this.terminalStyle.printCentered(this.text, this.color, MessagePainter.TERMINAL_POS.x, MessagePainter.TERMINAL_POS.y);
            }
        }

        public void kill() {
            if (this.life > 0.5f) {
                this.life = 0.5f;
            }
        }

        public boolean isDone() {
            return this.life == 0.0f;
        }
    }

    public static class FloatingMessage
    implements Message {
        private String text;
        private View.TextStyle style;
        private Color color;
        private float alpha;
        private Vector2f pos;

        public FloatingMessage(String string, View.TextStyle textStyle, float f, float f2) {
            this.text = string;
            this.style = textStyle;
            this.color = new Color(textStyle.color);
            this.alpha = 2.0f;
            this.pos = new Vector2f(f, f2);
        }

        public void update() {
            this.pos.y -= 20.0f * Properties.mule.delta;
            this.alpha -= 1.0f * Properties.mule.delta;
            this.color.a = this.alpha > 1.0f ? 1.0f : (this.alpha < 0.0f ? 0.0f : this.alpha);
        }

        public void draw(Graphics graphics, int n) {
            this.style.font.drawString((float)Math.floor(this.pos.x + 0.5f), (float)Math.floor(this.pos.y + 0.5f), this.text, this.color);
        }

        public boolean isDone() {
            return this.color.a == 0.0f;
        }
    }

    public static class InfoMessage
    implements Message {
        private static Color shadeColor = new Color(0.0f, 0.0f, 0.0f, 1.0f);
        private static View.TextStyle style = View.TextStyle.TERMINAL;
        public String text;
        public Color color = Color.red;
        public float lifeTime = 5.5f;
        public float age = 0.0f;

        public InfoMessage(String string) {
            this.text = string;
        }

        public void update() {
            this.age += Properties.mule.delta;
        }

        public void draw(Graphics graphics, int n) {
            style.print(this.text, shadeColor, 25, 29 + n * 14);
            style.print(this.text, this.color, 24, 28 + n * 14);
        }

        public boolean isDone() {
            return this.age >= this.lifeTime;
        }
    }

    public static class BigMessage
    implements Message {
        private String text;
        private float y;
        private Color color;
        private static float stopY = 120.0f;

        public BigMessage(String string) {
            this.text = string;
            this.color = new Color(View.TextStyle.BIG.color);
            this.y = -16.0f;
        }

        public void draw(Graphics graphics, int n) {
            View.TextStyle textStyle = View.TextStyle.BIG;
            textStyle.printCentered(this.text, this.color, 320, Math.round(this.y));
        }

        public boolean isDone() {
            return this.color.a == 0.0f;
        }

        public void update() {
            if (this.y < stopY) {
                this.y += (1.0f + 3.5f * (stopY - this.y)) * Properties.mule.delta;
                if (this.y > stopY) {
                    this.y = stopY;
                }
            } else {
                this.color.a -= 1.1f * Properties.mule.delta;
                if (this.color.a < 0.0f) {
                    this.color.a = 0.0f;
                }
            }
        }
    }

    private static interface Message {
        public void update();

        public void draw(Graphics var1, int var2);

        public boolean isDone();
    }
}

