/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.view.MuleImage;
import com.turborilla.mule.view.ViewProperties;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;

public class MapBorderPainter {
    private Graphics graphics;
    private Image[] corners;
    private int[][] cornerPos = new int[][]{{10, 10}, {621, 10}, {10, 361}, {621, 361}};

    public MapBorderPainter(Graphics graphics) throws SlickException {
        this.graphics = graphics;
        MuleImage muleImage = new MuleImage("images/map_borders.png");
        SpriteSheet spriteSheet = new SpriteSheet(muleImage, 9, 9);
        this.corners = new Image[4];
        for (int i = 0; i < this.corners.length; ++i) {
            this.corners[i] = spriteSheet.getSubImage(i, 0);
        }
    }

    public void drawMapBorder(PlanetMap planetMap) {
        ViewProperties viewProperties = ViewProperties.get();
        int n = viewProperties.mapOffsetX;
        int n2 = viewProperties.mapOffsetY;
        this.graphics.setColor(ViewProperties.get().mapBaseColor);
        viewProperties.getClass();
        viewProperties.getClass();
        viewProperties.getClass();
        int n3 = 10 + viewProperties.playAreaWidth;
        viewProperties.getClass();
        this.fillBorder(10, 10, n3, 10 + viewProperties.playAreaHeight, n, n2, n + planetMap.getWidth(), n2 + planetMap.getHeight());
        if (planetMap.isRiver()) {
            Image image = planetMap.getSkin().getImage("tiles-river2");
            image.draw(n + 256, n2 - 64);
            image.draw(n + 256, n2 + 320);
        }
        for (int i = 0; i < this.corners.length; ++i) {
            this.corners[i].draw(this.cornerPos[i][0], this.cornerPos[i][1]);
        }
    }

    private void fillBorder(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.graphics.fillRect(n, n2, n3 - n, n6 - n2);
        this.graphics.fillRect(n, n8, n3 - n, n4 - n8);
        this.graphics.fillRect(n, n6, n5 - n, n8 - n6);
        this.graphics.fillRect(n7, n6, n3 - n7, n8 - n6);
    }
}

