/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.model.util.Vec2;
import com.turborilla.mule.view.MapSkin;
import com.turborilla.mule.view.ViewProperties;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;

public class LandGrantPainter {
    private Image plotFrame;
    private Vec2 framePos;
    private boolean frameVisible;
    private Color graceColor = new Color(1.0f, 1.0f, 1.0f, 0.25f);

    public LandGrantPainter() throws SlickException {
        this.framePos = new Vec2();
    }

    void setSkin(MapSkin mapSkin) {
        this.plotFrame = mapSkin.getImage("land-grant-frame");
    }

    public void moveFrameTo(PlanetTile planetTile) {
        this.framePos.x = ViewProperties.get().mapOffsetX + planetTile.getPosX() * 64;
        this.framePos.y = ViewProperties.get().mapOffsetY + planetTile.getPosY() * 64;
        this.frameVisible = true;
    }

    public void hideFrame() {
        this.frameVisible = false;
    }

    public void draw(boolean bl) {
        Color color = Color.white;
        if (bl) {
            color = this.graceColor;
        }
        if (this.frameVisible) {
            this.plotFrame.draw(this.framePos.x, this.framePos.y, color);
        }
    }
}

