/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.Properties;
import com.turborilla.mule.model.ColonyEvent;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.Factory;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.model.map.Tile;
import com.turborilla.mule.model.util.Vec2;
import com.turborilla.mule.sound.SoundPlayer;
import com.turborilla.mule.view.AnimatedSprite;
import com.turborilla.mule.view.IntroPainter;
import com.turborilla.mule.view.MapPainter;
import com.turborilla.mule.view.MapSkin;
import com.turborilla.mule.view.MuleImage;
import com.turborilla.mule.view.SpriteLoader;
import com.turborilla.mule.view.ViewProperties;
import java.util.ArrayList;
import java.util.Random;
import org.newdawn.slick.Animation;
import org.newdawn.slick.BigImage;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;

public class ColonyEventPainter {
    private PirateShip pirateShip;
    private FireInStore fireInStore;
    private MeteoriteStrike meteoriteStrike;
    private Radiation radiation;
    private SunspotActivity sunspotActivity;
    private AcidRainStorm acidRainStorm;
    private PestAttack pestAttack;
    private PlanetQuake planetQuake;
    private ShipReturns shipReturns;
    private SoundPlayer sound = SoundPlayer.get();

    public ColonyEventPainter(MapPainter mapPainter, IntroPainter introPainter) throws SlickException {
        this.pirateShip = new PirateShip();
        this.fireInStore = new FireInStore();
        this.meteoriteStrike = new MeteoriteStrike();
        this.radiation = new Radiation();
        this.sunspotActivity = new SunspotActivity();
        this.acidRainStorm = new AcidRainStorm();
        this.pestAttack = new PestAttack();
        this.planetQuake = new PlanetQuake(mapPainter);
        this.shipReturns = new ShipReturns(introPainter);
    }

    public void begin(ColonyEvent colonyEvent, GameModel gameModel) {
        ColonyEvent.Type type = colonyEvent.getType();
        this.getPainter(type).begin(colonyEvent, gameModel);
    }

    public void update(ColonyEvent colonyEvent, float f) {
        ColonyEvent.Type type = colonyEvent.getType();
        this.getPainter(type).update(f);
    }

    public void draw(ColonyEvent colonyEvent) {
        ColonyEvent.Type type = colonyEvent.getType();
        this.getPainter(type).draw();
    }

    public boolean isTimeToApply(ColonyEvent colonyEvent) {
        return this.getPainter(colonyEvent.getType()).isTimeToApply();
    }

    public boolean isFinished(ColonyEvent colonyEvent) {
        return this.getPainter(colonyEvent.getType()).isFinished();
    }

    private EventPainter getPainter(ColonyEvent.Type type) {
        switch (type) {
            case PIRATE_SHIP: {
                return this.pirateShip;
            }
            case FIRE_IN_STORE: {
                return this.fireInStore;
            }
            case METEORITE_STRIKE: {
                return this.meteoriteStrike;
            }
            case RADIATION: {
                return this.radiation;
            }
            case SUNSPOT_ACTIVITY: {
                return this.sunspotActivity;
            }
            case ACID_RAIN_STORM: {
                return this.acidRainStorm;
            }
            case PEST_ATTACK: {
                return this.pestAttack;
            }
            case PLANET_QUAKE: {
                return this.planetQuake;
            }
            case SHIP_RETURNS: {
                return this.shipReturns;
            }
        }
        throw new RuntimeException("No painter exists for colony event: " + (Object)((Object)type));
    }

    private static class ShipReturns
    implements EventPainter {
        private IntroPainter intro;

        public ShipReturns(IntroPainter introPainter) throws SlickException {
            this.intro = introPainter;
        }

        public void begin(ColonyEvent colonyEvent, GameModel gameModel) {
            this.intro.startLanding();
        }

        public void update(float f) {
            this.intro.update();
        }

        public boolean isTimeToApply() {
            return this.isFinished();
        }

        public boolean isFinished() {
            return this.intro.isLandingComplete();
        }

        public void draw() {
            this.intro.draw();
        }
    }

    private class PlanetQuake
    implements EventPainter {
        private float shakeTime;
        private float waitTime;
        private Tile mountain;
        private Vec2 pos = new Vec2();
        private Vec2 target = new Vec2();
        private Tile secondaryTile;
        private final MapPainter mapPainter;
        private final float speed = 15.0f;

        public PlanetQuake(MapPainter mapPainter) {
            this.mapPainter = mapPainter;
        }

        public void begin(ColonyEvent colonyEvent, GameModel gameModel) {
            this.shakeTime = 4.0f;
            this.waitTime = 4.0f;
            MapShaker.setEnabled(true);
            this.mountain = null;
            if (colonyEvent.tile != null) {
                this.mountain = colonyEvent.tile.findLastTileBit("1mountain");
                colonyEvent.tile.removeTileBit(this.mountain);
                this.pos.set(colonyEvent.tile.getPosX() * 64 + this.mountain.getXOffset(), colonyEvent.tile.getPosY() * 64 + this.mountain.getYOffset());
                this.target.set(colonyEvent.getSecondaryTile().getPosX() * 64 + this.mountain.getXOffset(), colonyEvent.getSecondaryTile().getPosY() * 64 + this.mountain.getYOffset());
                this.secondaryTile = colonyEvent.getSecondaryTile();
            }
            ColonyEventPainter.this.sound.playEarthquake();
        }

        public void draw() {
            if (this.mountain != null) {
                MapSkin mapSkin = this.mapPainter.getSkin();
                Image image = mapSkin.getImage(this.mountain.getIdentifier());
                image.draw(this.pos.x + (float)ViewProperties.get().mapOffsetX, this.pos.y + (float)ViewProperties.get().mapOffsetY);
            }
        }

        public boolean isTimeToApply() {
            return this.mountain == null && this.shakeTime <= 0.0f;
        }

        public boolean isFinished() {
            return this.mountain == null && this.waitTime <= 0.0f;
        }

        public void update(float f) {
            if (this.shakeTime > 0.0f) {
                this.shakeTime -= f;
                if (this.shakeTime <= 0.0f) {
                    MapShaker.setEnabled(false);
                    this.shakeTime = 0.0f;
                }
            } else {
                this.waitTime -= f;
            }
            if (this.mountain != null) {
                if (this.pos.x < this.target.x) {
                    this.pos.x += 15.0f * f;
                    if (this.pos.x >= this.target.x) {
                        this.pos.x = this.target.x;
                        this.placeMountain();
                    }
                } else if (this.pos.x > this.target.x) {
                    this.pos.x -= 15.0f * f;
                    if (this.pos.x <= this.target.x) {
                        this.pos.x = this.target.x;
                        this.placeMountain();
                    }
                }
            }
            MapShaker.update();
        }

        private void placeMountain() {
            this.secondaryTile.addTileBit(this.mountain.getName(), this.mountain.getIdentifier(), this.mountain.getXOffset(), this.mountain.getYOffset());
            this.mountain = null;
        }
    }

    private class PestAttack
    implements EventPainter {
        private AnimatedSprite pest = new AnimatedSprite("images/events/pest.png", 29, 29, 100);
        private Vec2[] pos;
        private float timer;
        private boolean active;

        public PestAttack() throws SlickException {
            this.pest.setAutoUpdate(false);
        }

        public void begin(ColonyEvent colonyEvent, GameModel gameModel) {
            if (colonyEvent.tile != null) {
                Random random = gameModel.getRandom();
                int n = ViewProperties.get().mapOffsetX + colonyEvent.tile.getPosX() * 64;
                int n2 = ViewProperties.get().mapOffsetY + colonyEvent.tile.getPosY() * 64;
                this.pos = new Vec2[4];
                this.pos[0] = new Vec2(n + 5, n2 + 5);
                this.pos[1] = new Vec2(n + 32, n2 + 32);
                this.pos[2] = new Vec2(n + 32, n2 + 5);
                this.pos[3] = new Vec2(n + 5, n2 + 32);
                this.timer = 8.0f;
                this.active = true;
                ColonyEventPainter.this.sound.playPest();
            } else {
                this.timer = 4.0f;
                this.active = false;
            }
        }

        public void draw() {
            if (this.active) {
                for (Vec2 vec2 : this.pos) {
                    this.pest.draw(vec2.x, vec2.y);
                }
            }
        }

        public boolean isTimeToApply() {
            return this.timer < 6.0f;
        }

        public boolean isFinished() {
            return this.timer <= 0.0f;
        }

        public void update(float f) {
            this.pest.getAnimation().update(16L);
            this.timer -= f;
            if (this.timer < 0.0f) {
                this.timer = 0.0f;
            }
        }
    }

    private class AcidRainStorm
    implements EventPainter {
        private AnimatedSprite cloud = new AnimatedSprite("images/events/acidrain.png", 54, 44, 200);
        private Vec2 pos = new Vec2();
        private float timer;
        private final float waitTime = 0.5f;

        public void begin(ColonyEvent colonyEvent, GameModel gameModel) {
            this.pos.set(-this.cloud.getWidth(), (float)ViewProperties.get().mapOffsetY + colonyEvent.tile.getCenter().y - 30.0f);
            this.timer = 0.5f;
            ColonyEventPainter.this.sound.playStorm();
        }

        public void draw() {
            this.cloud.draw(this.pos.x, this.pos.y);
        }

        public boolean isTimeToApply() {
            return this.timer < 0.5f;
        }

        public boolean isFinished() {
            return this.timer <= 0.0f;
        }

        public void update(float f) {
            if (this.pos.x > 640.0f) {
                this.timer -= Properties.mule.delta;
                if (this.timer <= 0.0f) {
                    this.timer = 0.0f;
                }
            } else {
                this.pos.x += 80.0f * f;
            }
        }
    }

    private class SunspotActivity
    implements EventPainter {
        private SpriteSheet spriteSheet;
        private ArrayList<AnimatedSprite> sunspots;
        private ArrayList<Vec2> sunspotPositions;
        private ArrayList<Vec2> factoryPositions;
        private Color color = new Color(Color.white);
        private Random random;
        private float timer;
        private float totalTime = 6.5f;

        public SunspotActivity() throws SlickException {
            this.spriteSheet = new SpriteSheet("images/events/sunspots.png", 12, 12, Color.magenta);
            this.sunspots = new ArrayList();
            this.sunspotPositions = new ArrayList();
            for (int i = 0; i < 4; ++i) {
                AnimatedSprite animatedSprite = new AnimatedSprite(this.spriteSheet, 110 + 20 * i);
                animatedSprite.getAnimation().setAutoUpdate(false);
                animatedSprite.getAnimation().setLooping(false);
                this.sunspots.add(animatedSprite);
                this.sunspotPositions.add(new Vec2());
            }
            this.factoryPositions = new ArrayList();
            this.random = new Random();
        }

        public void begin(ColonyEvent colonyEvent, GameModel gameModel) {
            this.factoryPositions.clear();
            for (Player player : gameModel.getPlayers()) {
                for (PlanetTile planetTile : player.getOwnedTiles()) {
                    Factory factory = planetTile.getFactoryWithResource(Resource.Energy);
                    if (factory == null) continue;
                    this.factoryPositions.add(new Vec2((float)ViewProperties.get().mapOffsetX + planetTile.getCenter().x + 20.0f, (float)ViewProperties.get().mapOffsetY + planetTile.getCenter().y + 8.0f));
                }
            }
            if (this.factoryPositions.isEmpty()) {
                this.timer = 3.0f;
            } else {
                ColonyEventPainter.this.sound.playSolarWind();
                this.timer = this.totalTime;
            }
            for (int i = 0; i < this.sunspotPositions.size(); ++i) {
                this.updatePosition(i);
            }
        }

        public void draw() {
            this.color.a = this.totalTime - this.timer < 1.0f ? this.totalTime - this.timer : (this.timer < 1.0f ? this.timer : 1.0f);
            for (Vec2 vec2 : this.factoryPositions) {
                for (int i = 0; i < this.sunspots.size(); ++i) {
                    Vec2 vec22 = this.sunspotPositions.get(i);
                    this.sunspots.get(i).drawCentered(vec2.x + vec22.x, vec2.y + vec22.y, this.color);
                    Animation animation = this.sunspots.get(i).getAnimation();
                    if (animation.getFrame() < animation.getFrameCount() - 1) continue;
                    this.updatePosition(i);
                }
            }
        }

        private void updatePosition(int n) {
            Vec2 vec2 = this.sunspotPositions.get(n);
            vec2.x = this.random.nextInt(20) - 10;
            vec2.y = this.random.nextInt(20) - 10;
            this.sunspots.get(n).getAnimation().restart();
        }

        public boolean isTimeToApply() {
            return this.timer < 4.0f;
        }

        public boolean isFinished() {
            return this.timer <= 0.0f;
        }

        public void update(float f) {
            this.timer -= f;
            if (this.timer < 0.0f) {
                this.timer = 0.0f;
            }
            for (int i = 0; i < this.sunspots.size(); ++i) {
                this.sunspots.get(i).getAnimation().update(16L);
            }
        }
    }

    private class Radiation
    implements EventPainter {
        private AnimatedSprite radiation = new AnimatedSprite("images/events/mulefault.png", 13, 15, 100);
        private AnimatedSprite mule;
        private Vec2 pos;
        private boolean goingRight;
        private float introTimer;
        private float standingTimer;
        private float outroTimer;
        private boolean active;
        private static final float speed = 90.0f;

        public Radiation() throws SlickException {
            SpriteSheet spriteSheet = SpriteLoader.getMuleSpriteSheet("mule", 0, false);
            this.mule = new AnimatedSprite(spriteSheet);
            this.mule.createAnimation(new int[]{6, 7, 8}, 120);
            this.mule.createAnimation(new int[]{9, 10, 11}, 120);
            this.pos = new Vec2();
        }

        public void begin(ColonyEvent colonyEvent, GameModel gameModel) {
            if (colonyEvent.tile != null) {
                this.pos.set(colonyEvent.tile.getCenter().x + 25.0f, colonyEvent.tile.getCenter().y + 18.0f);
                if (colonyEvent.tile.getPosX() > 3) {
                    this.goingRight = true;
                    this.mule.setAnimation(1);
                } else {
                    this.goingRight = false;
                    this.mule.setAnimation(0);
                }
                this.mule.getAnimation().stop();
                this.introTimer = 1.0f;
                this.standingTimer = 2.2f;
                this.outroTimer = 1.0f;
                this.active = true;
            } else {
                this.introTimer = 0.0f;
                this.standingTimer = 0.0f;
                this.outroTimer = 4.0f;
                this.active = false;
            }
        }

        public void draw() {
            if (this.active && this.introTimer == 0.0f) {
                this.mule.draw(this.pos.x, this.pos.y);
                if (this.goingRight) {
                    this.radiation.draw(this.pos.x + 21.0f, this.pos.y + 15.0f);
                } else {
                    this.radiation.draw(this.pos.x, this.pos.y + 15.0f);
                }
            }
        }

        public boolean isTimeToApply() {
            return this.introTimer == 0.0f;
        }

        public boolean isFinished() {
            return this.outroTimer == 0.0f;
        }

        public void update(float f) {
            if (this.introTimer > 0.0f) {
                this.introTimer -= f;
                if (this.introTimer <= 0.0f) {
                    this.introTimer = 0.0f;
                    ColonyEventPainter.this.sound.playRadiation();
                }
            } else if (this.standingTimer > 0.0f) {
                this.standingTimer -= f;
                if (this.standingTimer <= 0.0f) {
                    this.standingTimer = 0.0f;
                    this.mule.getAnimation().start();
                }
            } else if (this.active) {
                this.pos.x = this.goingRight ? (this.pos.x += 90.0f * f) : (this.pos.x -= 90.0f * f);
                if (this.pos.x < (float)(-this.mule.getWidth()) || this.pos.x > 640.0f) {
                    this.active = false;
                }
            } else {
                this.outroTimer -= f;
                if (this.outroTimer <= 0.0f) {
                    this.outroTimer = 0.0f;
                }
            }
        }
    }

    private class MeteoriteStrike
    implements EventPainter {
        private AnimatedSprite meteorite = new AnimatedSprite("images/events/meteor_sprite.png", 34, 33, 200);
        private Image shadow = new MuleImage("images/events/meteor_shadow.png");
        private Vec2 pos = new Vec2();
        private Vec2 target = new Vec2();
        private float sign;
        private float speed = 71.0f;
        private boolean landed;
        private float timer;
        private Color shadowColor = new Color(Color.white);
        private final float WAIT_TIME = 4.0f;

        public void begin(ColonyEvent colonyEvent, GameModel gameModel) {
            this.target.set(colonyEvent.tile.getCenter().x, colonyEvent.tile.getCenter().y - 5.0f);
            this.sign = this.target.x > 320.0f ? 1.0f : -1.0f;
            float f = Math.max(this.meteorite.getWidth(), this.meteorite.getHeight()) / 2;
            float f2 = f + this.target.y + (float)ViewProperties.get().mapOffsetY + 7.0f;
            this.pos.x = this.target.x - this.sign * f2;
            this.pos.y = this.target.y - f2;
            this.timer = 4.0f;
            this.shadowColor.a = 0.0f;
            this.landed = false;
            ColonyEventPainter.this.sound.playMeteorTail();
        }

        public void update(float f) {
            if (this.landed) {
                MapShaker.update();
                this.timer -= f;
                if (this.timer < 3.7f) {
                    MapShaker.setEnabled(false);
                }
            } else {
                this.pos.x += this.sign * this.speed * f;
                this.pos.y += this.speed * f;
                if (this.shadowColor.a < 0.2f) {
                    this.shadowColor.a += 0.1f * f;
                }
                if (this.pos.y >= this.target.y) {
                    this.landed = true;
                    ColonyEventPainter.this.sound.playMeteorImpact();
                    MapShaker.setEnabled(true);
                    this.pos.set(this.target);
                }
            }
        }

        public boolean isTimeToApply() {
            return this.timer < 4.0f;
        }

        public boolean isFinished() {
            return this.timer <= 0.0f;
        }

        public void draw() {
            int n = ViewProperties.get().mapOffsetX;
            int n2 = ViewProperties.get().mapOffsetY;
            this.meteorite.drawCentered(this.pos.x + (float)n, this.pos.y + (float)n2);
            if (!this.landed) {
                this.shadow.draw((float)n + this.pos.x + 2.0f - (float)(this.shadow.getWidth() / 2), (float)n2 + this.target.y + 15.0f - (float)(this.shadow.getHeight() / 2), this.shadowColor);
            }
        }
    }

    private static class MapShaker {
        private static int mapX = ViewProperties.get().mapOffsetX;
        private static int mapY = ViewProperties.get().mapOffsetY;
        private static int counter;
        private static boolean enabled;
        private static Random random;

        private MapShaker() {
        }

        private static void setEnabled(boolean bl) {
            enabled = bl;
            if (enabled) {
                counter = 0;
            } else {
                ViewProperties.get().mapOffsetX = mapX;
                ViewProperties.get().mapOffsetY = mapY;
            }
        }

        private static void update() {
            if (enabled) {
                if (counter == 0) {
                    ViewProperties.get().mapOffsetX = mapX + random.nextInt(8) - 4;
                    ViewProperties.get().mapOffsetY = mapY + random.nextInt(8) - 4;
                    counter = 1;
                } else {
                    --counter;
                }
            }
        }

        static {
            random = new Random();
        }
    }

    private class FireInStore
    implements EventPainter {
        private AnimatedSprite fire = new AnimatedSprite("images/events/shopfire.png", 28, 47, 200);
        private float timer;

        public void begin(ColonyEvent colonyEvent, GameModel gameModel) {
            this.timer = 5.5f;
            ColonyEventPainter.this.sound.playFire();
        }

        public void update(float f) {
            this.timer -= f;
            if (this.timer < 0.0f) {
                this.timer = 0.0f;
            }
        }

        public boolean isTimeToApply() {
            return this.timer < 4.0f;
        }

        public boolean isFinished() {
            return this.timer <= 0.0f;
        }

        public void draw() {
            if (this.timer > 1.0f) {
                this.fire.draw(305.0f, 160.0f);
            }
        }
    }

    private class PirateShip
    implements EventPainter {
        private AnimatedSprite pirateShip;
        private Animation teleportAnimation;
        private Animation beamAnimation;
        private Animation cooldownAnimation;
        private Animation warpAnimation;
        private static final int BEAM_DURATION = 50;
        private static final int WARP_DURATION = 50;
        private final Vec2 START_POS = new Vec2(185.0f, 62.0f);
        private float teleportTime;
        private float beamTime;
        private float cooldownTime;
        private float totalWarpTime;
        private float warpTime;
        private float waitTime;
        private Vec2 pos;

        public PirateShip() throws SlickException {
            BigImage bigImage = new BigImage("images/events/pirate_ship.png");
            SpriteSheet spriteSheet = new SpriteSheet(bigImage, 271, 132);
            this.pirateShip = new AnimatedSprite(spriteSheet);
            this.teleportAnimation = this.pirateShip.createAnimation(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, 50);
            this.beamAnimation = this.pirateShip.createAnimation(new int[]{10, 11, 12, 13, 14}, 50);
            this.cooldownAnimation = this.pirateShip.createAnimation(new int[]{15, 16, 17, 18, 19, 20}, 50);
            this.warpAnimation = this.pirateShip.createAnimation(new int[]{21, 22, 23, 24, 25, 26, 27, 28, 29}, 50);
            this.teleportAnimation.setLooping(false);
            this.beamAnimation.setLooping(true);
            this.cooldownAnimation.setLooping(false);
            this.warpAnimation.setLooping(false);
            this.pos = new Vec2();
        }

        public void begin(ColonyEvent colonyEvent, GameModel gameModel) {
            this.pos.set(this.START_POS);
            this.teleportAnimation.restart();
            this.beamAnimation.restart();
            this.cooldownAnimation.restart();
            this.warpAnimation.restart();
            float f = Properties.mule.gameSecond / 1000.0f;
            this.teleportTime = f * 500.0f;
            this.beamTime = 4.1f;
            this.cooldownTime = f * 300.0f;
            this.warpTime = this.totalWarpTime = f * 450.0f;
            this.waitTime = 4.5f;
            ColonyEventPainter.this.sound.playPirates();
        }

        public void update(float f) {
            if (this.teleportTime > 0.0f) {
                this.teleportTime -= f;
            } else if (this.beamTime > 0.0f) {
                this.beamTime -= f;
            } else if (this.cooldownTime > 0.0f) {
                this.cooldownTime -= f;
            } else if (this.warpTime > 0.0f) {
                this.warpTime -= f;
                float f2 = this.warpTime / this.totalWarpTime;
                this.pos.x = this.START_POS.x * f2 + (1.0f - f2) * 640.0f;
            } else if (this.waitTime > 0.0f) {
                this.waitTime -= Properties.mule.delta;
            }
        }

        public boolean isTimeToApply() {
            return this.beamTime <= 0.0f;
        }

        public boolean isFinished() {
            return this.waitTime <= 0.0f;
        }

        public void draw() {
            if (this.teleportTime > 0.0f) {
                this.teleportAnimation.draw(this.pos.x, this.pos.y);
            } else if (this.beamTime > 0.0f) {
                this.beamAnimation.draw(this.pos.x, this.pos.y);
            } else if (this.cooldownTime > 0.0f) {
                this.cooldownAnimation.draw(this.pos.x, this.pos.y);
            } else {
                this.warpAnimation.draw(this.pos.x, this.pos.y);
            }
        }
    }

    private static interface EventPainter {
        public void begin(ColonyEvent var1, GameModel var2);

        public void update(float var1);

        public void draw();

        public boolean isTimeToApply();

        public boolean isFinished();
    }
}

