/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.Properties;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.view.AuctionPainter;
import com.turborilla.mule.view.ViewProperties;
import java.util.ArrayList;
import java.util.Collection;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionPainter {
    private Graphics graphics;
    private Resource resource;
    private final int xPos;
    private final int yPos;
    private final int bottomPos;
    private final Color criticalLineColor;
    private ArrayList<ResourceBar> resourceBars;
    private boolean adjustingBars;

    public CollectionPainter(Graphics graphics) {
        this.xPos = ViewProperties.get().mapOffsetX;
        this.yPos = ViewProperties.get().mapOffsetY;
        this.bottomPos = this.yPos + 259;
        this.criticalLineColor = new Color(0.8f, 0.0f, 0.0f);
        this.graphics = graphics;
        this.resourceBars = new ArrayList();
    }

    public void begin(Collection<Player> collection, Resource resource) {
        this.resource = resource;
        for (Player player : collection) {
            this.resourceBars.add(new ResourceBar(player, resource));
        }
        this.adjustingBars = false;
    }

    public void targetCurrentResources() {
        for (ResourceBar resourceBar : this.resourceBars) {
            int n = resourceBar.player.getResource(this.resource);
            resourceBar.setTarget(n);
        }
        this.adjustingBars = true;
    }

    public boolean isAdjustingResourceBars() {
        return this.adjustingBars;
    }

    public void update() {
        this.adjustingBars = false;
        for (ResourceBar resourceBar : this.resourceBars) {
            if (!resourceBar.update()) continue;
            this.adjustingBars = true;
        }
    }

    public void updateDisplayAmounts() {
        for (ResourceBar resourceBar : this.resourceBars) {
            resourceBar.updateDisplayAmount();
        }
    }

    public void draw(GameModel gameModel, boolean bl) {
        int n = this.bottomPos - 27;
        for (ResourceBar resourceBar : this.resourceBars) {
            int n2 = resourceBar.player.getPlayerIndex();
            int n3 = this.xPos + 121 + n2 * 104;
            int n4 = resourceBar.player.getColorIndex();
            Color[] colorArray = ViewProperties.get().avatarColors[n4];
            Color color = colorArray[9];
            Color color2 = colorArray[3];
            int n5 = Math.min(resourceBar.getIntHeight(), 159);
            if (n5 > 0) {
                this.graphics.setColor(color);
                this.graphics.fillRect(n3, n - n5 - 1, 21.0f, n5 + 2);
                this.graphics.setColor(color2);
                this.graphics.fillRect(n3 + 1, n - n5, 19.0f, n5);
            }
            if (!bl) continue;
            int n6 = resourceBar.player.getResourceCritical(this.resource, gameModel);
            int n7 = Math.round((float)n6 * 6.0f);
            if (n7 > 159) {
                n7 -= 159;
            }
            if (n7 < 0) continue;
            this.graphics.setColor(this.criticalLineColor);
            this.graphics.fillRect(n3 - 5, n - n7 - 1, 31.0f, 2.0f);
        }
    }

    public void drawDisplayAmount(AuctionPainter auctionPainter) {
        for (ResourceBar resourceBar : this.resourceBars) {
            String string = "" + resourceBar.getDisplayAmount();
            auctionPainter.drawDisplay(resourceBar.player, string, -1);
        }
    }

    public int getAmount(Player player) {
        for (ResourceBar resourceBar : this.resourceBars) {
            if (resourceBar.player != player) continue;
            return resourceBar.getAmount();
        }
        return -1;
    }

    public void end() {
        this.resourceBars.clear();
    }

    private static class ResourceBar {
        private static final float UNIT_SIZE = 6.0f;
        private static final float SPEED = 25.0f;
        private Player player;
        private float height;
        private float target;
        private int displayAmount;

        public ResourceBar(Player player, Resource resource) {
            this.player = player;
            int n = player.getResource(resource);
            int n2 = player.getUsage(resource);
            this.target = this.height = (float)(n + n2) * 6.0f;
            this.displayAmount = this.getAmount();
        }

        public boolean update() {
            if (this.target > this.height) {
                this.height += 25.0f * Properties.mule.delta;
                if (this.height > this.target) {
                    this.height = this.target;
                }
                return true;
            }
            if (this.target < this.height) {
                this.height -= 25.0f * Properties.mule.delta;
                if (this.height < this.target) {
                    this.height = this.target;
                }
                return true;
            }
            return false;
        }

        public void updateDisplayAmount() {
            this.displayAmount = this.getAmount();
        }

        public void setTarget(int n) {
            this.target = 6.0f * (float)n;
        }

        public int getIntHeight() {
            return Math.round(this.height);
        }

        public int getAmount() {
            return Math.round(this.height / 6.0f);
        }

        public int getDisplayAmount() {
            return this.displayAmount;
        }
    }
}

