/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.Properties;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.view.Effect;
import com.turborilla.mule.view.ViewProperties;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;

public class ClaimTileEffect
extends Effect {
    public final Image image;
    private float posX;
    private float posY;
    private Color color;
    private float scale;

    public ClaimTileEffect(PlanetTile planetTile, Image image) {
        this.image = image;
        this.posX = planetTile.getPosX() * 64 - 1;
        this.posY = planetTile.getPosY() * 64 - 1;
        this.color = new Color(1.0f, 1.0f, 1.0f, 0.5f);
        this.scale = 1.02f;
    }

    public void update() {
        if (this.color.a > 0.0f) {
            this.color.a -= 0.7f * Properties.mule.delta;
            if (this.color.a <= 0.0f) {
                this.color.a = 0.0f;
            }
            this.scale += 0.57f * Properties.mule.delta;
        }
    }

    public void draw() {
        if (this.color.a > 0.0f) {
            this.image.draw(this.posX - (float)this.image.getWidth() * (this.scale - 1.0f) * 0.5f + (float)ViewProperties.get().mapOffsetX, this.posY - (float)this.image.getHeight() * (this.scale - 1.0f) * 0.5f + (float)ViewProperties.get().mapOffsetY, this.scale, this.color);
        }
    }

    public boolean isFinished() {
        return this.color.a == 0.0f;
    }
}

