/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.view.Transition;
import com.turborilla.mule.view.Transitionable;
import com.turborilla.mule.view.ViewProperties;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.opengl.renderer.Renderer;
import org.newdawn.slick.opengl.renderer.SGL;
import org.newdawn.slick.util.MaskUtil;

public class BlobbyTransition
extends Transition {
    protected static SGL GL = Renderer.get();
    private boolean finish;
    private ArrayList<Blob> blobs = new ArrayList();
    private float timer = 0.5f;
    private int blobCount = 8;
    private float x;
    private float y;
    private float width;
    private float height;

    public static BlobbyTransition createPlayAreaTransition() {
        ViewProperties viewProperties = ViewProperties.get();
        viewProperties.getClass();
        viewProperties.getClass();
        viewProperties.getClass();
        viewProperties.getClass();
        return new BlobbyTransition(10.0f, 10.0f, 620.0f, 360.0f);
    }

    public BlobbyTransition(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.width = f3;
        this.height = f4;
    }

    public boolean isComplete() {
        return this.finish;
    }

    public void update(float f) {
        int n;
        if (this.finish) {
            return;
        }
        if (this.blobs.size() == 0) {
            for (n = 0; n < this.blobCount; ++n) {
                this.blobs.add(new Blob(this.x, this.y, this.width, this.height));
            }
        }
        for (n = 0; n < this.blobs.size(); ++n) {
            this.blobs.get(n).update(f);
        }
        this.timer -= f;
        if (this.timer < 0.0f) {
            this.finish = true;
        }
    }

    void draw(Transitionable transitionable, Transitionable transitionable2, Graphics graphics) {
        if (this.finish) {
            transitionable2.draw();
        } else {
            MaskUtil.defineMask();
            for (int i = 0; i < this.blobs.size(); ++i) {
                this.blobs.get(i).render(graphics);
            }
            MaskUtil.finishDefineMask();
            MaskUtil.drawOffMask();
            transitionable.draw();
            MaskUtil.drawOnMask();
            transitionable2.draw();
            GL11.glDepthMask(false);
            GL11.glDisable(2929);
        }
    }

    private static class Blob {
        private float x;
        private float y;
        private float growSpeed;
        private float rad;

        public Blob(float f, float f2, float f3, float f4) {
            this.x = f + (float)(Math.random() * (double)f3);
            this.y = f2 + (float)(Math.random() * (double)f4);
            this.growSpeed = (float)(500.0 + Math.random() * 300.0);
        }

        public void update(float f) {
            this.rad += this.growSpeed * f;
        }

        public void render(Graphics graphics) {
            graphics.fillOval(this.x - this.rad, this.y - this.rad, this.rad * 2.0f, this.rad * 2.0f);
        }
    }
}

