/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.Properties;
import com.turborilla.mule.view.BlinkerListener;
import java.util.ArrayList;

public class Blinker {
    private boolean visible;
    private float value;
    private float blinksPerSecond;
    private ArrayList<BlinkerListener> listeners;
    private int currentListener = -1;

    public Blinker(float f) {
        this.blinksPerSecond = f;
        this.listeners = new ArrayList();
        this.setVisible(true);
    }

    public void addListener(BlinkerListener blinkerListener) {
        this.listeners.add(blinkerListener);
    }

    public void removeListener(BlinkerListener blinkerListener) {
        int n = this.listeners.indexOf(blinkerListener);
        this.listeners.remove(n);
        if (n >= this.currentListener) {
            --this.currentListener;
        }
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        this.value = 0.0f;
        this.notifyBlink();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public float getSpeed() {
        return this.blinksPerSecond;
    }

    void update() {
        this.value += this.blinksPerSecond * Properties.mule.delta;
        while (this.value > 0.5f) {
            this.value -= 0.5f;
            this.visible = !this.visible;
            this.notifyBlink();
        }
    }

    private void notifyBlink() {
        this.currentListener = 0;
        while (this.currentListener < this.listeners.size()) {
            BlinkerListener blinkerListener = this.listeners.get(this.currentListener);
            blinkerListener.blink(this.visible);
            ++this.currentListener;
        }
        this.currentListener = -1;
    }
}

