/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Logger;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.util.ResourceLoader;

public class AvatarImageStore {
    private Logger logger = Logger.getLogger("mule");
    private HashMap<Long, AvatarImage> avatars = new HashMap();
    private AvatarImage defaultAvatar = new AvatarImage("Default Avatar", ResourceLoader.getResourceAsStream("images/lobby/default_avatar.png"));

    public void putImage(long l, InputStream inputStream) {
        if (inputStream == null) {
            this.logger.severe("Avatar image input stream is null.");
            return;
        }
        try {
            AvatarImage avatarImage = new AvatarImage("Avatar image " + l, inputStream);
            this.avatars.put(l, avatarImage);
        }
        catch (SlickException slickException) {
            this.logger.severe("Failed to load avatar image. " + slickException.toString());
        }
    }

    public AvatarImage getImage(long l) {
        AvatarImage avatarImage = this.avatars.get(l);
        if (avatarImage == null) {
            return this.defaultAvatar;
        }
        return avatarImage;
    }

    public void removeImage(long l) {
        this.avatars.remove(l);
    }

    public static class AvatarImage {
        private Image image;

        public AvatarImage(String string, InputStream inputStream) throws SlickException {
            this.image = new Image(inputStream, string, false, 2);
        }

        public Image getImage() {
            return this.image;
        }
    }
}

