/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.Properties;
import com.turborilla.mule.model.AuctionLimits;
import com.turborilla.mule.model.AuctionState;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.util.NetworkTimer;
import com.turborilla.mule.sound.SoundPlayer;
import com.turborilla.mule.view.ActorPainter;
import com.turborilla.mule.view.ActorSprite;
import com.turborilla.mule.view.AuctionNumberPainter;
import com.turborilla.mule.view.MuleImage;
import com.turborilla.mule.view.View;
import com.turborilla.mule.view.ViewProperties;
import java.util.ArrayList;
import java.util.EnumMap;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuctionPainter {
    private ActorPainter actorPainter;
    private AuctionNumberPainter numberPainter;
    private SoundPlayer sound;
    private MuleImage background;
    private MuleImage auctionHeader;
    private SpriteSheet criticalLights;
    private EnumMap<Resource, Image> resourceHeaders;
    private EnumMap<Resource, Image> signs;
    private MuleImage landAuctionHeader;
    private Image landAuctionSign;
    private MuleImage lineDashed;
    private MuleImage lineSolid;
    private MuleImage lineContact;
    private MuleImage house;
    private final Graphics graphics;
    private boolean showSpoilage = false;
    private Color spoilageColor = new Color(Color.red);
    private float spoilageTimer;
    private View.TextStyle displayStyle;
    private View.TextStyle auctionStyle;
    private Label chooseBuySellLabel;
    private Label landAuctionLabel;
    private Label[] skippedLabels;
    private Label lastAuctionSkipLabel;
    private Label noGoodsLabel;
    private Label goLabel;
    private float goLabelLife;
    private final int xPos;
    private final int yPos;
    private final int topPos;
    private final int bottomPos;
    private final int landAuctionBreakPos;
    private static final int textCenterX = ViewProperties.get().screenWidth / 2 - 2;

    public AuctionPainter(Graphics graphics, ActorPainter actorPainter, AuctionNumberPainter auctionNumberPainter) throws SlickException {
        this.spoilageTimer = Properties.mule.spoilageBlinkTime;
        this.displayStyle = View.TextStyle.HUD;
        this.auctionStyle = View.TextStyle.TERMINAL;
        this.xPos = ViewProperties.get().mapOffsetX;
        this.yPos = ViewProperties.get().mapOffsetY;
        this.topPos = this.yPos + 84;
        this.bottomPos = this.yPos + 259;
        this.landAuctionBreakPos = this.yPos + 230;
        this.graphics = graphics;
        this.actorPainter = actorPainter;
        this.numberPainter = auctionNumberPainter;
        this.sound = SoundPlayer.get();
        this.background = new MuleImage("images/auction3/auction_background.png");
        this.auctionHeader = new MuleImage("images/auction4/auction_header_auction.png");
        this.resourceHeaders = new EnumMap(Resource.class);
        this.resourceHeaders.put(Resource.Food, new MuleImage("images/auction4/auction_header_food.png"));
        this.resourceHeaders.put(Resource.Energy, new MuleImage("images/auction4/auction_header_energy.png"));
        this.resourceHeaders.put(Resource.Smithore, new MuleImage("images/auction4/auction_header_smithore.png"));
        this.resourceHeaders.put(Resource.Crystite, new MuleImage("images/auction4/auction_header_crystite.png"));
        this.landAuctionHeader = new MuleImage("images/auction4/auction_header_land.png");
        this.signs = new EnumMap(Resource.class);
        SpriteSheet spriteSheet = new SpriteSheet(new MuleImage("images/auction3/auction_signs2.png"), 70, 80);
        this.signs.put(Resource.Crystite, spriteSheet.getSprite(0, 0));
        this.signs.put(Resource.Smithore, spriteSheet.getSprite(1, 0));
        this.signs.put(Resource.Energy, spriteSheet.getSprite(2, 0));
        this.signs.put(Resource.Food, spriteSheet.getSprite(3, 0));
        this.landAuctionSign = spriteSheet.getSprite(4, 0);
        this.lineDashed = new MuleImage("images/auction2/auction_line_dashed.png", Color.magenta);
        this.lineSolid = new MuleImage("images/auction2/auction_line_solid.png", Color.magenta);
        this.lineContact = new MuleImage("images/auction3/auction_line_contact.png", Color.magenta);
        this.house = new MuleImage("images/auction/auction_shopicon.png", Color.magenta);
        this.criticalLights = new SpriteSheet(new MuleImage("images/auction3/auction_lights.png"), 11, 6);
        this.chooseBuySellLabel = new Label("Press Stick to Declare", "Buyer or Seller", "");
        this.landAuctionLabel = new Label("Land Auction", "");
        this.noGoodsLabel = new Label("No Goods", "For Sale");
        this.goLabel = new Label("Go!");
        this.lastAuctionSkipLabel = new Label("Final", "Month");
        this.skippedLabels = new Label[Resource.values().length];
        for (int i = 0; i < Resource.values().length; ++i) {
            this.skippedLabels[i] = new Label(Resource.get(i).getName(), "Skipped");
        }
    }

    public void update() {
        this.spoilageTimer -= Properties.mule.delta;
        if (this.spoilageTimer <= 0.0f) {
            if (this.showSpoilage) {
                if (this.spoilageColor.a == 1.0f) {
                    this.spoilageColor.a = 0.0f;
                } else {
                    this.spoilageColor.a = 1.0f;
                    this.sound.playSpoilage();
                }
            }
            this.spoilageTimer += Properties.mule.spoilageBlinkTime;
        }
        if (this.goLabelLife > 0.0f) {
            this.goLabelLife -= 2.2f * Properties.mule.delta;
            if (this.goLabelLife < 0.0f) {
                this.goLabelLife = 0.0f;
            }
            this.goLabel.setAlpha(Math.min(1.0f, this.goLabelLife));
        }
    }

    public void setShowSpoilage(boolean bl) {
        this.spoilageColor.a = 1.0f;
        this.spoilageTimer = Properties.mule.spoilageBlinkTime;
        this.showSpoilage = bl;
        if (bl) {
            this.sound.playSpoilage();
        }
    }

    public void startGoText() {
        this.goLabelLife = 2.0f;
    }

    public void drawAuction(Resource resource, int n, boolean bl) {
        this.background.draw(8.0f, 8.0f);
        Image image = this.signs.get((Object)resource);
        Image image2 = this.resourceHeaders.get((Object)resource);
        if (resource == null) {
            image = this.landAuctionSign;
            image2 = this.landAuctionHeader;
        }
        image.draw(this.xPos - 12, this.yPos + 2);
        if (bl) {
            int n2 = image2.getWidth() + this.auctionHeader.getWidth() + 8;
            int n3 = textCenterX - (n2 += this.numberPainter.getWidth(n)) / 2;
            int n4 = this.yPos - 12;
            image2.draw(n3, n4);
            this.auctionHeader.draw(n3 += image2.getWidth(), n4);
            this.numberPainter.draw(n, n3 += this.auctionHeader.getWidth() + 8, n4);
        }
    }

    public void drawShopPrices(Resource resource, int n, int n2, int n3, AuctionLimits auctionLimits, boolean bl) {
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        int n7 = n5;
        if (auctionLimits != null) {
            n7 = auctionLimits.getMinPrice();
        }
        if (resource != Resource.Crystite && n4 > 0) {
            this.displayStyle.printCentered("" + n4, this.xPos + 551, this.yPos + 28);
            this.house.draw(this.xPos + 537, this.yPos + 66);
            this.displayStyle.printCentered("$" + n6, this.xPos + 551, this.yPos + 50);
        }
        this.drawBottomPrice(n7, bl);
        if (!bl) {
            this.house.draw(this.xPos + 8, this.yPos + 242);
        }
    }

    public void drawBottomPrice(int n, boolean bl) {
        if (bl) {
            this.displayStyle.printCentered("$" + n, this.xPos + 551, this.yPos + 271);
        } else {
            this.displayStyle.printCentered("$" + n, this.xPos + 22, this.yPos + 226);
        }
    }

    public void drawPlayers(ArrayList<Player> arrayList, AuctionLimits auctionLimits, boolean bl, boolean bl2, boolean bl3) {
        int n;
        if (auctionLimits.auctionSellTick == auctionLimits.auctionBuyTick) {
            n = this.tickToPosition(auctionLimits.auctionBuyTick, auctionLimits.minTick, auctionLimits.maxTick);
            this.lineSolid.draw(this.xPos + 82, n - 2);
        } else {
            if (bl) {
                n = this.tickToPosition(Math.min(auctionLimits.auctionSellTick, auctionLimits.maxTick), auctionLimits.minTick, auctionLimits.maxTick);
                this.lineDashed.draw(this.xPos + 82, n - 2);
            }
            if (bl2) {
                n = this.tickToPosition(Math.max(auctionLimits.auctionBuyTick, auctionLimits.minTick), auctionLimits.minTick, auctionLimits.maxTick);
                this.lineDashed.draw(this.xPos + 82, n - 2);
            }
        }
        for (Player player : arrayList) {
            int n2 = player.getPlayerIndex();
            int n3 = this.xPos + 132 + n2 * 104;
            int n4 = 0;
            AuctionState auctionState = player.getAuctionState();
            n4 = auctionState.isInAuction() ? this.tickToPosition(auctionState.getTick(), auctionLimits.minTick, auctionLimits.maxTick) : (player.isBuyer() ? this.bottomPos - auctionState.getTick() / auctionLimits.getPixelRatio() : this.topPos - auctionState.getTick() / auctionLimits.getPixelRatio());
            ActorSprite actorSprite = player.getAvatar().getSprite();
            float f = (float)n3 - actorSprite.getCenterX();
            float f2 = (float)n4 - actorSprite.getCenterY() - 6.0f;
            this.actorPainter.drawActor(player.getAvatar(), f, f2, 1.0f);
            if (!bl3) continue;
            if (auctionState.isInAuction()) {
                this.auctionStyle.printCentered("$" + auctionState.getPrice(auctionLimits), n3, n4 + 6);
                continue;
            }
            if (player.isBuyer()) {
                this.auctionStyle.print("BUY", this.xPos + 147 + n2 * 104, this.yPos + 268);
                continue;
            }
            this.auctionStyle.print("SELL", this.xPos + 147 + n2 * 104, this.yPos + 55);
        }
    }

    public void drawLandAuctionPlayers(ArrayList<Player> arrayList, AuctionLimits auctionLimits) {
        this.lineDashed.draw(this.xPos + 82, this.bottomPos - 2);
        int n = this.tickToLandAuctionPos(Math.max(auctionLimits.auctionBuyTick, auctionLimits.minTick), auctionLimits);
        this.lineDashed.draw(this.xPos + 82, n - 2);
        for (Player player : arrayList) {
            int n2 = player.getPlayerIndex();
            int n3 = this.xPos + 132 + n2 * 104;
            int n4 = 0;
            AuctionState auctionState = player.getAuctionState();
            n4 = auctionState.isInAuction() ? this.tickToLandAuctionPos(auctionState.getTick(), auctionLimits) : (player.isBuyer() ? this.bottomPos - auctionState.getTick() / auctionLimits.getPixelRatio() : this.topPos - auctionState.getTick() / auctionLimits.getPixelRatio());
            ActorSprite actorSprite = player.getAvatar().getSprite();
            float f = (float)n3 - actorSprite.getCenterX();
            float f2 = (float)n4 - actorSprite.getCenterY() - 6.0f;
            this.actorPainter.drawActor(player.getAvatar(), f, f2, 1.0f);
            if (auctionState.isInAuction()) {
                this.auctionStyle.printCentered("$" + auctionState.getPrice(auctionLimits), n3, n4 + 6);
                continue;
            }
            if (player.isBuyer()) {
                this.auctionStyle.print("BUY", this.xPos + 147 + n2 * 104, this.yPos + 268);
                continue;
            }
            this.auctionStyle.print("SELL", this.xPos + 147 + n2 * 104, this.yPos + 55);
        }
    }

    public void drawAmount(Resource resource, ArrayList<Player> arrayList) {
        for (Player player : arrayList) {
            int n = player.getResource(resource);
            String string = "" + n;
            this.drawDisplay(player, string, -1);
        }
    }

    public void drawCritical(Resource resource, ArrayList<Player> arrayList, int n, int n2) {
        for (Player player : arrayList) {
            int n3 = player.getResource(resource) - player.getResourceCritical(resource, n, n2);
            String string = "" + n3;
            int n4 = n3 < 0 ? 0 : 1;
            this.drawDisplay(player, string, n4);
        }
    }

    void drawDisplay(Player player, String string, int n) {
        int n2 = player.getPlayerIndex();
        this.displayStyle.printCentered(string, this.xPos + 132 + 104 * n2, this.yPos + 293);
        if (n >= 0) {
            Image image = this.criticalLights.getSprite(n, 0);
            image.draw(this.xPos + 150 + 104 * n2, this.yPos + 304);
        }
    }

    private int tickToLandAuctionPos(int n, AuctionLimits auctionLimits) {
        int n2 = this.tickToPosition(n, auctionLimits.getStartMinTick(), auctionLimits.getStartMaxTick());
        if (n2 < this.landAuctionBreakPos && (n2 = this.tickToPosition(n, auctionLimits.minTick, auctionLimits.maxTick)) > this.landAuctionBreakPos) {
            n2 = this.landAuctionBreakPos;
        }
        return n2;
    }

    public int tickToPosition(int n, int n2, int n3) {
        float f = (float)(n - n2) / (float)(n3 - n2);
        if (f < 0.0f) {
            return this.bottomPos;
        }
        if (f > 1.0f) {
            return this.topPos;
        }
        return Math.round((float)this.bottomPos + (float)(this.topPos - this.bottomPos) * f);
    }

    public void drawTimer(NetworkTimer networkTimer) {
        int n;
        int n2 = 18;
        int n3 = n = 122;
        if (networkTimer.isStarted() && (n3 = Math.round(networkTimer.getTime() / networkTimer.getTotalTime() * (float)n)) == 0 && !networkTimer.isFinished()) {
            n3 = 1;
        }
        int n4 = this.xPos + 543;
        int n5 = this.yPos + 108;
        this.graphics.setColor(ViewProperties.get().hudTextColor);
        this.graphics.fillRect(n4, n5 + (n - n3), n2, n3);
    }

    public void drawLandAuctionLabel(String string) {
        this.landAuctionLabel.setRow(1, string);
        this.landAuctionLabel.draw(this.graphics);
    }

    public void drawLandAuctionCountdown(int n) {
        this.auctionStyle.printCentered("" + n, textCenterX, 185);
    }

    public void drawChooseBuySell(String string) {
        this.chooseBuySellLabel.setRow(2, string);
        this.chooseBuySellLabel.draw(this.graphics);
    }

    public void drawAuctionSkipped(Resource resource) {
        this.skippedLabels[resource.ordinal()].draw(this.graphics);
    }

    public void drawLastAuctionSkipped() {
        this.lastAuctionSkipLabel.draw(this.graphics);
    }

    public void drawNoGoodsForSale() {
        this.noGoodsLabel.draw(this.graphics);
    }

    public void drawGoText() {
        if (this.goLabel.getAlpha() != 0.0f) {
            this.goLabel.draw(this.graphics);
        }
    }

    public void drawCollectionTitle(String string) {
        if (string != null) {
            this.auctionStyle.printCentered(string, textCenterX, 353);
        }
    }

    private static class Label {
        private static View.TextStyle style = View.TextStyle.TERMINAL;
        private String[] rows;
        private int x;
        private int y;
        private int width;
        private int height;
        private Color textColor;
        private Color backgroundColor;
        private static final int horizontalPadding = 19;
        private static final int verticalPadding = 10;
        private static final int lineHeight = style.getLineHeight();
        private static final int lineSpacing = 0;

        public Label(String ... stringArray) {
            this.textColor = new Color(Label.style.color);
            this.backgroundColor = new Color(Color.black);
            this.rows = stringArray;
            this.width = 0;
            this.height = stringArray.length * lineHeight + (stringArray.length - 1) * 0;
            for (String string : stringArray) {
                int n = style.getWidth(string);
                if (n <= this.width) continue;
                this.width = n;
            }
            this.width += 38;
            this.height += 20;
            this.x = textCenterX - this.width / 2;
            this.y = 195 - this.height / 2;
        }

        public void setRow(int n, String string) {
            this.rows[n] = string;
        }

        public float getAlpha() {
            return this.textColor.a;
        }

        public void setAlpha(float f) {
            this.textColor.a = f;
            this.backgroundColor.a = f;
        }

        public void draw(Graphics graphics) {
            for (int i = 0; i < this.rows.length; ++i) {
                String string = this.rows[i];
                style.printCentered(string, this.textColor, textCenterX, this.y + 10 + i * (lineHeight + 0));
            }
        }
    }
}

