/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import java.util.ArrayList;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;

public class AnimatedSprite {
    private SpriteSheet spriteSheet;
    private ArrayList<Animation> animations;
    private Animation animation;
    private int width;
    private int height;
    private boolean autoUpdate = true;

    public AnimatedSprite(SpriteSheet spriteSheet) {
        this.spriteSheet = spriteSheet;
        this.animations = new ArrayList();
        this.width = spriteSheet.getSubImage(0, 0).getWidth();
        this.height = spriteSheet.getSubImage(0, 0).getHeight();
    }

    public AnimatedSprite(String string, int n, int n2) throws SlickException {
        this(new SpriteSheet(string, n, n2, Color.magenta));
    }

    public AnimatedSprite(SpriteSheet spriteSheet, int n) throws SlickException {
        this(spriteSheet);
        int[] nArray = new int[spriteSheet.getHorizontalCount()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        this.createAnimation(nArray, n);
    }

    public AnimatedSprite(String string, int n, int n2, int n3) throws SlickException {
        this(new SpriteSheet(string, n, n2, Color.magenta), n3);
    }

    public void setAnimation(int n) {
        this.animation = this.animations.get(n);
    }

    public Animation getAnimation(int n) {
        return this.animations.get(n);
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public Animation createAnimation(int[] nArray, int n) {
        int n2 = this.spriteSheet.getHorizontalCount();
        Image[] imageArray = new Image[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i] % n2;
            int n4 = nArray[i] / n2;
            imageArray[i] = this.spriteSheet.getSubImage(n3, n4);
        }
        Animation animation = new Animation(imageArray, n, this.autoUpdate);
        this.animations.add(animation);
        if (this.animation == null) {
            this.animation = animation;
        }
        return animation;
    }

    public void draw(float f, float f2) {
        this.animation.draw(f, f2);
    }

    public void drawCentered(float f, float f2) {
        this.drawCentered(f, f2, Color.white);
    }

    public void drawCentered(float f, float f2, Color color) {
        this.animation.draw(f -= (float)(this.width / 2), f2 -= (float)(this.height / 2), color);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setAutoUpdate(boolean bl) {
        this.autoUpdate = bl;
        for (Animation animation : this.animations) {
            animation.setAutoUpdate(bl);
        }
    }
}

