/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.MuleException;
import com.turborilla.mule.view.MuleAnimation;
import com.turborilla.mule.view.SpriteLoader;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Vector2f;

public class ActorSprite {
    private MuleAnimation north;
    private MuleAnimation south;
    private MuleAnimation east;
    private MuleAnimation west;
    private MuleAnimation idleNorth;
    private MuleAnimation idleSouth;
    private MuleAnimation idleEast;
    private MuleAnimation idleWest;
    private Direction direction = Direction.South;
    private float centerX = 0.0f;
    private float centerY = 0.0f;
    private boolean idle = true;
    private boolean alwaysIdleSouth = false;
    private static final boolean autoUpdate = true;

    public boolean isIdle() {
        return this.idle;
    }

    public float getCenterX() {
        return this.centerX;
    }

    public float getCenterY() {
        return this.centerY;
    }

    public void setDirection(Direction direction) {
        if (direction != this.direction) {
            this.getAnimation().stop();
            this.direction = direction;
            this.getAnimation().start();
        }
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setIdle(boolean bl) {
        if (this.idle != bl) {
            this.getAnimation().stop();
            this.idle = bl;
            this.getAnimation().start();
        }
    }

    public void setAlwaysIdleSouth(boolean bl) {
        this.alwaysIdleSouth = bl;
    }

    public MuleAnimation getAnimation() {
        return this.getAnimation(this.direction, this.idle);
    }

    public MuleAnimation getAnimation(Direction direction, boolean bl) {
        if (bl) {
            if (this.alwaysIdleSouth) {
                return this.idleSouth;
            }
            switch (direction) {
                case North: {
                    return this.idleNorth;
                }
                case South: {
                    return this.idleSouth;
                }
                case East: {
                    return this.idleEast;
                }
                case West: {
                    return this.idleWest;
                }
            }
            return this.idleSouth;
        }
        switch (direction) {
            case North: {
                return this.north;
            }
            case South: {
                return this.south;
            }
            case East: {
                return this.east;
            }
            case West: {
                return this.west;
            }
        }
        return this.south;
    }

    public void setAutoUpdate(boolean bl) {
        this.north.setAutoUpdate(bl);
        this.east.setAutoUpdate(bl);
        this.west.setAutoUpdate(bl);
        this.south.setAutoUpdate(bl);
        this.idleSouth.setAutoUpdate(bl);
        this.idleNorth.setAutoUpdate(bl);
        this.idleEast.setAutoUpdate(bl);
        this.idleWest.setAutoUpdate(bl);
    }

    public static ActorSprite createAvatar(String string, int n, float f, boolean bl) throws MuleException {
        try {
            SpriteSheet spriteSheet = SpriteLoader.getAvatarSpriteSheet(string, n, bl);
            ActorSprite actorSprite = new ActorSprite();
            int n2 = ActorSprite.calcAvatarFrameDuration(bl, false, f);
            actorSprite.south = ActorSprite.createAnimation(spriteSheet, new int[]{3, 4, 5, 6, 7, 8, 1, 2}, n2);
            actorSprite.north = ActorSprite.createAnimation(spriteSheet, new int[]{11, 12, 13, 14, 15, 16, 9, 10}, n2);
            actorSprite.west = ActorSprite.createAnimation(spriteSheet, new int[]{19, 20, 21, 22, 23, 24, 17, 18}, n2);
            actorSprite.east = ActorSprite.createAnimation(spriteSheet, new int[]{27, 28, 29, 30, 31, 32, 25, 26}, n2);
            n2 = ActorSprite.calcAvatarFrameDuration(bl, true, f);
            actorSprite.idleSouth = ActorSprite.createAnimation(spriteSheet, new int[]{0}, n2);
            actorSprite.idleNorth = ActorSprite.createAnimation(spriteSheet, new int[]{13}, n2);
            actorSprite.idleWest = ActorSprite.createAnimation(spriteSheet, new int[]{21}, n2);
            actorSprite.idleEast = ActorSprite.createAnimation(spriteSheet, new int[]{29}, n2);
            if (bl) {
                actorSprite.alwaysIdleSouth = true;
            }
            actorSprite.centerX = bl ? 16.0f : 8.0f;
            actorSprite.centerY = bl ? 40.0f : 20.0f;
            return actorSprite;
        }
        catch (Exception exception) {
            throw new MuleException(exception);
        }
    }

    private static int calcAvatarFrameDuration(boolean bl, boolean bl2, float f) {
        if (bl2) {
            return 500;
        }
        return Math.round(60.0f / f);
    }

    public static ActorSprite createMule(boolean bl) {
        ActorSprite actorSprite = ActorSprite.createMuleSprite("mule", -1, bl);
        if (bl) {
            actorSprite.centerX = 32.0f;
            actorSprite.centerY = 70.0f;
        } else {
            actorSprite.centerX = 16.0f;
            actorSprite.centerY = 36.0f;
        }
        return actorSprite;
    }

    public static ActorSprite createMuleEquipment(String string, int n, boolean bl) {
        ActorSprite actorSprite = ActorSprite.createMuleSprite(string, n, bl);
        actorSprite.setAutoUpdate(false);
        if (bl) {
            actorSprite.centerX = 32.0f;
            actorSprite.centerY = 71.0f;
        } else {
            actorSprite.centerX = 16.0f;
            actorSprite.centerY = 36.0f;
        }
        return actorSprite;
    }

    public static ActorSprite createAssayBot(boolean bl) {
        SpriteSheet spriteSheet = SpriteLoader.getAssayBotSpriteSheet(bl);
        ActorSprite actorSprite = new ActorSprite();
        int n = bl ? 100 : 100;
        actorSprite.south = ActorSprite.createAnimation(spriteSheet, new int[]{1, 0, 2}, n);
        actorSprite.north = ActorSprite.createAnimation(spriteSheet, new int[]{4, 3, 5}, n);
        actorSprite.west = ActorSprite.createAnimation(spriteSheet, new int[]{7, 6, 8}, n);
        actorSprite.east = ActorSprite.createAnimation(spriteSheet, new int[]{10, 9, 11}, n);
        n = 1500;
        actorSprite.idleSouth = actorSprite.south;
        actorSprite.idleNorth = actorSprite.north;
        actorSprite.idleWest = actorSprite.west;
        actorSprite.idleEast = actorSprite.east;
        if (bl) {
            actorSprite.centerX = 17.0f;
            actorSprite.centerY = 37.0f;
        } else {
            actorSprite.centerX = 9.0f;
            actorSprite.centerY = 18.0f;
        }
        return actorSprite;
    }

    private static ActorSprite createMuleSprite(String string, int n, boolean bl) {
        SpriteSheet spriteSheet = SpriteLoader.getMuleSpriteSheet(string, n, bl);
        ActorSprite actorSprite = new ActorSprite();
        int n2 = bl ? 120 : 140;
        actorSprite.south = ActorSprite.createAnimation(spriteSheet, new int[]{1, 0, 2}, n2);
        actorSprite.north = ActorSprite.createAnimation(spriteSheet, new int[]{4, 3, 5}, n2);
        actorSprite.west = ActorSprite.createAnimation(spriteSheet, new int[]{7, 6, 8}, n2);
        actorSprite.east = ActorSprite.createAnimation(spriteSheet, new int[]{10, 9, 11}, n2);
        n2 = 1500;
        actorSprite.idleSouth = ActorSprite.createAnimation(spriteSheet, new int[]{0}, n2);
        actorSprite.idleNorth = ActorSprite.createAnimation(spriteSheet, new int[]{3}, n2);
        if (bl) {
            actorSprite.idleWest = ActorSprite.createAnimation(spriteSheet, new int[]{6, 12}, n2);
            actorSprite.idleWest.setDuration(1, 180);
            actorSprite.idleEast = ActorSprite.createAnimation(spriteSheet, new int[]{9, 13}, n2);
            actorSprite.idleEast.setDuration(1, 180);
        } else {
            actorSprite.idleWest = ActorSprite.createAnimation(spriteSheet, new int[]{6}, n2);
            actorSprite.idleEast = ActorSprite.createAnimation(spriteSheet, new int[]{9}, n2);
        }
        return actorSprite;
    }

    private static MuleAnimation createAnimation(SpriteSheet spriteSheet, int[] nArray, int n) {
        MuleAnimation muleAnimation = new MuleAnimation(spriteSheet, nArray, n, true);
        muleAnimation.setSpeed(1.0f);
        muleAnimation.setLooping(true);
        return muleAnimation;
    }

    private ActorSprite() {
    }

    public int getFrame() {
        return this.getAnimation().getFrame();
    }

    public void setFrame(int n) {
        this.getAnimation().setCurrentFrame(n);
    }

    public void setAvatarSpriteSheet(String string, int n, boolean bl, float f) {
        SpriteSheet spriteSheet = SpriteLoader.getAvatarSpriteSheet(string, n, bl);
        int n2 = ActorSprite.calcAvatarFrameDuration(bl, false, f);
        this.north.setSpriteSheet(spriteSheet, n2);
        this.south.setSpriteSheet(spriteSheet, n2);
        this.east.setSpriteSheet(spriteSheet, n2);
        this.west.setSpriteSheet(spriteSheet, n2);
        n2 = ActorSprite.calcAvatarFrameDuration(bl, true, f);
        this.idleNorth.setSpriteSheet(spriteSheet, n2);
        this.idleSouth.setSpriteSheet(spriteSheet, n2);
        this.idleEast.setSpriteSheet(spriteSheet, n2);
        this.idleWest.setSpriteSheet(spriteSheet, n2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        North(1, new Vector2f(0.0f, -1.0f)),
        South(2, new Vector2f(0.0f, 1.0f)),
        East(3, new Vector2f(1.0f, 0.0f)),
        West(4, new Vector2f(-1.0f, 0.0f)),
        None(-1, new Vector2f(0.0f, 0.0f));

        public final int value;
        public final Vector2f vector;

        private Direction(int n2, Vector2f vector2f) {
            this.value = n2;
            this.vector = vector2f;
        }

        public static Direction get(int n) {
            switch (n) {
                case 1: {
                    return North;
                }
                case 2: {
                    return South;
                }
                case 3: {
                    return East;
                }
                case 4: {
                    return West;
                }
            }
            return None;
        }

        public static Direction get(float f, float f2) {
            if (2.0f * Math.abs(f) > Math.abs(f2)) {
                if (f < 0.0f) {
                    return West;
                }
                if (f > 0.0f) {
                    return East;
                }
            } else {
                if (f2 < 0.0f) {
                    return North;
                }
                if (f2 > 0.0f) {
                    return South;
                }
            }
            return None;
        }
    }
}

