/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.model.Actor;
import com.turborilla.mule.model.Avatar;
import com.turborilla.mule.model.Mule;
import com.turborilla.mule.model.MuleEquipment;
import com.turborilla.mule.model.util.Vec2;
import com.turborilla.mule.view.ActorSprite;
import com.turborilla.mule.view.MuleAnimation;
import com.turborilla.mule.view.ViewProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActorPainter {
    private ActorDrawable[] actorList = new ActorDrawable[0];
    private YOrdering actorOrdering = new YOrdering();
    private Collection<Actor> emptyActorCollection = new ArrayList<Actor>();
    private Graphics graphics;
    private static final Color drawColor = new Color(Color.white);
    private static final Color blinkColor = new Color(Color.black);
    private static final float transparentAlpha = 0.3f;

    public ActorPainter(Graphics graphics) {
        this.graphics = graphics;
    }

    public void draw(Collection<Actor> collection) {
        this.draw(collection, this.emptyActorCollection);
    }

    public void draw(Collection<Actor> collection, Collection<Actor> collection2) {
        int n;
        int n2 = collection.size() + collection2.size();
        if (n2 > this.actorList.length) {
            this.actorList = new ActorDrawable[n2];
            for (n = 0; n < n2; ++n) {
                this.actorList[n] = new ActorDrawable();
            }
        }
        n = 0;
        for (Actor actor : collection2) {
            this.actorList[n].alpha = 0.3f;
            this.actorList[n].actor = actor;
            ++n;
        }
        for (Actor actor : collection) {
            this.actorList[n].alpha = 1.0f;
            this.actorList[n].actor = actor;
            ++n;
        }
        Arrays.sort(this.actorList, 0, n2, this.actorOrdering);
        for (int i = 0; i < n2; ++i) {
            Actor actor;
            actor = this.actorList[i].actor;
            float f = this.actorList[i].alpha;
            if (actor == null) break;
            this.drawActor(actor, f);
        }
    }

    private void drawActor(Actor actor, float f) {
        Vec2 vec2 = actor.getPosition();
        ActorSprite actorSprite = actor.getSprite();
        float f2 = vec2.x;
        float f3 = vec2.y;
        if (actor.isInShop()) {
            ViewProperties.get().getClass();
            f2 += 100.0f;
            ViewProperties.get().getClass();
            f3 += 16.0f;
        } else {
            f2 += (float)ViewProperties.get().mapOffsetX;
            f3 += (float)ViewProperties.get().mapOffsetY;
        }
        f2 = (float)Math.floor(f2 - actorSprite.getCenterX() + 0.5f);
        f3 = (float)Math.floor(f3 - actorSprite.getCenterY() + 0.5f);
        this.drawActor(actor, f2, f3, f);
        if (actor instanceof Mule) {
            Mule mule = (Mule)actor;
            MuleEquipment muleEquipment = mule.getEquipment();
            if (mule.isEquipmentVisible()) {
                muleEquipment.update();
                this.drawActor(muleEquipment, f);
            }
        }
    }

    protected void drawActor(Actor actor, float f, float f2, float f3) {
        MuleAnimation muleAnimation = actor.getSprite().getAnimation();
        Color color = actor.getColor();
        ActorPainter.drawColor.r = color.r;
        ActorPainter.drawColor.g = color.g;
        ActorPainter.drawColor.b = color.b;
        if (actor.getBlinkType() == 1) {
            ActorPainter.drawColor.a = color.a * f3;
            muleAnimation.draw(f, f2, drawColor);
            if (actor.getBlink().isBlinking()) {
                ActorPainter.blinkColor.a = actor.getBlink().getAlpha();
                muleAnimation.draw(f, f2, blinkColor);
            }
        } else {
            ActorPainter.drawColor.a = actor.getBlink().getAlpha() < 0.5f ? color.a : color.a * 0.1f;
            muleAnimation.draw(f, f2, drawColor);
        }
    }

    public void drawMini(Avatar avatar, Vec2 vec2) {
        float f = vec2.x + (float)ViewProperties.get().mapOffsetX;
        float f2 = vec2.y + (float)ViewProperties.get().mapOffsetY - 3.0f;
        ActorSprite actorSprite = avatar.getSmallSprite();
        MuleAnimation muleAnimation = actorSprite.getAnimation(ActorSprite.Direction.South, true);
        float f3 = 0.4f * (float)muleAnimation.getWidth();
        float f4 = 0.4f * (float)muleAnimation.getHeight();
        muleAnimation.draw(f - f3 / 2.0f, f2 - f4 / 2.0f, f3, f4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class YOrdering
    implements Comparator<ActorDrawable> {
        private YOrdering() {
        }

        @Override
        public int compare(ActorDrawable actorDrawable, ActorDrawable actorDrawable2) {
            Actor actor = actorDrawable.actor;
            Actor actor2 = actorDrawable2.actor;
            if (actor == null) {
                if (actor2 == null) {
                    return 0;
                }
                return 1;
            }
            if (actor2 == null) {
                return -1;
            }
            float f = actor.getPosition().y;
            float f2 = actor2.getPosition().y;
            if (f < f2) {
                return -1;
            }
            if (f > f2) {
                return 1;
            }
            return 0;
        }
    }

    private static class ActorDrawable {
        public float alpha;
        public Actor actor;

        private ActorDrawable() {
        }
    }
}

